"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SdkHandler = exports.flatten = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
function flatten(object) {
    return Object.assign({}, ...function _flatten(child, path = []) {
        return [].concat(...Object.keys(child)
            .map(key => {
            const childKey = Buffer.isBuffer(child[key]) ? child[key].toString('utf8') : child[key];
            return typeof childKey === 'object' && childKey !== null
                ? _flatten(childKey, path.concat([key]))
                : ({ [path.concat([key]).join('.')]: childKey });
        }));
    }(object));
}
exports.flatten = flatten;
class SdkHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        // eslint-disable-next-line
        const AWS = require('aws-sdk');
        console.log(`AWS SDK VERSION: ${AWS.VERSION}`);
        const service = new AWS[request.service]();
        const response = await service[request.api](request.parameters && decode(request.parameters)).promise();
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.ResponseMetadata;
        const respond = {
            apiCallResponse: response,
        };
        const flatData = {
            ...flatten(respond),
        };
        return request.flattenResponse === 'true' ? flatData : respond;
    }
}
exports.SdkHandler = SdkHandler;
function decode(object) {
    return JSON.parse(JSON.stringify(object), (_k, v) => {
        switch (v) {
            case 'TRUE:BOOLEAN':
                return true;
            case 'FALSE:BOOLEAN':
                return false;
            default:
                return v;
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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