"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.md5hash = void 0;
const crypto = require("crypto");
function md5hash(obj) {
    if (!obj || (typeof (obj) === 'object' && Object.keys(obj).length === 0)) {
        throw new Error('Cannot compute md5 hash for falsy object');
    }
    const hash = crypto.createHash('md5');
    hash.update(JSON.stringify(obj));
    return hash.digest('hex');
}
exports.md5hash = md5hash;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFzaC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhhc2gudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsaUNBQWlDO0FBRWpDLFNBQWdCLE9BQU8sQ0FBQyxHQUFRO0lBQzlCLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFNLENBQUMsR0FBRyxDQUFDLEtBQUssUUFBUSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQyxFQUFFO1FBQ3ZFLE1BQU0sSUFBSSxLQUFLLENBQUMsMENBQTBDLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdEMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQzVCLENBQUM7QUFQRCwwQkFPQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNyeXB0byBmcm9tICdjcnlwdG8nO1xuXG5leHBvcnQgZnVuY3Rpb24gbWQ1aGFzaChvYmo6IGFueSk6IHN0cmluZyB7XG4gIGlmICghb2JqIHx8ICh0eXBlb2Yob2JqKSA9PT0gJ29iamVjdCcgJiYgT2JqZWN0LmtleXMob2JqKS5sZW5ndGggPT09IDApKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3QgY29tcHV0ZSBtZDUgaGFzaCBmb3IgZmFsc3kgb2JqZWN0Jyk7XG4gIH1cbiAgY29uc3QgaGFzaCA9IGNyeXB0by5jcmVhdGVIYXNoKCdtZDUnKTtcbiAgaGFzaC51cGRhdGUoSlNPTi5zdHJpbmdpZnkob2JqKSk7XG4gIHJldHVybiBoYXNoLmRpZ2VzdCgnaGV4Jyk7XG59XG4iXX0=