import { CustomResource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IAssertion } from './deploy-assert';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options for an EqualsAssertion
 */
export interface EqualsAssertionProps {
    /**
     * The CustomResource that continains the "actual" results
     */
    readonly inputResource: CustomResource;
    /**
     * The CustomResource attribute that continains the "actual" results
     */
    readonly inputResourceAtt: string;
    /**
     * The expected result to assert
     */
    readonly expected: any;
}
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
export declare class EqualsAssertion extends CoreConstruct implements IAssertion {
    readonly result: string;
    constructor(scope: Construct, id: string, props: EqualsAssertionProps);
}
