<a id="mypy-boto3-swf"></a>

# mypy-boto3-swf

[![PyPI - mypy-boto3-swf](https://img.shields.io/pypi/v/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-swf?color=blue)](https://pypistats.org/packages/mypy-boto3-swf)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SWF 1.18.61](https://boto3.amazonaws.com/v1/documentation/api/1.18.61/reference/services/swf.html#SWF)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-swf docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_swf/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-swf](#mypy-boto3-swf)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SWF` service.

```bash
python -m pip install boto3-stubs[swf]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[swf]` in your environment:
  `python -m pip install 'boto3-stubs[swf]'`

Both type checking and auto-complete should work for `SWF` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[swf]` in your environment:
  `python -m pip install 'boto3-stubs[swf]'`

Both type checking and auto-complete should work for `SWF` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[swf]` in your environment:
  `python -m pip install 'boto3-stubs[swf]'`
- Run `mypy` as usual

Type checking should work for `SWF` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[swf]` in your environment:
  `python -m pip install 'boto3-stubs[swf]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SWF` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SWFClient` provides annotations for `boto3.client("swf")`.

```python
import boto3

from mypy_boto3_swf import SWFClient

client: SWFClient = boto3.client("swf")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SWFClient = session.client("swf")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_swf.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_swf import SWFClient
from mypy_boto3_swf.paginator import (
    GetWorkflowExecutionHistoryPaginator,
    ListActivityTypesPaginator,
    ListClosedWorkflowExecutionsPaginator,
    ListDomainsPaginator,
    ListOpenWorkflowExecutionsPaginator,
    ListWorkflowTypesPaginator,
    PollForDecisionTaskPaginator,
)

client: SWFClient = boto3.client("swf")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_workflow_execution_history_paginator: GetWorkflowExecutionHistoryPaginator = client.get_paginator("get_workflow_execution_history")
list_activity_types_paginator: ListActivityTypesPaginator = client.get_paginator("list_activity_types")
list_closed_workflow_executions_paginator: ListClosedWorkflowExecutionsPaginator = client.get_paginator("list_closed_workflow_executions")
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_open_workflow_executions_paginator: ListOpenWorkflowExecutionsPaginator = client.get_paginator("list_open_workflow_executions")
list_workflow_types_paginator: ListWorkflowTypesPaginator = client.get_paginator("list_workflow_types")
poll_for_decision_task_paginator: PollForDecisionTaskPaginator = client.get_paginator("poll_for_decision_task")
```

<a id="literals"></a>

### Literals

`mypy_boto3_swf.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_swf.literals import (
    ActivityTaskTimeoutTypeType,
    CancelTimerFailedCauseType,
    CancelWorkflowExecutionFailedCauseType,
    ChildPolicyType,
    CloseStatusType,
    CompleteWorkflowExecutionFailedCauseType,
    ContinueAsNewWorkflowExecutionFailedCauseType,
    DecisionTaskTimeoutTypeType,
    DecisionTypeType,
    EventTypeType,
    ExecutionStatusType,
    FailWorkflowExecutionFailedCauseType,
    GetWorkflowExecutionHistoryPaginatorName,
    LambdaFunctionTimeoutTypeType,
    ListActivityTypesPaginatorName,
    ListClosedWorkflowExecutionsPaginatorName,
    ListDomainsPaginatorName,
    ListOpenWorkflowExecutionsPaginatorName,
    ListWorkflowTypesPaginatorName,
    PollForDecisionTaskPaginatorName,
    RecordMarkerFailedCauseType,
    RegistrationStatusType,
    RequestCancelActivityTaskFailedCauseType,
    RequestCancelExternalWorkflowExecutionFailedCauseType,
    ScheduleActivityTaskFailedCauseType,
    ScheduleLambdaFunctionFailedCauseType,
    SignalExternalWorkflowExecutionFailedCauseType,
    StartChildWorkflowExecutionFailedCauseType,
    StartLambdaFunctionFailedCauseType,
    StartTimerFailedCauseType,
    WorkflowExecutionCancelRequestedCauseType,
    WorkflowExecutionTerminatedCauseType,
    WorkflowExecutionTimeoutTypeType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ActivityTaskTimeoutTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_swf.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_swf.type_defs import (
    ActivityTaskCancelRequestedEventAttributesTypeDef,
    ActivityTaskCanceledEventAttributesTypeDef,
    ActivityTaskCompletedEventAttributesTypeDef,
    ActivityTaskFailedEventAttributesTypeDef,
    ActivityTaskScheduledEventAttributesTypeDef,
    ActivityTaskStartedEventAttributesTypeDef,
    ActivityTaskStatusTypeDef,
    ActivityTaskTimedOutEventAttributesTypeDef,
    ActivityTaskTypeDef,
    ActivityTypeConfigurationTypeDef,
    ActivityTypeDetailTypeDef,
    ActivityTypeInfoTypeDef,
    ActivityTypeInfosTypeDef,
    ActivityTypeTypeDef,
    CancelTimerDecisionAttributesTypeDef,
    CancelTimerFailedEventAttributesTypeDef,
    CancelWorkflowExecutionDecisionAttributesTypeDef,
    CancelWorkflowExecutionFailedEventAttributesTypeDef,
    ChildWorkflowExecutionCanceledEventAttributesTypeDef,
    ChildWorkflowExecutionCompletedEventAttributesTypeDef,
    ChildWorkflowExecutionFailedEventAttributesTypeDef,
    ChildWorkflowExecutionStartedEventAttributesTypeDef,
    ChildWorkflowExecutionTerminatedEventAttributesTypeDef,
    ChildWorkflowExecutionTimedOutEventAttributesTypeDef,
    CloseStatusFilterTypeDef,
    CompleteWorkflowExecutionDecisionAttributesTypeDef,
    CompleteWorkflowExecutionFailedEventAttributesTypeDef,
    ContinueAsNewWorkflowExecutionDecisionAttributesTypeDef,
    ContinueAsNewWorkflowExecutionFailedEventAttributesTypeDef,
    CountClosedWorkflowExecutionsInputRequestTypeDef,
    CountOpenWorkflowExecutionsInputRequestTypeDef,
    CountPendingActivityTasksInputRequestTypeDef,
    CountPendingDecisionTasksInputRequestTypeDef,
    DecisionTaskCompletedEventAttributesTypeDef,
    DecisionTaskScheduledEventAttributesTypeDef,
    DecisionTaskStartedEventAttributesTypeDef,
    DecisionTaskTimedOutEventAttributesTypeDef,
    DecisionTaskTypeDef,
    DecisionTypeDef,
    DeprecateActivityTypeInputRequestTypeDef,
    DeprecateDomainInputRequestTypeDef,
    DeprecateWorkflowTypeInputRequestTypeDef,
    DescribeActivityTypeInputRequestTypeDef,
    DescribeDomainInputRequestTypeDef,
    DescribeWorkflowExecutionInputRequestTypeDef,
    DescribeWorkflowTypeInputRequestTypeDef,
    DomainConfigurationTypeDef,
    DomainDetailTypeDef,
    DomainInfoTypeDef,
    DomainInfosTypeDef,
    ExecutionTimeFilterTypeDef,
    ExternalWorkflowExecutionCancelRequestedEventAttributesTypeDef,
    ExternalWorkflowExecutionSignaledEventAttributesTypeDef,
    FailWorkflowExecutionDecisionAttributesTypeDef,
    FailWorkflowExecutionFailedEventAttributesTypeDef,
    GetWorkflowExecutionHistoryInputRequestTypeDef,
    HistoryEventTypeDef,
    HistoryTypeDef,
    LambdaFunctionCompletedEventAttributesTypeDef,
    LambdaFunctionFailedEventAttributesTypeDef,
    LambdaFunctionScheduledEventAttributesTypeDef,
    LambdaFunctionStartedEventAttributesTypeDef,
    LambdaFunctionTimedOutEventAttributesTypeDef,
    ListActivityTypesInputRequestTypeDef,
    ListClosedWorkflowExecutionsInputRequestTypeDef,
    ListDomainsInputRequestTypeDef,
    ListOpenWorkflowExecutionsInputRequestTypeDef,
    ListTagsForResourceInputRequestTypeDef,
    ListTagsForResourceOutputTypeDef,
    ListWorkflowTypesInputRequestTypeDef,
    MarkerRecordedEventAttributesTypeDef,
    PaginatorConfigTypeDef,
    PendingTaskCountTypeDef,
    PollForActivityTaskInputRequestTypeDef,
    PollForDecisionTaskInputRequestTypeDef,
    RecordActivityTaskHeartbeatInputRequestTypeDef,
    RecordMarkerDecisionAttributesTypeDef,
    RecordMarkerFailedEventAttributesTypeDef,
    RegisterActivityTypeInputRequestTypeDef,
    RegisterDomainInputRequestTypeDef,
    RegisterWorkflowTypeInputRequestTypeDef,
    RequestCancelActivityTaskDecisionAttributesTypeDef,
    RequestCancelActivityTaskFailedEventAttributesTypeDef,
    RequestCancelExternalWorkflowExecutionDecisionAttributesTypeDef,
    RequestCancelExternalWorkflowExecutionFailedEventAttributesTypeDef,
    RequestCancelExternalWorkflowExecutionInitiatedEventAttributesTypeDef,
    RequestCancelWorkflowExecutionInputRequestTypeDef,
    ResourceTagTypeDef,
    RespondActivityTaskCanceledInputRequestTypeDef,
    RespondActivityTaskCompletedInputRequestTypeDef,
    RespondActivityTaskFailedInputRequestTypeDef,
    RespondDecisionTaskCompletedInputRequestTypeDef,
    ResponseMetadataTypeDef,
    RunTypeDef,
    ScheduleActivityTaskDecisionAttributesTypeDef,
    ScheduleActivityTaskFailedEventAttributesTypeDef,
    ScheduleLambdaFunctionDecisionAttributesTypeDef,
    ScheduleLambdaFunctionFailedEventAttributesTypeDef,
    SignalExternalWorkflowExecutionDecisionAttributesTypeDef,
    SignalExternalWorkflowExecutionFailedEventAttributesTypeDef,
    SignalExternalWorkflowExecutionInitiatedEventAttributesTypeDef,
    SignalWorkflowExecutionInputRequestTypeDef,
    StartChildWorkflowExecutionDecisionAttributesTypeDef,
    StartChildWorkflowExecutionFailedEventAttributesTypeDef,
    StartChildWorkflowExecutionInitiatedEventAttributesTypeDef,
    StartLambdaFunctionFailedEventAttributesTypeDef,
    StartTimerDecisionAttributesTypeDef,
    StartTimerFailedEventAttributesTypeDef,
    StartWorkflowExecutionInputRequestTypeDef,
    TagFilterTypeDef,
    TagResourceInputRequestTypeDef,
    TaskListTypeDef,
    TerminateWorkflowExecutionInputRequestTypeDef,
    TimerCanceledEventAttributesTypeDef,
    TimerFiredEventAttributesTypeDef,
    TimerStartedEventAttributesTypeDef,
    UndeprecateActivityTypeInputRequestTypeDef,
    UndeprecateDomainInputRequestTypeDef,
    UndeprecateWorkflowTypeInputRequestTypeDef,
    UntagResourceInputRequestTypeDef,
    WorkflowExecutionCancelRequestedEventAttributesTypeDef,
    WorkflowExecutionCanceledEventAttributesTypeDef,
    WorkflowExecutionCompletedEventAttributesTypeDef,
    WorkflowExecutionConfigurationTypeDef,
    WorkflowExecutionContinuedAsNewEventAttributesTypeDef,
    WorkflowExecutionCountTypeDef,
    WorkflowExecutionDetailTypeDef,
    WorkflowExecutionFailedEventAttributesTypeDef,
    WorkflowExecutionFilterTypeDef,
    WorkflowExecutionInfoTypeDef,
    WorkflowExecutionInfosTypeDef,
    WorkflowExecutionOpenCountsTypeDef,
    WorkflowExecutionSignaledEventAttributesTypeDef,
    WorkflowExecutionStartedEventAttributesTypeDef,
    WorkflowExecutionTerminatedEventAttributesTypeDef,
    WorkflowExecutionTimedOutEventAttributesTypeDef,
    WorkflowExecutionTypeDef,
    WorkflowTypeConfigurationTypeDef,
    WorkflowTypeDetailTypeDef,
    WorkflowTypeFilterTypeDef,
    WorkflowTypeInfoTypeDef,
    WorkflowTypeInfosTypeDef,
    WorkflowTypeTypeDef,
)

def get_structure() -> ActivityTaskCancelRequestedEventAttributesTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-swf` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-swf docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_swf/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
