import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Serverless::Api`.
 *
 * @external
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export interface CfnApiProps {
    /**
     * `AWS::Serverless::Api.StageName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly stageName: string;
    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly accessLogSetting?: CfnApi.AccessLogSettingProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Auth`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly auth?: CfnApi.AuthProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly binaryMediaTypes?: string[];
    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly cacheClusterEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly cacheClusterSize?: string;
    /**
     * `AWS::Serverless::Api.CanarySetting`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-canarysetting
     */
    readonly canarySetting?: CfnApi.CanarySettingProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Cors`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly cors?: CfnApi.CorsConfigurationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly definitionBody?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly definitionUri?: CfnApi.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Description`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-description
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly endpointConfiguration?: CfnApi.EndpointConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.GatewayResponses`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-gatewayresponses
     */
    readonly gatewayResponses?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.MethodSettings`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly methodSettings?: Array<any | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.MinimumCompressionSize`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-minimumcompressionsize
     */
    readonly minimumCompressionSize?: number;
    /**
     * `AWS::Serverless::Api.Models`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-models
     */
    readonly models?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Name`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly name?: string;
    /**
     * `AWS::Serverless::Api.OpenApiVersion`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly openApiVersion?: string;
    /**
     * `AWS::Serverless::Api.Tags`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly tracingEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::Api.Variables`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    readonly variables?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare class CfnApi extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Api";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApi;
    /**
     * `AWS::Serverless::Api.StageName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    stageName: string;
    /**
     * `AWS::Serverless::Api.AccessLogSetting`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    accessLogSetting: CfnApi.AccessLogSettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Auth`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    auth: CfnApi.AuthProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.BinaryMediaTypes`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    binaryMediaTypes: string[] | undefined;
    /**
     * `AWS::Serverless::Api.CacheClusterEnabled`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    cacheClusterEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.CacheClusterSize`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    cacheClusterSize: string | undefined;
    /**
     * `AWS::Serverless::Api.CanarySetting`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-canarysetting
     */
    canarySetting: CfnApi.CanarySettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Cors`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    cors: CfnApi.CorsConfigurationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.DefinitionBody`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    definitionBody: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.DefinitionUri`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    definitionUri: CfnApi.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Description`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-description
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::Api.EndpointConfiguration`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    endpointConfiguration: CfnApi.EndpointConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.GatewayResponses`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-gatewayresponses
     */
    gatewayResponses: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.MethodSettings`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    methodSettings: Array<any | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.MinimumCompressionSize`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-minimumcompressionsize
     */
    minimumCompressionSize: number | undefined;
    /**
     * `AWS::Serverless::Api.Models`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-api.html#sam-api-models
     */
    models: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Name`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    name: string | undefined;
    /**
     * `AWS::Serverless::Api.OpenApiVersion`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    openApiVersion: string | undefined;
    /**
     * `AWS::Serverless::Api.Tags`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Api.TracingEnabled`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    tracingEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Api.Variables`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
     */
    variables: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Serverless::Api`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApiProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare namespace CfnApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    interface AccessLogSettingProperty {
        /**
         * `CfnApi.AccessLogSettingProperty.DestinationArn`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        readonly destinationArn?: string;
        /**
         * `CfnApi.AccessLogSettingProperty.Format`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare namespace CfnApi {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
     */
    interface AuthProperty {
        /**
         * `CfnApi.AuthProperty.Authorizers`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        readonly authorizers?: any | cdk.IResolvable;
        /**
         * `CfnApi.AuthProperty.DefaultAuthorizer`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api-auth-object
         */
        readonly defaultAuthorizer?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare namespace CfnApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html
     */
    interface CanarySettingProperty {
        /**
         * `CfnApi.CanarySettingProperty.DeploymentId`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
         */
        readonly deploymentId?: string;
        /**
         * `CfnApi.CanarySettingProperty.PercentTraffic`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
         */
        readonly percentTraffic?: number;
        /**
         * `CfnApi.CanarySettingProperty.StageVariableOverrides`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
         */
        readonly stageVariableOverrides?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnApi.CanarySettingProperty.UseStageCache`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
         */
        readonly useStageCache?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare namespace CfnApi {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
     */
    interface CorsConfigurationProperty {
        /**
         * `CfnApi.CorsConfigurationProperty.AllowCredentials`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        readonly allowCredentials?: boolean | cdk.IResolvable;
        /**
         * `CfnApi.CorsConfigurationProperty.AllowHeaders`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        readonly allowHeaders?: string;
        /**
         * `CfnApi.CorsConfigurationProperty.AllowMethods`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        readonly allowMethods?: string;
        /**
         * `CfnApi.CorsConfigurationProperty.AllowOrigin`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        readonly allowOrigin: string;
        /**
         * `CfnApi.CorsConfigurationProperty.MaxAge`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration
         */
        readonly maxAge?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare namespace CfnApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-api-endpointconfiguration.html
     */
    interface EndpointConfigurationProperty {
        /**
         * `CfnApi.EndpointConfigurationProperty.Type`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-api-endpointconfiguration.html#sam-api-endpointconfiguration-type
         */
        readonly type?: string;
        /**
         * `CfnApi.EndpointConfigurationProperty.VpcEndpointIds`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-api-endpointconfiguration.html#sam-api-endpointconfiguration-vpcendpointids
         */
        readonly vpcEndpointIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::Serverless::Api`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Api
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapi
 */
export declare namespace CfnApi {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnApi.S3LocationProperty.Bucket`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
         */
        readonly bucket: string;
        /**
         * `CfnApi.S3LocationProperty.Key`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
         */
        readonly key: string;
        /**
         * `CfnApi.S3LocationProperty.Version`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
         */
        readonly version: number;
    }
}
/**
 * Properties for defining a `AWS::Serverless::Application`.
 *
 * @external
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
export interface CfnApplicationProps {
    /**
     * `AWS::Serverless::Application.Location`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly location: CfnApplication.ApplicationLocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.NotificationArns`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly notificationArns?: string[];
    /**
     * `AWS::Serverless::Application.Parameters`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.Tags`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly timeoutInMinutes?: number;
}
/**
 * A CloudFormation `AWS::Serverless::Application`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Application
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Application";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * `AWS::Serverless::Application.Location`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    location: CfnApplication.ApplicationLocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Application.NotificationArns`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    notificationArns: string[] | undefined;
    /**
     * `AWS::Serverless::Application.Parameters`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Application.Tags`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Application.TimeoutInMinutes`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    timeoutInMinutes: number | undefined;
    /**
     * Create a new `AWS::Serverless::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::Application`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Application
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
     */
    interface ApplicationLocationProperty {
        /**
         * `CfnApplication.ApplicationLocationProperty.ApplicationId`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        readonly applicationId: string;
        /**
         * `CfnApplication.ApplicationLocationProperty.SemanticVersion`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessapplication
         */
        readonly semanticVersion: string;
    }
}
/**
 * Properties for defining a `AWS::Serverless::Function`.
 *
 * @external
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export interface CfnFunctionProps {
    /**
     * `AWS::Serverless::Function.AssumeRolePolicyDocument`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-assumerolepolicydocument
     */
    readonly assumeRolePolicyDocument?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly autoPublishAlias?: string;
    /**
     * `AWS::Serverless::Function.AutoPublishCodeSha256`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-autopublishcodesha256
     */
    readonly autoPublishCodeSha256?: string;
    /**
     * `AWS::Serverless::Function.CodeSigningConfigArn`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-codesigningconfigarn
     */
    readonly codeSigningConfigArn?: string;
    /**
     * `AWS::Serverless::Function.CodeUri`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly codeUri?: CfnFunction.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly deadLetterQueue?: CfnFunction.DeadLetterQueueProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    readonly deploymentPreference?: CfnFunction.DeploymentPreferenceProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Description`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::Function.Environment`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly environment?: CfnFunction.FunctionEnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.EventInvokeConfig`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly eventInvokeConfig?: CfnFunction.EventInvokeConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.Events`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly events?: {
        [key: string]: (CfnFunction.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html
     */
    readonly fileSystemConfigs?: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.FunctionName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly functionName?: string;
    /**
     * `AWS::Serverless::Function.Handler`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly handler?: string;
    /**
     * `AWS::Serverless::Function.ImageConfig`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-imageconfig
     */
    readonly imageConfig?: CfnFunction.ImageConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.ImageUri`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-imageuri
     */
    readonly imageUri?: string;
    /**
     * `AWS::Serverless::Function.InlineCode`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly inlineCode?: string;
    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::Serverless::Function.Layers`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly layers?: string[];
    /**
     * `AWS::Serverless::Function.MemorySize`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly memorySize?: number;
    /**
     * `AWS::Serverless::Function.PackageType`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-packagetype
     */
    readonly packageType?: string;
    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly permissionsBoundary?: string;
    /**
     * `AWS::Serverless::Function.Policies`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly policies?: Array<CfnFunction.IAMPolicyDocumentProperty | CfnFunction.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnFunction.IAMPolicyDocumentProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly provisionedConcurrencyConfig?: CfnFunction.ProvisionedConcurrencyConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly reservedConcurrentExecutions?: number;
    /**
     * `AWS::Serverless::Function.Role`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly role?: string;
    /**
     * `AWS::Serverless::Function.Runtime`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly runtime?: string;
    /**
     * `AWS::Serverless::Function.Tags`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::Function.Timeout`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly timeout?: number;
    /**
     * `AWS::Serverless::Function.Tracing`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly tracing?: string;
    /**
     * `AWS::Serverless::Function.VersionDescription`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly versionDescription?: string;
    /**
     * `AWS::Serverless::Function.VpcConfig`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly vpcConfig?: CfnFunction.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare class CfnFunction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::Function";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFunction;
    /**
     * `AWS::Serverless::Function.AssumeRolePolicyDocument`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-assumerolepolicydocument
     */
    assumeRolePolicyDocument: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.AutoPublishAlias`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    autoPublishAlias: string | undefined;
    /**
     * `AWS::Serverless::Function.AutoPublishCodeSha256`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-autopublishcodesha256
     */
    autoPublishCodeSha256: string | undefined;
    /**
     * `AWS::Serverless::Function.CodeSigningConfigArn`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-codesigningconfigarn
     */
    codeSigningConfigArn: string | undefined;
    /**
     * `AWS::Serverless::Function.CodeUri`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    codeUri: CfnFunction.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.DeadLetterQueue`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    deadLetterQueue: CfnFunction.DeadLetterQueueProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.DeploymentPreference`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
     */
    deploymentPreference: CfnFunction.DeploymentPreferenceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.Description`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::Function.Environment`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    environment: CfnFunction.FunctionEnvironmentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.EventInvokeConfig`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    eventInvokeConfig: CfnFunction.EventInvokeConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.Events`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    events: {
        [key: string]: (CfnFunction.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.FileSystemConfigs`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html
     */
    fileSystemConfigs: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.FunctionName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    functionName: string | undefined;
    /**
     * `AWS::Serverless::Function.Handler`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    handler: string | undefined;
    /**
     * `AWS::Serverless::Function.ImageConfig`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-imageconfig
     */
    imageConfig: CfnFunction.ImageConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.ImageUri`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-imageuri
     */
    imageUri: string | undefined;
    /**
     * `AWS::Serverless::Function.InlineCode`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    inlineCode: string | undefined;
    /**
     * `AWS::Serverless::Function.KmsKeyArn`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::Serverless::Function.Layers`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    layers: string[] | undefined;
    /**
     * `AWS::Serverless::Function.MemorySize`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    memorySize: number | undefined;
    /**
     * `AWS::Serverless::Function.PackageType`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-function.html#sam-function-packagetype
     */
    packageType: string | undefined;
    /**
     * `AWS::Serverless::Function.PermissionsBoundary`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    permissionsBoundary: string | undefined;
    /**
     * `AWS::Serverless::Function.Policies`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    policies: Array<CfnFunction.IAMPolicyDocumentProperty | CfnFunction.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnFunction.IAMPolicyDocumentProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.ProvisionedConcurrencyConfig`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    provisionedConcurrencyConfig: CfnFunction.ProvisionedConcurrencyConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::Function.ReservedConcurrentExecutions`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    reservedConcurrentExecutions: number | undefined;
    /**
     * `AWS::Serverless::Function.Role`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    role: string | undefined;
    /**
     * `AWS::Serverless::Function.Runtime`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    runtime: string | undefined;
    /**
     * `AWS::Serverless::Function.Tags`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::Function.Timeout`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    timeout: number | undefined;
    /**
     * `AWS::Serverless::Function.Tracing`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    tracing: string | undefined;
    /**
     * `AWS::Serverless::Function.VersionDescription`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    versionDescription: string | undefined;
    /**
     * `AWS::Serverless::Function.VpcConfig`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
     */
    vpcConfig: CfnFunction.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Serverless::Function`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnFunctionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
     */
    interface AlexaSkillEventProperty {
        /**
         * `CfnFunction.AlexaSkillEventProperty.Variables`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#alexaskill
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    interface ApiEventProperty {
        /**
         * `CfnFunction.ApiEventProperty.Auth`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly auth?: CfnFunction.AuthProperty | cdk.IResolvable;
        /**
         * `CfnFunction.ApiEventProperty.Method`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly method: string;
        /**
         * `CfnFunction.ApiEventProperty.Path`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly path: string;
        /**
         * `CfnFunction.ApiEventProperty.RestApiId`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly restApiId?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
     */
    interface AuthProperty {
        /**
         * `CfnFunction.AuthProperty.ApiKeyRequired`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly apiKeyRequired?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.AuthProperty.AuthorizationScopes`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly authorizationScopes?: string[];
        /**
         * `CfnFunction.AuthProperty.Authorizer`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly authorizer?: string;
        /**
         * `CfnFunction.AuthProperty.ResourcePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly resourcePolicy?: CfnFunction.AuthResourcePolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
     */
    interface AuthResourcePolicyProperty {
        /**
         * `CfnFunction.AuthResourcePolicyProperty.AwsAccountBlacklist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly awsAccountBlacklist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.AwsAccountWhitelist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly awsAccountWhitelist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.CustomStatements`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly customStatements?: Array<any | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpcBlacklist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly intrinsicVpcBlacklist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpcWhitelist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly intrinsicVpcWhitelist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpceBlacklist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly intrinsicVpceBlacklist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.IntrinsicVpceWhitelist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly intrinsicVpceWhitelist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.IpRangeBlacklist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly ipRangeBlacklist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.IpRangeWhitelist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly ipRangeWhitelist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.SourceVpcBlacklist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly sourceVpcBlacklist?: string[];
        /**
         * `CfnFunction.AuthResourcePolicyProperty.SourceVpcWhitelist`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#function-auth-object
         */
        readonly sourceVpcWhitelist?: string[];
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface BucketSAMPTProperty {
        /**
         * `CfnFunction.BucketSAMPTProperty.BucketName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly bucketName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     */
    interface CloudWatchEventEventProperty {
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Input`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        readonly input?: string;
        /**
         * `CfnFunction.CloudWatchEventEventProperty.InputPath`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
         */
        readonly inputPath?: string;
        /**
         * `CfnFunction.CloudWatchEventEventProperty.Pattern`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchevent
     */
    interface CloudWatchLogsEventProperty {
        /**
         * `CfnFunction.CloudWatchLogsEventProperty.FilterPattern`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchlogs
         */
        readonly filterPattern: string;
        /**
         * `CfnFunction.CloudWatchLogsEventProperty.LogGroupName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#cloudwatchlogs
         */
        readonly logGroupName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface CollectionSAMPTProperty {
        /**
         * `CfnFunction.CollectionSAMPTProperty.CollectionId`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly collectionId: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deadletterqueue-object
     */
    interface DeadLetterQueueProperty {
        /**
         * `CfnFunction.DeadLetterQueueProperty.TargetArn`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly targetArn: string;
        /**
         * `CfnFunction.DeadLetterQueueProperty.Type`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/safe_lambda_deployments.rst
     */
    interface DeploymentPreferenceProperty {
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Enabled`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Type`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly type: string;
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Alarms`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly alarms?: string[];
        /**
         * `CfnFunction.DeploymentPreferenceProperty.Hooks`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#deploymentpreference-object
         */
        readonly hooks?: string[];
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
     */
    interface DestinationProperty {
        /**
         * `CfnFunction.DestinationProperty.Destination`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         */
        readonly destination: string;
        /**
         * `CfnFunction.DestinationProperty.Type`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
     */
    interface DestinationConfigProperty {
        /**
         * `CfnFunction.DestinationConfigProperty.OnFailure`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         */
        readonly onFailure: CfnFunction.DestinationProperty | cdk.IResolvable;
        /**
         * `CfnFunction.DestinationConfigProperty.OnSuccess`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#destination-config-object
         */
        readonly onSuccess: CfnFunction.DestinationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface DomainSAMPTProperty {
        /**
         * `CfnFunction.DomainSAMPTProperty.DomainName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly domainName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
     */
    interface DynamoDBEventProperty {
        /**
         * `CfnFunction.DynamoDBEventProperty.BatchSize`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.BisectBatchOnFunctionError`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly bisectBatchOnFunctionError?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.DestinationConfig`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly destinationConfig?: CfnFunction.DestinationConfigProperty | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.Enabled`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumBatchingWindowInSeconds`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly maximumBatchingWindowInSeconds?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumRecordAgeInSeconds`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly maximumRecordAgeInSeconds?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.MaximumRetryAttempts`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly maximumRetryAttempts?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.ParallelizationFactor`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly parallelizationFactor?: number;
        /**
         * `CfnFunction.DynamoDBEventProperty.StartingPosition`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly startingPosition: string;
        /**
         * `CfnFunction.DynamoDBEventProperty.Stream`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#dynamodb
         */
        readonly stream: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface EmptySAMPTProperty {
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
     */
    interface EventBridgeRuleEventProperty {
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.EventBusName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
         */
        readonly eventBusName?: string;
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.Input`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
         */
        readonly input?: string;
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.InputPath`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#eventbridgerule
         */
        readonly inputPath?: string;
        /**
         * `CfnFunction.EventBridgeRuleEventProperty.Pattern`.
         *
         * @external
         * @link https://docs.aws.amazon.com/eventbridge/latest/userguide/filtering-examples-structure.html
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#event-invoke-config-object
     */
    interface EventInvokeConfigProperty {
        /**
         * `CfnFunction.EventInvokeConfigProperty.DestinationConfig`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#event-invoke-config-object
         */
        readonly destinationConfig?: CfnFunction.DestinationConfigProperty | cdk.IResolvable;
        /**
         * `CfnFunction.EventInvokeConfigProperty.MaximumEventAgeInSeconds`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#event-invoke-config-object
         */
        readonly maximumEventAgeInSeconds?: number;
        /**
         * `CfnFunction.EventInvokeConfigProperty.MaximumRetryAttempts`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#event-invoke-config-object
         */
        readonly maximumRetryAttempts?: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     */
    interface EventSourceProperty {
        /**
         * `CfnFunction.EventSourceProperty.Properties`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         */
        readonly properties: CfnFunction.S3EventProperty | CfnFunction.SNSEventProperty | CfnFunction.SQSEventProperty | CfnFunction.KinesisEventProperty | CfnFunction.DynamoDBEventProperty | CfnFunction.ApiEventProperty | CfnFunction.ScheduleEventProperty | CfnFunction.CloudWatchEventEventProperty | CfnFunction.CloudWatchLogsEventProperty | CfnFunction.IoTRuleEventProperty | CfnFunction.AlexaSkillEventProperty | CfnFunction.EventBridgeRuleEventProperty | cdk.IResolvable;
        /**
         * `CfnFunction.EventSourceProperty.Type`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
     */
    interface FileSystemConfigProperty {
        /**
         * `CfnFunction.FileSystemConfigProperty.Arn`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         */
        readonly arn?: string;
        /**
         * `CfnFunction.FileSystemConfigProperty.LocalMountPath`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         */
        readonly localMountPath?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
     */
    interface FunctionEnvironmentProperty {
        /**
         * `CfnFunction.FunctionEnvironmentProperty.Variables`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#environment-object
         */
        readonly variables: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface FunctionSAMPTProperty {
        /**
         * `CfnFunction.FunctionSAMPTProperty.FunctionName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly functionName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     */
    interface IAMPolicyDocumentProperty {
        /**
         * `CfnFunction.IAMPolicyDocumentProperty.Statement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         */
        readonly statement: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface IdentitySAMPTProperty {
        /**
         * `CfnFunction.IdentitySAMPTProperty.IdentityName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly identityName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html
     */
    interface ImageConfigProperty {
        /**
         * `CfnFunction.ImageConfigProperty.Command`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-command
         */
        readonly command?: string[];
        /**
         * `CfnFunction.ImageConfigProperty.EntryPoint`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-entrypoint
         */
        readonly entryPoint?: string[];
        /**
         * `CfnFunction.ImageConfigProperty.WorkingDirectory`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-workingdirectory
         */
        readonly workingDirectory?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
     */
    interface IoTRuleEventProperty {
        /**
         * `CfnFunction.IoTRuleEventProperty.AwsIotSqlVersion`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        readonly awsIotSqlVersion?: string;
        /**
         * `CfnFunction.IoTRuleEventProperty.Sql`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#iotrule
         */
        readonly sql: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface KeySAMPTProperty {
        /**
         * `CfnFunction.KeySAMPTProperty.KeyId`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly keyId: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
     */
    interface KinesisEventProperty {
        /**
         * `CfnFunction.KinesisEventProperty.BatchSize`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.KinesisEventProperty.Enabled`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.KinesisEventProperty.StartingPosition`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly startingPosition: string;
        /**
         * `CfnFunction.KinesisEventProperty.Stream`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#kinesis
         */
        readonly stream: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface LogGroupSAMPTProperty {
        /**
         * `CfnFunction.LogGroupSAMPTProperty.LogGroupName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly logGroupName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#provisioned-concurrency-config-object
     */
    interface ProvisionedConcurrencyConfigProperty {
        /**
         * `CfnFunction.ProvisionedConcurrencyConfigProperty.ProvisionedConcurrentExecutions`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#provisioned-concurrency-config-object
         */
        readonly provisionedConcurrentExecutions: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface QueueSAMPTProperty {
        /**
         * `CfnFunction.QueueSAMPTProperty.QueueName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly queueName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
     */
    interface S3EventProperty {
        /**
         * `CfnFunction.S3EventProperty.Bucket`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        readonly bucket: string;
        /**
         * `CfnFunction.S3EventProperty.Events`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        readonly events: string[] | string | cdk.IResolvable;
        /**
         * `CfnFunction.S3EventProperty.Filter`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3
         */
        readonly filter?: CfnFunction.S3NotificationFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    interface S3KeyFilterProperty {
        /**
         * `CfnFunction.S3KeyFilterProperty.Rules`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         */
        readonly rules: Array<CfnFunction.S3KeyFilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    interface S3KeyFilterRuleProperty {
        /**
         * `CfnFunction.S3KeyFilterRuleProperty.Name`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
         */
        readonly name: string;
        /**
         * `CfnFunction.S3KeyFilterRuleProperty.Value`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnFunction.S3LocationProperty.Bucket`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly bucket: string;
        /**
         * `CfnFunction.S3LocationProperty.Key`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly key: string;
        /**
         * `CfnFunction.S3LocationProperty.Version`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly version?: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    interface S3NotificationFilterProperty {
        /**
         * `CfnFunction.S3NotificationFilterProperty.S3Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
         */
        readonly s3Key: CfnFunction.S3KeyFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface SAMPolicyTemplateProperty {
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.AMIDescribePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly amiDescribePolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudFormationDescribeStacksPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly cloudFormationDescribeStacksPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.CloudWatchPutMetricPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly cloudWatchPutMetricPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBCrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly dynamoDbCrudPolicy?: CfnFunction.TableSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBReadPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly dynamoDbReadPolicy?: CfnFunction.TableSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.DynamoDBStreamReadPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly dynamoDbStreamReadPolicy?: CfnFunction.TableStreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.EC2DescribePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly ec2DescribePolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.ElasticsearchHttpPostPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly elasticsearchHttpPostPolicy?: CfnFunction.DomainSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.FilterLogEventsPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly filterLogEventsPolicy?: CfnFunction.LogGroupSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KMSDecryptPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly kmsDecryptPolicy?: CfnFunction.KeySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisCrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly kinesisCrudPolicy?: CfnFunction.StreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.KinesisStreamReadPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly kinesisStreamReadPolicy?: CfnFunction.StreamSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly lambdaInvokePolicy?: CfnFunction.FunctionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionDetectOnlyPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionDetectOnlyPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionLabelsPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionLabelsPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionNoDataAccessPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionNoDataAccessPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionReadPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionReadPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.RekognitionWriteOnlyAccessPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly rekognitionWriteOnlyAccessPolicy?: CfnFunction.CollectionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3CrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly s3CrudPolicy?: CfnFunction.BucketSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.S3ReadPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly s3ReadPolicy?: CfnFunction.BucketSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESBulkTemplatedCrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesBulkTemplatedCrudPolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESCrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesCrudPolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESEmailTemplateCrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesEmailTemplateCrudPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SESSendBouncePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sesSendBouncePolicy?: CfnFunction.IdentitySAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSCrudPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly snsCrudPolicy?: CfnFunction.TopicSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SNSPublishMessagePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly snsPublishMessagePolicy?: CfnFunction.TopicSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSPollerPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sqsPollerPolicy?: CfnFunction.QueueSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.SQSSendMessagePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly sqsSendMessagePolicy?: CfnFunction.QueueSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly stepFunctionsExecutionPolicy?: CfnFunction.StateMachineSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnFunction.SAMPolicyTemplateProperty.VPCAccessPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly vpcAccessPolicy?: CfnFunction.EmptySAMPTProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
     */
    interface SNSEventProperty {
        /**
         * `CfnFunction.SNSEventProperty.Topic`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sns
         */
        readonly topic: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
     */
    interface SQSEventProperty {
        /**
         * `CfnFunction.SQSEventProperty.BatchSize`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        readonly batchSize?: number;
        /**
         * `CfnFunction.SQSEventProperty.Enabled`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnFunction.SQSEventProperty.Queue`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#sqs
         */
        readonly queue: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     */
    interface ScheduleEventProperty {
        /**
         * `CfnFunction.ScheduleEventProperty.Input`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        readonly input?: string;
        /**
         * `CfnFunction.ScheduleEventProperty.Schedule`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        readonly schedule: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface StateMachineSAMPTProperty {
        /**
         * `CfnFunction.StateMachineSAMPTProperty.StateMachineName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly stateMachineName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface StreamSAMPTProperty {
        /**
         * `CfnFunction.StreamSAMPTProperty.StreamName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly streamName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface TableSAMPTProperty {
        /**
         * `CfnFunction.TableSAMPTProperty.TableName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface TableStreamSAMPTProperty {
        /**
         * `CfnFunction.TableStreamSAMPTProperty.StreamName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly streamName: string;
        /**
         * `CfnFunction.TableStreamSAMPTProperty.TableName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface TopicSAMPTProperty {
        /**
         * `CfnFunction.TopicSAMPTProperty.TopicName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly topicName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::Function`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::Function
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
 */
export declare namespace CfnFunction {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::Serverless::HttpApi`.
 *
 * @external
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export interface CfnHttpApiProps {
    /**
     * `AWS::Serverless::HttpApi.AccessLogSetting`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly accessLogSetting?: CfnHttpApi.AccessLogSettingProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.Auth`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly auth?: CfnHttpApi.HttpApiAuthProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.CorsConfiguration`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly corsConfiguration?: CfnHttpApi.CorsConfigurationObjectProperty | boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly defaultRouteSettings?: CfnHttpApi.RouteSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.DefinitionBody`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly definitionBody?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.DefinitionUri`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly definitionUri?: CfnHttpApi.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.Description`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-httpapi.html#sam-httpapi-disableexecuteapiendpoint
     */
    readonly disableExecuteApiEndpoint?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.Domain`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly domain?: CfnHttpApi.HttpApiDomainConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.FailOnWarnings`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly failOnWarnings?: boolean | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.RouteSettings`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly routeSettings?: CfnHttpApi.RouteSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.StageName`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly stageName?: string;
    /**
     * `AWS::Serverless::HttpApi.StageVariables`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly stageVariables?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::HttpApi.Tags`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare class CfnHttpApi extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::HttpApi";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHttpApi;
    /**
     * `AWS::Serverless::HttpApi.AccessLogSetting`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    accessLogSetting: CfnHttpApi.AccessLogSettingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.Auth`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    auth: CfnHttpApi.HttpApiAuthProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.CorsConfiguration`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    corsConfiguration: CfnHttpApi.CorsConfigurationObjectProperty | boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.DefaultRouteSettings`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    defaultRouteSettings: CfnHttpApi.RouteSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.DefinitionBody`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    definitionBody: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.DefinitionUri`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    definitionUri: CfnHttpApi.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.Description`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::HttpApi.DisableExecuteApiEndpoint`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-httpapi.html#sam-httpapi-disableexecuteapiendpoint
     */
    disableExecuteApiEndpoint: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.Domain`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    domain: CfnHttpApi.HttpApiDomainConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.FailOnWarnings`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    failOnWarnings: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.RouteSettings`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    routeSettings: CfnHttpApi.RouteSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.StageName`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    stageName: string | undefined;
    /**
     * `AWS::Serverless::HttpApi.StageVariables`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    stageVariables: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::HttpApi.Tags`.
     *
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Serverless::HttpApi`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnHttpApiProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    interface AccessLogSettingProperty {
        /**
         * `CfnHttpApi.AccessLogSettingProperty.DestinationArn`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        readonly destinationArn?: string;
        /**
         * `CfnHttpApi.AccessLogSettingProperty.Format`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        readonly format?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
     */
    interface CorsConfigurationObjectProperty {
        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowCredentials`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
         */
        readonly allowCredentials?: boolean | cdk.IResolvable;
        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowHeaders`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
         */
        readonly allowHeaders?: string;
        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowMethods`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
         */
        readonly allowMethods?: string;
        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.AllowOrigin`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
         */
        readonly allowOrigin?: string;
        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.ExposeHeaders`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
         */
        readonly exposeHeaders?: string[];
        /**
         * `CfnHttpApi.CorsConfigurationObjectProperty.MaxAge`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#cors-configuration-object
         */
        readonly maxAge?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-httpapiauth.html
     */
    interface HttpApiAuthProperty {
        /**
         * `CfnHttpApi.HttpApiAuthProperty.Authorizers`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-httpapiauth.html#sam-httpapi-httpapiauth-defaultauthorizer
         */
        readonly authorizers?: any | cdk.IResolvable;
        /**
         * `CfnHttpApi.HttpApiAuthProperty.DefaultAuthorizer`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-httpapiauth.html#sam-httpapi-httpapiauth-authorizers
         */
        readonly defaultAuthorizer?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
     */
    interface HttpApiDomainConfigurationProperty {
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.BasePath`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
         */
        readonly basePath?: string;
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.CertificateArn`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
         */
        readonly certificateArn: string;
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.DomainName`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
         */
        readonly domainName: string;
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.EndpointConfiguration`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
         */
        readonly endpointConfiguration?: string;
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.MutualTlsAuthentication`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-httpapidomainconfiguration.html#sam-httpapi-httpapidomainconfiguration-mutualtlsauthentication
         */
        readonly mutualTlsAuthentication?: CfnHttpApi.MutualTlsAuthenticationProperty | cdk.IResolvable;
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.Route53`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
         */
        readonly route53?: CfnHttpApi.Route53ConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnHttpApi.HttpApiDomainConfigurationProperty.SecurityPolicy`.
         *
         * @external
         * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#domain-configuration-object
         */
        readonly securityPolicy?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html
     */
    interface MutualTlsAuthenticationProperty {
        /**
         * `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreUri`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreuri
         */
        readonly truststoreUri?: string;
        /**
         * `CfnHttpApi.MutualTlsAuthenticationProperty.TruststoreVersion`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-mutualtlsauthentication.html#cfn-apigatewayv2-domainname-mutualtlsauthentication-truststoreversion
         */
        readonly truststoreVersion?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-route53configuration.html
     */
    interface Route53ConfigurationProperty {
        /**
         * `CfnHttpApi.Route53ConfigurationProperty.DistributedDomainName`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-route53configuration.html#sam-httpapi-route53configuration-distributiondomainname
         */
        readonly distributedDomainName?: string;
        /**
         * `CfnHttpApi.Route53ConfigurationProperty.EvaluateTargetHealth`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-route53configuration.html#sam-httpapi-route53configuration-evaluatetargethealth
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnHttpApi.Route53ConfigurationProperty.HostedZoneId`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-route53configuration.html#sam-httpapi-route53configuration-hostedzoneid
         */
        readonly hostedZoneId?: string;
        /**
         * `CfnHttpApi.Route53ConfigurationProperty.HostedZoneName`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-route53configuration.html#sam-httpapi-route53configuration-hostedzonename
         */
        readonly hostedZoneName?: string;
        /**
         * `CfnHttpApi.Route53ConfigurationProperty.IpV6`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-httpapi-route53configuration.html#sam-httpapi-route53configuration-ipv6
         */
        readonly ipV6?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html
     */
    interface RouteSettingsProperty {
        /**
         * `CfnHttpApi.RouteSettingsProperty.DataTraceEnabled`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-datatraceenabled
         */
        readonly dataTraceEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnHttpApi.RouteSettingsProperty.DetailedMetricsEnabled`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-detailedmetricsenabled
         */
        readonly detailedMetricsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnHttpApi.RouteSettingsProperty.LoggingLevel`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-logginglevel
         */
        readonly loggingLevel?: string;
        /**
         * `CfnHttpApi.RouteSettingsProperty.ThrottlingBurstLimit`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingburstlimit
         */
        readonly throttlingBurstLimit?: number;
        /**
         * `CfnHttpApi.RouteSettingsProperty.ThrottlingRateLimit`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingratelimit
         */
        readonly throttlingRateLimit?: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::HttpApi`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::HttpApi
 * @link https://github.com/aws/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesshttpapi
 */
export declare namespace CfnHttpApi {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnHttpApi.S3LocationProperty.Bucket`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
         */
        readonly bucket: string;
        /**
         * `CfnHttpApi.S3LocationProperty.Key`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
         */
        readonly key: string;
        /**
         * `CfnHttpApi.S3LocationProperty.Version`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
         */
        readonly version: number;
    }
}
/**
 * Properties for defining a `AWS::Serverless::LayerVersion`.
 *
 * @external
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 */
export interface CfnLayerVersionProps {
    /**
     * `AWS::Serverless::LayerVersion.CompatibleRuntimes`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly compatibleRuntimes?: string[];
    /**
     * `AWS::Serverless::LayerVersion.ContentUri`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly contentUri?: CfnLayerVersion.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::LayerVersion.Description`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly description?: string;
    /**
     * `AWS::Serverless::LayerVersion.LayerName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly layerName?: string;
    /**
     * `AWS::Serverless::LayerVersion.LicenseInfo`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly licenseInfo?: string;
    /**
     * `AWS::Serverless::LayerVersion.RetentionPolicy`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    readonly retentionPolicy?: string;
}
/**
 * A CloudFormation `AWS::Serverless::LayerVersion`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::LayerVersion
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 */
export declare class CfnLayerVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::LayerVersion";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLayerVersion;
    /**
     * `AWS::Serverless::LayerVersion.CompatibleRuntimes`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    compatibleRuntimes: string[] | undefined;
    /**
     * `AWS::Serverless::LayerVersion.ContentUri`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    contentUri: CfnLayerVersion.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::LayerVersion.Description`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    description: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.LayerName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    layerName: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.LicenseInfo`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    licenseInfo: string | undefined;
    /**
     * `AWS::Serverless::LayerVersion.RetentionPolicy`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
     */
    retentionPolicy: string | undefined;
    /**
     * Create a new `AWS::Serverless::LayerVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLayerVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::LayerVersion`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::LayerVersion
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesslayerversion
 */
export declare namespace CfnLayerVersion {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnLayerVersion.S3LocationProperty.Bucket`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly bucket: string;
        /**
         * `CfnLayerVersion.S3LocationProperty.Key`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly key: string;
        /**
         * `CfnLayerVersion.S3LocationProperty.Version`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly version?: number;
    }
}
/**
 * Properties for defining a `AWS::Serverless::SimpleTable`.
 *
 * @external
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export interface CfnSimpleTableProps {
    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     */
    readonly primaryKey?: CfnSimpleTable.PrimaryKeyProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    readonly provisionedThroughput?: CfnSimpleTable.ProvisionedThroughputProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly sseSpecification?: CfnSimpleTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::SimpleTable.TableName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly tableName?: string;
    /**
     * `AWS::Serverless::SimpleTable.Tags`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export declare class CfnSimpleTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::SimpleTable";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSimpleTable;
    /**
     * `AWS::Serverless::SimpleTable.PrimaryKey`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     */
    primaryKey: CfnSimpleTable.PrimaryKeyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.ProvisionedThroughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    provisionedThroughput: CfnSimpleTable.ProvisionedThroughputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.SSESpecification`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    sseSpecification: CfnSimpleTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::SimpleTable.TableName`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    tableName: string | undefined;
    /**
     * `AWS::Serverless::SimpleTable.Tags`.
     *
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Serverless::SimpleTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSimpleTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export declare namespace CfnSimpleTable {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
     */
    interface PrimaryKeyProperty {
        /**
         * `CfnSimpleTable.PrimaryKeyProperty.Name`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
         */
        readonly name?: string;
        /**
         * `CfnSimpleTable.PrimaryKeyProperty.Type`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#primary-key-object
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export declare namespace CfnSimpleTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnSimpleTable.ProvisionedThroughputProperty.ReadCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
         */
        readonly readCapacityUnits?: number;
        /**
         * `CfnSimpleTable.ProvisionedThroughputProperty.WriteCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
         */
        readonly writeCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::SimpleTable`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::SimpleTable
 * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlesssimpletable
 */
export declare namespace CfnSimpleTable {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    interface SSESpecificationProperty {
        /**
         * `CfnSimpleTable.SSESpecificationProperty.SSEEnabled`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
         */
        readonly sseEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Serverless::StateMachine`.
 *
 * @external
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export interface CfnStateMachineProps {
    /**
     * `AWS::Serverless::StateMachine.Definition`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly definition?: any | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly definitionSubstitutions?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly definitionUri?: CfnStateMachine.S3LocationProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Events`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly events?: {
        [key: string]: (CfnStateMachine.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Logging`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly logging?: CfnStateMachine.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Name`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly name?: string;
    /**
     * `AWS::Serverless::StateMachine.PermissionsBoundaries`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html#sam-statemachine-permissionsboundary
     */
    readonly permissionsBoundaries?: string;
    /**
     * `AWS::Serverless::StateMachine.Policies`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly policies?: Array<CfnStateMachine.IAMPolicyDocumentProperty | CfnStateMachine.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnStateMachine.IAMPolicyDocumentProperty | string | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Role`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly role?: string;
    /**
     * `AWS::Serverless::StateMachine.Tags`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::Serverless::StateMachine.Tracing`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html#sam-statemachine-tracing
     */
    readonly tracing?: CfnStateMachine.TracingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Serverless::StateMachine.Type`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly type?: string;
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare class CfnStateMachine extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Serverless::StateMachine";
    /**
     * The `Transform` a template must use in order to use this resource.
     *
     * @external
     */
    static readonly REQUIRED_TRANSFORM = "AWS::Serverless-2016-10-31";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStateMachine;
    /**
     * `AWS::Serverless::StateMachine.Definition`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    definition: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.DefinitionSubstitutions`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    definitionSubstitutions: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.DefinitionUri`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    definitionUri: CfnStateMachine.S3LocationProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Events`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    events: {
        [key: string]: (CfnStateMachine.EventSourceProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Logging`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    logging: CfnStateMachine.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Name`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    name: string | undefined;
    /**
     * `AWS::Serverless::StateMachine.PermissionsBoundaries`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html#sam-statemachine-permissionsboundary
     */
    permissionsBoundaries: string | undefined;
    /**
     * `AWS::Serverless::StateMachine.Policies`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    policies: Array<CfnStateMachine.IAMPolicyDocumentProperty | CfnStateMachine.SAMPolicyTemplateProperty | string | cdk.IResolvable> | CfnStateMachine.IAMPolicyDocumentProperty | string | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Role`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    role: string | undefined;
    /**
     * `AWS::Serverless::StateMachine.Tags`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Serverless::StateMachine.Tracing`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html#sam-statemachine-tracing
     */
    tracing: CfnStateMachine.TracingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Serverless::StateMachine.Type`.
     *
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
     */
    type: string | undefined;
    /**
     * Create a new `AWS::Serverless::StateMachine`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnStateMachineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    interface ApiEventProperty {
        /**
         * `CfnStateMachine.ApiEventProperty.Method`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly method: string;
        /**
         * `CfnStateMachine.ApiEventProperty.Path`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly path: string;
        /**
         * `CfnStateMachine.ApiEventProperty.RestApiId`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
         */
        readonly restApiId?: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
     */
    interface CloudWatchEventEventProperty {
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.EventBusName`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         */
        readonly eventBusName?: string;
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.Input`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         */
        readonly input?: string;
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.InputPath`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         */
        readonly inputPath?: string;
        /**
         * `CfnStateMachine.CloudWatchEventEventProperty.Pattern`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup.html
     */
    interface CloudWatchLogsLogGroupProperty {
        /**
         * `CfnStateMachine.CloudWatchLogsLogGroupProperty.LogGroupArn`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup.html
         */
        readonly logGroupArn: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
     */
    interface EventBridgeRuleEventProperty {
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.EventBusName`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         */
        readonly eventBusName?: string;
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.Input`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         */
        readonly input?: string;
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.InputPath`.
         *
         * @external
         * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-property-statemachine-cloudwatchevent.html
         */
        readonly inputPath?: string;
        /**
         * `CfnStateMachine.EventBridgeRuleEventProperty.Pattern`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html
         */
        readonly pattern: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
     */
    interface EventSourceProperty {
        /**
         * `CfnStateMachine.EventSourceProperty.Properties`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-types
         */
        readonly properties: CfnStateMachine.CloudWatchEventEventProperty | CfnStateMachine.EventBridgeRuleEventProperty | CfnStateMachine.ScheduleEventProperty | CfnStateMachine.ApiEventProperty | cdk.IResolvable;
        /**
         * `CfnStateMachine.EventSourceProperty.Type`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#event-source-object
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface FunctionSAMPTProperty {
        /**
         * `CfnStateMachine.FunctionSAMPTProperty.FunctionName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly functionName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
     */
    interface IAMPolicyDocumentProperty {
        /**
         * `CfnStateMachine.IAMPolicyDocumentProperty.Statement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html
         */
        readonly statement: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination.html#cfn-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup
     */
    interface LogDestinationProperty {
        /**
         * `CfnStateMachine.LogDestinationProperty.CloudWatchLogsLogGroup`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-logdestination.html#cfn-stepfunctions-statemachine-logdestination-cloudwatchlogsloggroup
         */
        readonly cloudWatchLogsLogGroup: CfnStateMachine.CloudWatchLogsLogGroupProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Destinations`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
         */
        readonly destinations: Array<CfnStateMachine.LogDestinationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.IncludeExecutionData`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
         */
        readonly includeExecutionData: boolean | cdk.IResolvable;
        /**
         * `CfnStateMachine.LoggingConfigurationProperty.Level`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-loggingconfiguration.html
         */
        readonly level: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#s3-location-object
     */
    interface S3LocationProperty {
        /**
         * `CfnStateMachine.S3LocationProperty.Bucket`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly bucket: string;
        /**
         * `CfnStateMachine.S3LocationProperty.Key`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly key: string;
        /**
         * `CfnStateMachine.S3LocationProperty.Version`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction
         */
        readonly version?: number;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface SAMPolicyTemplateProperty {
        /**
         * `CfnStateMachine.SAMPolicyTemplateProperty.LambdaInvokePolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly lambdaInvokePolicy?: CfnStateMachine.FunctionSAMPTProperty | cdk.IResolvable;
        /**
         * `CfnStateMachine.SAMPolicyTemplateProperty.StepFunctionsExecutionPolicy`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly stepFunctionsExecutionPolicy?: CfnStateMachine.StateMachineSAMPTProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
     */
    interface ScheduleEventProperty {
        /**
         * `CfnStateMachine.ScheduleEventProperty.Input`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        readonly input?: string;
        /**
         * `CfnStateMachine.ScheduleEventProperty.Schedule`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#schedule
         */
        readonly schedule: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
     */
    interface StateMachineSAMPTProperty {
        /**
         * `CfnStateMachine.StateMachineSAMPTProperty.StateMachineName`.
         *
         * @external
         * @link https://github.com/awslabs/serverless-application-model/blob/master/docs/policy_templates.rst
         */
        readonly stateMachineName: string;
    }
}
/**
 * A CloudFormation `AWS::Serverless::StateMachine`.
 *
 * @external
 * @cloudformationResource AWS::Serverless::StateMachine
 * @link https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/sam-resource-statemachine.html
 */
export declare namespace CfnStateMachine {
    /**
     * @external
     * @link https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#api
     */
    interface TracingConfigurationProperty {
        /**
         * `CfnStateMachine.TracingConfigurationProperty.Enabled`.
         *
         * @external
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachine-tracingconfiguration.html
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
