from future.utils import with_metaclass
from ia32_python.utils.ia32_struct import *
from ia32_python.utils.ia32_bit_field import *


__doc__ = """
@brief VMX Basic Exit Reasons

VMX Basic Exit Reasons.
"""


VMX_EXIT_REASON_XCPT_OR_NMI = 0x0


VMX_EXIT_REASON_EXT_INT = 0x1


VMX_EXIT_REASON_TRIPLE_FAULT = 0x2


VMX_EXIT_REASON_INIT_SIGNAL = 0x3


VMX_EXIT_REASON_SIPI = 0x4


VMX_EXIT_REASON_IO_SMI = 0x5


VMX_EXIT_REASON_SMI = 0x6


VMX_EXIT_REASON_INT_WINDOW = 0x7


VMX_EXIT_REASON_NMI_WINDOW = 0x8


VMX_EXIT_REASON_TASK_SWITCH = 0x9


VMX_EXIT_REASON_CPUID = 0xa


VMX_EXIT_REASON_GETSEC = 0xb


VMX_EXIT_REASON_HLT = 0xc


VMX_EXIT_REASON_INVD = 0xd


VMX_EXIT_REASON_INVLPG = 0xe


VMX_EXIT_REASON_RDPMC = 0xf


VMX_EXIT_REASON_RDTSC = 0x10


VMX_EXIT_REASON_RSM = 0x11


VMX_EXIT_REASON_VMCALL = 0x12


VMX_EXIT_REASON_VMCLEAR = 0x13


VMX_EXIT_REASON_VMLAUNCH = 0x14


VMX_EXIT_REASON_VMPTRLD = 0x15


VMX_EXIT_REASON_VMPTRST = 0x16


VMX_EXIT_REASON_VMREAD = 0x17


VMX_EXIT_REASON_VMRESUME = 0x18


VMX_EXIT_REASON_VMWRITE = 0x19


VMX_EXIT_REASON_VMXOFF = 0x1a


VMX_EXIT_REASON_VMXON = 0x1b


VMX_EXIT_REASON_MOV_CRX = 0x1c


VMX_EXIT_REASON_MOV_DRX = 0x1d


VMX_EXIT_REASON_IO_INSTR = 0x1e


VMX_EXIT_REASON_RDMSR = 0x1f


VMX_EXIT_REASON_WRMSR = 0x20


VMX_EXIT_REASON_ERR_INVALID_GUEST_STATE = 0x21


VMX_EXIT_REASON_ERR_MSR_LOAD = 0x22


VMX_EXIT_REASON_MWAIT = 0x24


VMX_EXIT_REASON_MTF = 0x25


VMX_EXIT_REASON_MONITOR = 0x27


VMX_EXIT_REASON_PAUSE = 0x28


VMX_EXIT_REASON_ERR_MACHINE_CHECK = 0x29


VMX_EXIT_REASON_TPR_BELOW_THRESHOLD = 0x2b


VMX_EXIT_REASON_APIC_ACCESS = 0x2c


VMX_EXIT_REASON_VIRTUALIZED_EOI = 0x2d


VMX_EXIT_REASON_XDTR_ACCESS = 0x2e


VMX_EXIT_REASON_TR_ACCESS = 0x2f


VMX_EXIT_REASON_EPT_VIOLATION = 0x30


VMX_EXIT_REASON_EPT_MISCONFIG = 0x31


VMX_EXIT_REASON_INVEPT = 0x32


VMX_EXIT_REASON_RDTSCP = 0x33


VMX_EXIT_REASON_PREEMPT_TIMER = 0x34


VMX_EXIT_REASON_INVVPID = 0x35


VMX_EXIT_REASON_WBINVD = 0x36


VMX_EXIT_REASON_XSETBV = 0x37


VMX_EXIT_REASON_APIC_WRITE = 0x38


VMX_EXIT_REASON_RDRAND = 0x39


VMX_EXIT_REASON_INVPCID = 0x3a


VMX_EXIT_REASON_VMFUNC = 0x3b


VMX_EXIT_REASON_ENCLS = 0x3c


VMX_EXIT_REASON_RDSEED = 0x3d


VMX_EXIT_REASON_PML_FULL = 0x3e


VMX_EXIT_REASON_XSAVES = 0x3f


VMX_EXIT_REASON_XRSTORS = 0x40


