"""Initial DB structure

Revision ID: fe45dd0d3fc1
Revises: 
Create Date: 2021-05-27 10:12:14.141837

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "fe45dd0d3fc1"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "users",
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("passhash", sa.LargeBinary(), nullable=True),
        sa.Column("email_address", sa.String(), nullable=True),
        sa.Column("admin", sa.Boolean(), server_default="false", nullable=True),
        sa.Column("display_name", sa.String(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("email_verified", sa.Boolean(), nullable=True),
        sa.Column("twofa_enabled", sa.Boolean(), nullable=True),
        sa.Column("twofa_secret", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("user_id"),
        sa.UniqueConstraint("email_address"),
    )
    op.create_table(
        "email_tokens",
        sa.Column("token_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("expiry", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("token_id"),
    )
    op.create_table(
        "forms",
        sa.Column("form_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=True),
        sa.Column("requires_login", sa.Boolean(), nullable=True),
        sa.Column("multiple_responses", sa.Boolean(), nullable=True),
        sa.Column("form_title", sa.String(), nullable=False),
        sa.Column("form_description", sa.String(), nullable=True),
        sa.Column("active", sa.Boolean(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("form_id"),
    )
    op.create_table(
        "user_sessions",
        sa.Column("session_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("origin_ip", sa.String(), nullable=False),
        sa.Column("origin_agent", sa.String(), nullable=False),
        sa.Column("expiry", sa.DateTime(), nullable=True),
        sa.Column("marked_invalid", sa.Boolean(), nullable=True),
        sa.Column("last_seen", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("session_id"),
    )
    op.create_table(
        "fields",
        sa.Column("field_id", sa.String(), nullable=False),
        sa.Column("form_id", sa.String(), nullable=True),
        sa.Column("user_form_id", sa.String(), nullable=False),
        sa.Column("prompt", sa.String(), nullable=False),
        sa.Column(
            "data_type",
            sa.Enum(
                "short_text",
                "long_text",
                "multiple_choice",
                "multiple_select",
                "number",
                "date_",
                name="fieldtype",
            ),
            nullable=False,
        ),
        sa.Column("active", sa.Boolean(), nullable=True),
        sa.Column("order", sa.Integer(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(["form_id"], ["forms.form_id"],),
        sa.PrimaryKeyConstraint("field_id"),
    )
    op.create_table(
        "responses",
        sa.Column("response_id", sa.String(), nullable=False),
        sa.Column("field_id", sa.String(), nullable=True),
        sa.Column("form_id", sa.String(), nullable=True),
        sa.Column("user_id", sa.String(), nullable=True),
        sa.Column("response_data", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(["field_id"], ["fields.field_id"],),
        sa.ForeignKeyConstraint(["form_id"], ["forms.form_id"],),
        sa.ForeignKeyConstraint(["user_id"], ["users.user_id"],),
        sa.PrimaryKeyConstraint("response_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("responses")
    op.drop_table("fields")
    op.drop_table("user_sessions")
    op.drop_table("forms")
    op.drop_table("email_tokens")
    op.drop_table("users")
    # ### end Alembic commands ###
