import * as React from 'react';
import { classes } from 'typestyle';
import { fileIconStyle, fileLabelStyle, folderLabelStyle } from '../style/FilePathStyle';
import { extractFilename, getFileIconClassName } from '../utils';
function getFileIconClass(props) {
    return classes(fileIconStyle, getFileIconClassName(props.filepath, props.selected));
}
export const FilePath = (props) => {
    const filename = extractFilename(props.filepath);
    const folder = props.filepath
        .slice(0, props.filepath.length - filename.length)
        .replace(/^\/|\/$/g, ''); // Remove leading and trailing '/'
    return (React.createElement(React.Fragment, null,
        React.createElement("span", { className: getFileIconClass(props) }),
        React.createElement("span", { className: fileLabelStyle },
            filename,
            React.createElement("span", { className: folderLabelStyle }, folder))));
};
//# sourceMappingURL=FilePath.js.map