"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
});
test('Modify an InstanceFleet with static ClusterId, InstanceFleetName, and InstanceFleetConfiguration', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: 'ClusterId',
        instanceFleetName: 'InstanceFleetName',
        targetOnDemandCapacity: 2,
        targetSpotCapacity: 0,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            InstanceFleetName: 'InstanceFleetName',
            InstanceFleet: {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0,
            },
        },
    });
});
test('Modify an InstanceFleet with ClusterId from payload and static InstanceFleetName and InstanceFleetConfiguration', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: sfn.Data.stringAt('$.ClusterId'),
        instanceFleetName: 'InstanceFleetName',
        targetOnDemandCapacity: 2,
        targetSpotCapacity: 0,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId.$': '$.ClusterId',
            'InstanceFleetName': 'InstanceFleetName',
            'InstanceFleet': {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0,
            },
        },
    });
});
test('Modify an InstanceFleet with static ClusterId and InstanceFleetConfigurateion and InstanceFleetName from payload', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: 'ClusterId',
        instanceFleetName: sfn.Data.stringAt('$.InstanceFleetName'),
        targetOnDemandCapacity: 2,
        targetSpotCapacity: 0,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId': 'ClusterId',
            'InstanceFleetName.$': '$.InstanceFleetName',
            'InstanceFleet': {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0,
            },
        },
    });
});
test('Modify an InstanceFleet with static ClusterId and InstanceFleetName and Target Capacities from payload', () => {
    // WHEN
    const task = new tasks.EmrModifyInstanceFleetByName(stack, 'Task', {
        clusterId: 'ClusterId',
        instanceFleetName: 'InstanceFleetName',
        targetOnDemandCapacity: sfn.Data.numberAt('$.TargetOnDemandCapacity'),
        targetSpotCapacity: sfn.Data.numberAt('$.TargetSpotCapacity'),
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            InstanceFleetName: 'InstanceFleetName',
            InstanceFleet: {
                'TargetOnDemandCapacity.$': '$.TargetOnDemandCapacity',
                'TargetSpotCapacity.$': '$.TargetSpotCapacity',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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