"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('PutItem task', () => {
    // WHEN
    const task = new tasks.DynamoPutItem(stack, 'PutItem', {
        item: { SOME_KEY: tasks.DynamoAttributeValue.fromString('1234') },
        table,
        conditionExpression: 'ForumName <> :f and Subject <> :s',
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        expressionAttributeValues: {
            ':val': tasks.DynamoAttributeValue.numberFromString(sfn.Data.stringAt('$.Item.TotalCount.N')),
        },
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
        returnItemCollectionMetrics: tasks.DynamoItemCollectionMetrics.SIZE,
        returnValues: tasks.DynamoReturnValues.ALL_NEW,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:putItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Item: { SOME_KEY: { S: '1234' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConditionExpression: 'ForumName <> :f and Subject <> :s',
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ExpressionAttributeValues: { ':val': { 'N.$': '$.Item.TotalCount.N' } },
            ReturnConsumedCapacity: 'TOTAL',
            ReturnItemCollectionMetrics: 'SIZE',
            ReturnValues: 'ALL_NEW',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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