"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformAttributeValueMap = exports.getDynamoResourceArn = exports.DynamoMethod = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
const task_utils_1 = require("../../private/task-utils");
var DynamoMethod;
(function (DynamoMethod) {
    DynamoMethod["GET"] = "Get";
    DynamoMethod["PUT"] = "Put";
    DynamoMethod["DELETE"] = "Delete";
    DynamoMethod["UPDATE"] = "Update";
})(DynamoMethod = exports.DynamoMethod || (exports.DynamoMethod = {}));
function getDynamoResourceArn(method) {
    return task_utils_1.integrationResourceArn('dynamodb', `${method.toLowerCase()}Item`, sfn.IntegrationPattern.REQUEST_RESPONSE);
}
exports.getDynamoResourceArn = getDynamoResourceArn;
function transformAttributeValueMap(attrMap) {
    const transformedValue = {};
    for (const key in attrMap) {
        if (key) {
            transformedValue[key] = attrMap[key].toObject();
        }
    }
    return attrMap ? transformedValue : undefined;
}
exports.transformAttributeValueMap = transformAttributeValueMap;
//# sourceMappingURL=data:application/json;base64,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