"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoGetItem = void 0;
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoGetItem
 */
class DynamoGetItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.GET}Item`],
            }),
        ];
    }
    renderTask() {
        var _a;
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.GET),
            Parameters: sfn.FieldUtils.renderObject({
                Key: utils_1.transformAttributeValueMap(this.props.key),
                TableName: this.props.table.tableName,
                ConsistentRead: (_a = this.props.consistentRead) !== null && _a !== void 0 ? _a : false,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ProjectionExpression: this.configureProjectionExpression(this.props.projectionExpression),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
            }),
        };
    }
    configureProjectionExpression(expressions) {
        return expressions ? expressions.map((expression) => expression.toString()).join(',') : undefined;
    }
}
exports.DynamoGetItem = DynamoGetItem;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LWl0ZW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJnZXQtaXRlbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx3Q0FBd0M7QUFDeEMsa0RBQWtEO0FBQ2xELHdDQUFpRDtBQUNqRCwyQ0FBaUc7QUE2RGpHOztHQUVHO0FBQ0gsTUFBYSxhQUFjLFNBQVEsR0FBRyxDQUFDLGFBQWE7SUFJbEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBbUIsS0FBeUI7UUFDbEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFEaUMsVUFBSyxHQUFMLEtBQUssQ0FBb0I7UUFHbEYsSUFBSSxDQUFDLFlBQVksR0FBRztZQUNsQixJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7Z0JBQ3RCLFNBQVMsRUFBRTtvQkFDVCxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQzt3QkFDdkIsT0FBTyxFQUFFLFVBQVU7d0JBQ25CLFFBQVEsRUFBRSxPQUFPO3dCQUNqQixZQUFZLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTO3FCQUNwQyxDQUFDO2lCQUNIO2dCQUNELE9BQU8sRUFBRSxDQUFDLFlBQVksb0JBQVksQ0FBQyxHQUFHLE1BQU0sQ0FBQzthQUM5QyxDQUFDO1NBQ0gsQ0FBQztJQUNKLENBQUM7SUFFUyxVQUFVOztRQUNsQixPQUFPO1lBQ0wsUUFBUSxFQUFFLDRCQUFvQixDQUFDLG9CQUFZLENBQUMsR0FBRyxDQUFDO1lBQ2hELFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztnQkFDdEMsR0FBRyxFQUFFLGtDQUEwQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDO2dCQUMvQyxTQUFTLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDckMsY0FBYyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxtQ0FBSSxLQUFLO2dCQUNsRCx3QkFBd0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLHdCQUF3QjtnQkFDN0Qsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLDZCQUE2QixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLENBQUM7Z0JBQ3pGLHNCQUFzQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsc0JBQXNCO2FBQzFELENBQUM7U0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVPLDZCQUE2QixDQUFDLFdBQTBDO1FBQzlFLE9BQU8sV0FBVyxDQUFDLENBQUMsQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQyxVQUFVLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUNwRyxDQUFDO0NBQ0Y7QUF0Q0Qsc0NBc0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZGRiIGZyb20gJ0Bhd3MtY2RrL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgRHluYW1vTWV0aG9kLCBnZXREeW5hbW9SZXNvdXJjZUFybiwgdHJhbnNmb3JtQXR0cmlidXRlVmFsdWVNYXAgfSBmcm9tICcuL3ByaXZhdGUvdXRpbHMnO1xuaW1wb3J0IHsgRHluYW1vQXR0cmlidXRlVmFsdWUsIER5bmFtb0NvbnN1bWVkQ2FwYWNpdHksIER5bmFtb1Byb2plY3Rpb25FeHByZXNzaW9uIH0gZnJvbSAnLi9zaGFyZWQtdHlwZXMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIER5bmFtb0dldEl0ZW0gVGFza1xuICovXG5leHBvcnQgaW50ZXJmYWNlIER5bmFtb0dldEl0ZW1Qcm9wcyBleHRlbmRzIHNmbi5UYXNrU3RhdGVCYXNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHRhYmxlIGNvbnRhaW5pbmcgdGhlIHJlcXVlc3RlZCBpdGVtLlxuICAgKi9cbiAgcmVhZG9ubHkgdGFibGU6IGRkYi5JVGFibGU7XG5cbiAgLyoqXG4gICAqIFByaW1hcnkga2V5IG9mIHRoZSBpdGVtIHRvIHJldHJpZXZlLlxuICAgKlxuICAgKiBGb3IgdGhlIHByaW1hcnkga2V5LCB5b3UgbXVzdCBwcm92aWRlIGFsbCBvZiB0aGUgYXR0cmlidXRlcy5cbiAgICogRm9yIGV4YW1wbGUsIHdpdGggYSBzaW1wbGUgcHJpbWFyeSBrZXksIHlvdSBvbmx5IG5lZWQgdG8gcHJvdmlkZSBhIHZhbHVlIGZvciB0aGUgcGFydGl0aW9uIGtleS5cbiAgICogRm9yIGEgY29tcG9zaXRlIHByaW1hcnkga2V5LCB5b3UgbXVzdCBwcm92aWRlIHZhbHVlcyBmb3IgYm90aCB0aGUgcGFydGl0aW9uIGtleSBhbmQgdGhlIHNvcnQga2V5LlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hbWF6b25keW5hbW9kYi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRJdGVtLmh0bWwjRERCLUdldEl0ZW0tcmVxdWVzdC1LZXlcbiAgICovXG4gIHJlYWRvbmx5IGtleTogeyBba2V5OiBzdHJpbmddOiBEeW5hbW9BdHRyaWJ1dGVWYWx1ZSB9O1xuXG4gIC8qKlxuICAgKiBEZXRlcm1pbmVzIHRoZSByZWFkIGNvbnNpc3RlbmN5IG1vZGVsOlxuICAgKiBJZiBzZXQgdG8gdHJ1ZSwgdGhlbiB0aGUgb3BlcmF0aW9uIHVzZXMgc3Ryb25nbHkgY29uc2lzdGVudCByZWFkcztcbiAgICogb3RoZXJ3aXNlLCB0aGUgb3BlcmF0aW9uIHVzZXMgZXZlbnR1YWxseSBjb25zaXN0ZW50IHJlYWRzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgY29uc2lzdGVudFJlYWQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBPbmUgb3IgbW9yZSBzdWJzdGl0dXRpb24gdG9rZW5zIGZvciBhdHRyaWJ1dGUgbmFtZXMgaW4gYW4gZXhwcmVzc2lvblxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hbWF6b25keW5hbW9kYi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRJdGVtLmh0bWwjRERCLUdldEl0ZW0tcmVxdWVzdC1FeHByZXNzaW9uQXR0cmlidXRlTmFtZXNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBleHByZXNzaW9uIGF0dHJpYnV0ZXNcbiAgICovXG4gIHJlYWRvbmx5IGV4cHJlc3Npb25BdHRyaWJ1dGVOYW1lcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIEFuIGFycmF5IG9mIER5bmFtb1Byb2plY3Rpb25FeHByZXNzaW9uIHRoYXQgaWRlbnRpZmllcyBvbmUgb3IgbW9yZSBhdHRyaWJ1dGVzIHRvIHJldHJpZXZlIGZyb20gdGhlIHRhYmxlLlxuICAgKiBUaGVzZSBhdHRyaWJ1dGVzIGNhbiBpbmNsdWRlIHNjYWxhcnMsIHNldHMsIG9yIGVsZW1lbnRzIG9mIGEgSlNPTiBkb2N1bWVudC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0SXRlbS5odG1sI0REQi1HZXRJdGVtLXJlcXVlc3QtUHJvamVjdGlvbkV4cHJlc3Npb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBwcm9qZWN0aW9uIGV4cHJlc3Npb25cbiAgICovXG4gIHJlYWRvbmx5IHByb2plY3Rpb25FeHByZXNzaW9uPzogRHluYW1vUHJvamVjdGlvbkV4cHJlc3Npb25bXTtcblxuICAvKipcbiAgICogRGV0ZXJtaW5lcyB0aGUgbGV2ZWwgb2YgZGV0YWlsIGFib3V0IHByb3Zpc2lvbmVkIHRocm91Z2hwdXQgY29uc3VtcHRpb24gdGhhdCBpcyByZXR1cm5lZCBpbiB0aGUgcmVzcG9uc2VcbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0SXRlbS5odG1sI0REQi1HZXRJdGVtLXJlcXVlc3QtUmV0dXJuQ29uc3VtZWRDYXBhY2l0eVxuICAgKlxuICAgKiBAZGVmYXVsdCBEeW5hbW9Db25zdW1lZENhcGFjaXR5Lk5PTkVcbiAgICovXG4gIHJlYWRvbmx5IHJldHVybkNvbnN1bWVkQ2FwYWNpdHk/OiBEeW5hbW9Db25zdW1lZENhcGFjaXR5O1xufVxuXG4vKipcbiAqIEEgU3RlcEZ1bmN0aW9ucyB0YXNrIHRvIGNhbGwgRHluYW1vR2V0SXRlbVxuICovXG5leHBvcnQgY2xhc3MgRHluYW1vR2V0SXRlbSBleHRlbmRzIHNmbi5UYXNrU3RhdGVCYXNlIHtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tNZXRyaWNzPzogc2ZuLlRhc2tNZXRyaWNzQ29uZmlnO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdGFza1BvbGljaWVzPzogaWFtLlBvbGljeVN0YXRlbWVudFtdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IER5bmFtb0dldEl0ZW1Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgdGhpcy50YXNrUG9saWNpZXMgPSBbXG4gICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIHJlc291cmNlczogW1xuICAgICAgICAgIFN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgICAgICBzZXJ2aWNlOiAnZHluYW1vZGInLFxuICAgICAgICAgICAgcmVzb3VyY2U6ICd0YWJsZScsXG4gICAgICAgICAgICByZXNvdXJjZU5hbWU6IHByb3BzLnRhYmxlLnRhYmxlTmFtZSxcbiAgICAgICAgICB9KSxcbiAgICAgICAgXSxcbiAgICAgICAgYWN0aW9uczogW2BkeW5hbW9kYjoke0R5bmFtb01ldGhvZC5HRVR9SXRlbWBdLFxuICAgICAgfSksXG4gICAgXTtcbiAgfVxuXG4gIHByb3RlY3RlZCByZW5kZXJUYXNrKCk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIFJlc291cmNlOiBnZXREeW5hbW9SZXNvdXJjZUFybihEeW5hbW9NZXRob2QuR0VUKSxcbiAgICAgIFBhcmFtZXRlcnM6IHNmbi5GaWVsZFV0aWxzLnJlbmRlck9iamVjdCh7XG4gICAgICAgIEtleTogdHJhbnNmb3JtQXR0cmlidXRlVmFsdWVNYXAodGhpcy5wcm9wcy5rZXkpLFxuICAgICAgICBUYWJsZU5hbWU6IHRoaXMucHJvcHMudGFibGUudGFibGVOYW1lLFxuICAgICAgICBDb25zaXN0ZW50UmVhZDogdGhpcy5wcm9wcy5jb25zaXN0ZW50UmVhZCA/PyBmYWxzZSxcbiAgICAgICAgRXhwcmVzc2lvbkF0dHJpYnV0ZU5hbWVzOiB0aGlzLnByb3BzLmV4cHJlc3Npb25BdHRyaWJ1dGVOYW1lcyxcbiAgICAgICAgUHJvamVjdGlvbkV4cHJlc3Npb246IHRoaXMuY29uZmlndXJlUHJvamVjdGlvbkV4cHJlc3Npb24odGhpcy5wcm9wcy5wcm9qZWN0aW9uRXhwcmVzc2lvbiksXG4gICAgICAgIFJldHVybkNvbnN1bWVkQ2FwYWNpdHk6IHRoaXMucHJvcHMucmV0dXJuQ29uc3VtZWRDYXBhY2l0eSxcbiAgICAgIH0pLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIGNvbmZpZ3VyZVByb2plY3Rpb25FeHByZXNzaW9uKGV4cHJlc3Npb25zPzogRHluYW1vUHJvamVjdGlvbkV4cHJlc3Npb25bXSk6IHN0cmluZyB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIGV4cHJlc3Npb25zID8gZXhwcmVzc2lvbnMubWFwKChleHByZXNzaW9uKSA9PiBleHByZXNzaW9uLnRvU3RyaW5nKCkpLmpvaW4oJywnKSA6IHVuZGVmaW5lZDtcbiAgfVxufVxuIl19