from abc import ABCMeta, abstractmethod
from collections.abc import Generator
from typing import Any, ClassVar
from typing_extensions import Final

from .DirectObject import DirectObject
from .PythonUtil import ScratchPad

class Job(DirectObject, metaclass=ABCMeta):
    Done: Final[object]
    Continue: Final = None
    Sleep: Final[object]
    Priorities: ClassVar[ScratchPad[int]]
    def __init__(self, name: str) -> None: ...
    def destroy(self) -> None: ...
    def getFinishedEvent(self) -> str: ...
    @abstractmethod
    def run(self) -> Generator[Any | None, None, None]: ...
    def getPriority(self) -> int: ...
    def setPriority(self, priority: int) -> int: ...
    def printingBegin(self) -> None: ...
    def printingEnd(self) -> None: ...
    def resume(self) -> None: ...
    def suspend(self) -> None: ...
    def isFinished(self) -> bool: ...
    def finished(self) -> None: ...
    def getJobName(self) -> str: ...
