from _typeshed import StrOrBytesPath
from collections.abc import Callable, Iterable
from typing_extensions import Literal

from direct._typing import Obj, Unused
from direct.gui.OnscreenText import OnscreenText
from direct.showbase.DirectObject import DirectObject
from direct.wxwidgets.ViewPort import Viewport
from panda3d.core import BitMask32, NodePath

from .ActionMgr import ActionMgr
from .CurveEditor import CurveEditor
from .FileMgr import FileMgr

class LevelEditorBase(DirectObject):
    currentFile: StrOrBytesPath | None
    fNeedToSave: bool
    actionEvents: list[tuple[str, Callable[..., None]]]
    curveEditor: CurveEditor
    fileMgr: FileMgr
    actionMgr: ActionMgr
    fMoveCamera: bool
    NPParent: NodePath
    settingsFile: StrOrBytesPath | None
    BASE_MODE: BitMask32
    CREATE_CURVE_MODE: BitMask32
    EDIT_CURVE_MODE: BitMask32
    ANIM_MODE: BitMask32
    GRAPH_EDITOR: bool
    mode: BitMask32
    preMode: None
    statusReadout: OnscreenText
    statusLines: list
    def __init__(self) -> None: ...
    def initialize(self) -> None: ...
    def setTitleWithFilename(self, filename: str | bytes = ...) -> None: ...
    def removeNodePathHook(self, nodePath: NodePath | None) -> None: ...
    def toggleWidget(self) -> None: ...
    def handleMouse1(self, modifiers: int) -> None: ...
    def handleMouse1Up(self) -> None: ...
    def handleMouse2(self, modifiers: int) -> None: ...
    def handleMouse2Up(self) -> None: ...
    def handleMouse3(self, modifiers: int) -> None: ...
    def handleMouse3Up(self) -> None: ...
    def handleDelete(self) -> None: ...
    def cleanUpManipulating(self, selectedNPs: Iterable[NodePath]) -> None: ...
    def select(
        self,
        nodePath: NodePath,
        fMultiSelect: bool = ...,
        fSelectTag: bool = ...,
        fResetAncestry: bool = ...,
        fLEPane: bool = ...,
        fUndo: bool = ...,
    ) -> None: ...
    def selectedNodePathHook(
        self, nodePath: NodePath, fMultiSelect: bool = ..., fSelectTag: bool = ..., fLEPane: bool = ...
    ) -> None: ...
    def deselectAll(self, np: Unused = ...) -> None: ...
    def deselectAllCB(self, dnp: Unused = ...) -> None: ...
    def reset(self) -> None: ...
    def resetOrthoCam(self, view: Viewport) -> None: ...
    def save(self) -> None: ...
    def saveAs(self, fileName: StrOrBytesPath) -> None: ...
    def load(self, fileName: StrOrBytesPath) -> None: ...
    def saveSettings(self) -> None: ...
    def loadSettings(self) -> None: ...
    def convertMaya(
        self, modelname, callBack: Callable[[list[str]], object], obj: Obj | None = ..., isAnim: bool = ...
    ) -> None: ...
    def convertFromMaya(self, modelname, callBack: Callable[[list[str]], object]) -> None: ...
    def exportToMaya(self, mayaFileName: str) -> None: ...
    def exportToMayaCB(self, mayaFileName: str, exportRootNP) -> None: ...
    def updateStatusReadout(self, status, color=...) -> None: ...
    def updateStatusReadoutTimeouts(self, task=...) -> Literal[2]: ...
    def propMeetsReq(self, typeName: Unused, parentNP): ...
