__all__ = ['DirectScrolledList', 'DirectScrolledListItem']

from typing import Any, ClassVar

from direct.directnotify.Notifier import Notifier
from panda3d.core import NodePath

from .DirectButton import DirectButton
from .DirectFrame import DirectFrame

class DirectScrolledListItem(DirectButton):
    notify: ClassVar[Notifier]
    def __init__(self, parent: NodePath | None = ..., **kw: Any) -> None: ...
    def select(self) -> None: ...

class DirectScrolledList(DirectFrame):
    notify: ClassVar[Notifier]
    index: int
    nextItemID: int
    incButton: DirectButton
    decButton: DirectButton
    itemFrame: DirectFrame
    currentSelected: DirectScrolledListItem
    def __init__(self, parent: NodePath | None = ..., **kw: Any) -> None: ...
    def setForceHeight(self) -> None: ...
    def recordMaxHeight(self) -> None: ...
    def setScrollSpeed(self) -> None: ...
    def setNumItemsVisible(self) -> None: ...
    def selectListItem(self, item: DirectScrolledListItem) -> None: ...
    def scrollBy(self, delta: int) -> None: ...
    def getItemIndexForItemID(self, itemID: int) -> int: ...
    def scrollToItemID(self, itemID: int, centered: bool = ...) -> None: ...
    def scrollTo(self, index: int, centered: bool = ...) -> bool: ...
    def makeAllItems(self) -> None: ...
    def addItem(self, item: DirectScrolledListItem | str, refresh: bool = ...) -> None: ...
    def removeItem(self, item: DirectScrolledListItem | str, refresh: bool = ...) -> bool: ...
    def removeAndDestroyItem(self, item: DirectScrolledListItem, refresh: bool = ...) -> bool: ...
    def removeAllItems(self, refresh: bool = ...) -> bool: ...
    def removeAndDestroyAllItems(self, refresh: bool = ...) -> bool: ...
    def refresh(self) -> None: ...
    def getSelectedIndex(self) -> int: ...
    def getSelectedText(self) -> str: ...
    def setIncButtonCallback(self) -> None: ...
    def setDecButtonCallback(self) -> None: ...
