from _typeshed import Self
from collections.abc import Callable
from typing import ClassVar, Protocol
from typing_extensions import Final

from direct.directnotify.Notifier import Notifier
from direct.distributed.DistributedObject import DistributedObject
from direct.showbase.DirectObject import DirectObject
from panda3d.core import ConfigVariableBool, DatagramIterator

class _HasNum(Protocol):
    num: int

NO_CONTEXT: Final = 0

class InterestState:
    StateActive: ClassVar[str]
    StatePendingDel: ClassVar[str]
    desc: str
    state: str
    context: int
    events: list[str]
    eventCounter: _HasNum
    parentId: int
    zoneIdList: list[int]
    auto: bool
    def __init__(
        self,
        desc: str,
        state: str,
        context: int,
        event: str,
        parentId: int,
        zoneIdList: list[int],
        eventCounter: _HasNum,
        auto: bool = ...,
    ) -> None: ...
    def addEvent(self, event: str) -> None: ...
    def getEvents(self) -> list[str]: ...
    def clearEvents(self) -> None: ...
    def sendEvents(self) -> None: ...
    def setDesc(self, desc: str) -> None: ...
    def isPendingDelete(self) -> bool: ...

class InterestHandle:
    def __init__(self, id: int) -> None: ...
    def asInt(self) -> int: ...
    def __eq__(self: Self, other: Self | int) -> bool: ...  # type: ignore[override]

class DoInterestManager(DirectObject):
    notify: ClassVar[Notifier]
    InterestDebug: ClassVar[ConfigVariableBool]
    def __init__(self) -> None: ...
    def setNoNewInterests(self, flag: bool) -> None: ...
    def noNewInterests(self) -> bool: ...
    def setAllInterestsCompleteCallback(self, callback: Callable[[], object]) -> None: ...
    def getAllInterestsCompleteEvent(self) -> str: ...
    def resetInterestStateForConnectionLoss(self) -> None: ...
    def isValidInterestHandle(self, handle: InterestHandle) -> bool: ...
    def updateInterestDescription(self, handle: InterestHandle, desc: str) -> None: ...
    def addInterest(
        self, parentId: int, zoneIdList: list[int], description: str, event: str | None = ...
    ) -> InterestHandle | None: ...
    def addAutoInterest(self, parentId: int, zoneIdList: list[int], description: str) -> InterestHandle | None: ...
    def removeInterest(self, handle: InterestHandle, event: str | None = ...) -> bool: ...
    def removeAutoInterest(self, handle: InterestHandle) -> bool: ...
    def removeAIInterest(self, handle: int) -> None: ...
    def alterInterest(
        self, handle: InterestHandle, parentId: int, zoneIdList: list[int], description: str | None = ..., event: str | None = ...
    ) -> bool: ...
    def openAutoInterests(self, obj: DistributedObject) -> None: ...
    def closeAutoInterests(self, obj: DistributedObject) -> None: ...
    def cleanupWaitAllInterestsComplete(self) -> None: ...
    def queueAllInterestsCompleteEvent(self, frames: int = ...) -> None: ...
    def handleInterestDoneMessage(self, di: DatagramIterator) -> None: ...
