from typing import Any, ClassVar, Protocol
from typing_extensions import Literal

from direct._typing import Unused
from direct.directnotify.Notifier import Notifier
from panda3d.core import ConfigVariableBool

from .InputState import InputStateForceToken, InputStateToken, InputStateTokenGroup

class _Controls(Protocol):
    def setWalkSpeed(self, forward: float, jump: float, reverse: float, rotate: float) -> object: ...
    def setAvatar(self, avatar: Any) -> object: ...
    def disableAvatarControls(self) -> object: ...
    def setCollisionsActive(self, active: bool = ...) -> object: ...
    def deleteCollisions(self) -> object: ...
    def setTag(self, key: str, value: str) -> object: ...

CollisionHandlerRayStart: float

class ControlManager:
    notify: ClassVar[Notifier]
    wantWASD: ClassVar[ConfigVariableBool]
    passMessagesThrough: bool
    inputStateTokens: list[InputStateToken]
    WASDTurnTokens: list[InputStateTokenGroup]
    controls: dict[str, _Controls]
    currentControls: _Controls | None
    currentControlsName: str | None
    isEnabled: bool
    forceAvJumpToken: InputStateForceToken | None
    def __init__(self, enable: bool = ..., passMessagesThrough: bool = ...) -> None: ...
    def add(self, controls: _Controls, name: str = ...) -> None: ...
    def get(self, name: str) -> _Controls | None: ...
    def remove(self, name: str) -> None: ...
    def use(self, name: str, avatar: Any) -> None: ...
    def setSpeeds(
        self,
        forwardSpeed: float,
        jumpForce: float,
        reverseSpeed: float,
        rotateSpeed: float,
        strafeLeft: Unused = ...,
        strafeRight: Unused = ...,
    ) -> None: ...
    def delete(self) -> None: ...
    def getSpeeds(self) -> tuple[float, ...] | None: ...
    def getIsAirborne(self) -> bool: ...
    def setTag(self, key: str, value: str) -> None: ...
    def deleteCollisions(self) -> None: ...
    def collisionsOn(self) -> None: ...
    def collisionsOff(self) -> None: ...
    def placeOnFloor(self) -> None: ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def stop(self) -> None: ...
    def disableAvatarJump(self) -> None: ...
    def enableAvatarJump(self) -> None: ...
    def monitor(self, foo: Unused) -> Literal[1]: ...
    def setWASDTurn(self, turn: bool) -> None: ...
