# Table of contents

* [About Launchable](README.md)
* [Getting started](getting-started/README.md)
  * [Using the CLI with a public repository](getting-started/using-the-cli-with-a-public-repository.md)
* [Sending data to Launchable](sending-data-to-launchable/README.md)
  * [Choosing a value for \<BUILD NAME>](sending-data-to-launchable/choosing-a-value-for-build-name.md)
  * [Converting test reports to JUnit format](sending-data-to-launchable/converting-test-reports-to-junit-format.md)
  * [Ensuring \`record tests\` always runs](sending-data-to-launchable/ensuring-record-tests-always-runs.md)
  * [Managing complex test session layouts](sending-data-to-launchable/managing-complex-test-session-layouts.md)
  * [Recording builds from multiple repositories](sending-data-to-launchable/recording-builds-from-multiple-repositories.md)
  * [Use 'flavors' to run the best tests for an environment](sending-data-to-launchable/use-flavors-to-run-the-best-tests-for-an-environment.md)
  * [Using the generic file-based runner integration](sending-data-to-launchable/using-the-generic-file-based-runner-integration.md)

## 💡Insights

* [Flaky Test Insights](insights/flaky-tests.md)

## 🎛Actions

* [Predictive Test Selection](actions/predictive-test-selection/README.md)
  * [FAQ](actions/predictive-test-selection/faq.md)
  * [Subsetting your test runs](actions/predictive-test-selection/subsetting-your-test-runs.md)

## 📖Resources

* [CLI reference](resources/cli-reference.md)
* [Integrations](resources/integrations/README.md)
  * [Android Debug Bridge (adb)](resources/integrations/adb.md)
  * [Ant](resources/integrations/ant.md)
  * [Bazel](resources/integrations/bazel.md)
  * [Behave](resources/integrations/behave.md)
  * [CTest](resources/integrations/ctest.md)
  * [cucumber](resources/integrations/cucumber.md)
  * [Cypress](resources/integrations/cypress.md)
  * [GoogleTest](resources/integrations/googletest.md)
  * [Go Test](resources/integrations/go-test.md)
  * [Gradle](resources/integrations/gradle.md)
  * [Jest](resources/integrations/jest.md)
  * [Maven](resources/integrations/maven.md)
  * [minitest](resources/integrations/minitest.md)
  * [nose](resources/integrations/nose.md)
  * [NUnit](resources/integrations/nunit.md)
  * [pytest](resources/integrations/pytest.md)
  * [\`raw\` profile for custom test runners](resources/integrations/raw.md)
  * [Robot](resources/integrations/robot.md)
  * [RSpec](resources/integrations/rspec.md)
* [Supported languages](resources/supported-languages/README.md)
  * [C++](resources/supported-languages/c-plus-plus.md)
  * [.NET](resources/supported-languages/dotnet.md)
  * [Go](resources/supported-languages/go.md)
  * [Java](resources/supported-languages/java.md)
  * [JavaScript](resources/supported-languages/javascript.md)
  * [Python](resources/supported-languages/python.md)
  * [Ruby](resources/supported-languages/ruby.md)
* [Troubleshooting](resources/troubleshooting.md)

## 🔒Policies

* [Data privacy and protection](policies/data-privacy-and-protection/README.md)
  * [Data examples](policies/data-privacy-and-protection/data-examples.md)
* [Security policies](policies/security-policies.md)
