"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsInvokeActivity = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_StepFunctionsInvokeActivityProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsInvokeActivity);
            }
            throw error;
        }
        this.taskMetrics = {
            metricDimensions: { ActivityArn: this.props.activity.activityArn },
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: this.props.activity.activityArn,
        };
    }
}
exports.StepFunctionsInvokeActivity = StepFunctionsInvokeActivity;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsInvokeActivity[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.StepFunctionsInvokeActivity", version: "1.163.1" };
//# sourceMappingURL=data:application/json;base64,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