"""
    Aqualink API documentation

    The Aqualink public API documentation  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from aqualink_sdk.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from aqualink_sdk.exceptions import ApiAttributeError


def lazy_import():
    from aqualink_sdk.model.daily_data import DailyData
    from aqualink_sdk.model.site import Site
    from aqualink_sdk.model.site_survey_point import SiteSurveyPoint
    from aqualink_sdk.model.survey_media import SurveyMedia
    from aqualink_sdk.model.survey_media_sensor_data import SurveyMediaSensorData
    from aqualink_sdk.model.user import User
    globals()['DailyData'] = DailyData
    globals()['Site'] = Site
    globals()['SiteSurveyPoint'] = SiteSurveyPoint
    globals()['SurveyMedia'] = SurveyMedia
    globals()['SurveyMediaSensorData'] = SurveyMediaSensorData
    globals()['User'] = User


class Survey(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('weather_conditions',): {
            'CALM': "calm",
            'WAVES': "waves",
            'STORM': "storm",
            'NO-DATA': "no-data",
        },
        ('observations',): {
            'ANTHROPOGENIC': "anthropogenic",
            'ENVIRONMENTAL': "environmental",
            'EVIDENT-DISEASE': "evident-disease",
            'HEALTHY': "healthy",
            'INVASIVE-SPECIES': "invasive-species",
            'MORTALITY': "mortality",
            'NO-DATA': "no-data",
            'POSSIBLE-DISEASE': "possible-disease",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (float,),  # noqa: E501
            'weather_conditions': (str,),  # noqa: E501
            'dive_date': (datetime,),  # noqa: E501
            'user': (User,),  # noqa: E501
            'site_id': (float,),  # noqa: E501
            'site': (Site,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'temperature': (float, none_type,),  # noqa: E501
            'comments': (str, none_type,),  # noqa: E501
            'sensor_data': (SurveyMediaSensorData,),  # noqa: E501
            'featured_survey_media': (SurveyMedia,),  # noqa: E501
            'survey_media': ([SurveyMedia],),  # noqa: E501
            'latest_daily_data': (DailyData,),  # noqa: E501
            'survey_points': ([SiteSurveyPoint],),  # noqa: E501
            'observations': ([str],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'weather_conditions': 'weatherConditions',  # noqa: E501
        'dive_date': 'diveDate',  # noqa: E501
        'user': 'user',  # noqa: E501
        'site_id': 'siteId',  # noqa: E501
        'site': 'site',  # noqa: E501
        'created_at': 'createdAt',  # noqa: E501
        'updated_at': 'updatedAt',  # noqa: E501
        'temperature': 'temperature',  # noqa: E501
        'comments': 'comments',  # noqa: E501
        'sensor_data': 'sensorData',  # noqa: E501
        'featured_survey_media': 'featuredSurveyMedia',  # noqa: E501
        'survey_media': 'surveyMedia',  # noqa: E501
        'latest_daily_data': 'latestDailyData',  # noqa: E501
        'survey_points': 'surveyPoints',  # noqa: E501
        'observations': 'observations',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, weather_conditions, dive_date, user, site_id, site, created_at, updated_at, *args, **kwargs):  # noqa: E501
        """Survey - a model defined in OpenAPI

        Args:
            id (float):
            weather_conditions (str):
            dive_date (datetime):
            user (User):
            site_id (float):
            site (Site):
            created_at (datetime):
            updated_at (datetime):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            temperature (float, none_type): [optional]  # noqa: E501
            comments (str, none_type): [optional]  # noqa: E501
            sensor_data (SurveyMediaSensorData): [optional]  # noqa: E501
            featured_survey_media (SurveyMedia): [optional]  # noqa: E501
            survey_media ([SurveyMedia]): [optional]  # noqa: E501
            latest_daily_data (DailyData): [optional]  # noqa: E501
            survey_points ([SiteSurveyPoint]): [optional]  # noqa: E501
            observations ([str]): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.weather_conditions = weather_conditions
        self.dive_date = dive_date
        self.user = user
        self.site_id = site_id
        self.site = site
        self.created_at = created_at
        self.updated_at = updated_at
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, weather_conditions, dive_date, user, site_id, site, created_at, updated_at, *args, **kwargs):  # noqa: E501
        """Survey - a model defined in OpenAPI

        Args:
            id (float):
            weather_conditions (str):
            dive_date (datetime):
            user (User):
            site_id (float):
            site (Site):
            created_at (datetime):
            updated_at (datetime):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            temperature (float, none_type): [optional]  # noqa: E501
            comments (str, none_type): [optional]  # noqa: E501
            sensor_data (SurveyMediaSensorData): [optional]  # noqa: E501
            featured_survey_media (SurveyMedia): [optional]  # noqa: E501
            survey_media ([SurveyMedia]): [optional]  # noqa: E501
            latest_daily_data (DailyData): [optional]  # noqa: E501
            survey_points ([SiteSurveyPoint]): [optional]  # noqa: E501
            observations ([str]): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.weather_conditions = weather_conditions
        self.dive_date = dive_date
        self.user = user
        self.site_id = site_id
        self.site = site
        self.created_at = created_at
        self.updated_at = updated_at
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
