"""
    Aqualink API documentation

    The Aqualink public API documentation  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from aqualink_sdk.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from aqualink_sdk.exceptions import ApiAttributeError


def lazy_import():
    from aqualink_sdk.model.collection_data_dto import CollectionDataDto
    from aqualink_sdk.model.historical_monthly_mean import HistoricalMonthlyMean
    from aqualink_sdk.model.region import Region
    from aqualink_sdk.model.site_application import SiteApplication
    from aqualink_sdk.model.sofar_live_data_dto import SofarLiveDataDto
    from aqualink_sdk.model.survey import Survey
    from aqualink_sdk.model.user import User
    from aqualink_sdk.model.user_location import UserLocation
    from aqualink_sdk.model.video_stream import VideoStream
    globals()['CollectionDataDto'] = CollectionDataDto
    globals()['HistoricalMonthlyMean'] = HistoricalMonthlyMean
    globals()['Region'] = Region
    globals()['SiteApplication'] = SiteApplication
    globals()['SofarLiveDataDto'] = SofarLiveDataDto
    globals()['Survey'] = Survey
    globals()['User'] = User
    globals()['UserLocation'] = UserLocation
    globals()['VideoStream'] = VideoStream


class Site(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'IN_REVIEW': "in_review",
            'REJECTED': "rejected",
            'APPROVED': "approved",
            'SHIPPED': "shipped",
            'DEPLOYED': "deployed",
            'MAINTENANCE': "maintenance",
            'LOST': "lost",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (float,),  # noqa: E501
            'name': (str, none_type,),  # noqa: E501
            'sensor_id': (str, none_type,),  # noqa: E501
            'polygon': (UserLocation,),  # noqa: E501
            'depth': (float, none_type,),  # noqa: E501
            'max_monthly_mean': (float, none_type,),  # noqa: E501
            'timezone': (str, none_type,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'video_stream': (str, none_type,),  # noqa: E501
            'display': (bool,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'region': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'stream': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'admins': ([User],),  # noqa: E501
            'has_hobo': (bool,),  # noqa: E501
            'surveys': ([Survey],),  # noqa: E501
            'historical_monthly_mean': ([HistoricalMonthlyMean],),  # noqa: E501
            'site_application': (SiteApplication,),  # noqa: E501
            'live_data': ([SofarLiveDataDto],),  # noqa: E501
            'collection_data': (CollectionDataDto,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'sensor_id': 'sensorId',  # noqa: E501
        'polygon': 'polygon',  # noqa: E501
        'depth': 'depth',  # noqa: E501
        'max_monthly_mean': 'maxMonthlyMean',  # noqa: E501
        'timezone': 'timezone',  # noqa: E501
        'status': 'status',  # noqa: E501
        'video_stream': 'videoStream',  # noqa: E501
        'display': 'display',  # noqa: E501
        'created_at': 'createdAt',  # noqa: E501
        'updated_at': 'updatedAt',  # noqa: E501
        'region': 'region',  # noqa: E501
        'stream': 'stream',  # noqa: E501
        'admins': 'admins',  # noqa: E501
        'has_hobo': 'hasHobo',  # noqa: E501
        'surveys': 'surveys',  # noqa: E501
        'historical_monthly_mean': 'historicalMonthlyMean',  # noqa: E501
        'site_application': 'siteApplication',  # noqa: E501
        'live_data': 'liveData',  # noqa: E501
        'collection_data': 'collectionData',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, name, sensor_id, polygon, depth, max_monthly_mean, timezone, status, video_stream, display, created_at, updated_at, region, stream, admins, has_hobo, *args, **kwargs):  # noqa: E501
        """Site - a model defined in OpenAPI

        Args:
            id (float):
            name (str, none_type):
            sensor_id (str, none_type):
            polygon (UserLocation):
            depth (float, none_type):
            max_monthly_mean (float, none_type):
            timezone (str, none_type):
            status (str):
            video_stream (str, none_type):
            display (bool):
            created_at (datetime):
            updated_at (datetime):
            region (bool, date, datetime, dict, float, int, list, str, none_type):
            stream (bool, date, datetime, dict, float, int, list, str, none_type):
            admins ([User]):
            has_hobo (bool):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            surveys ([Survey]): [optional]  # noqa: E501
            historical_monthly_mean ([HistoricalMonthlyMean]): [optional]  # noqa: E501
            site_application (SiteApplication): [optional]  # noqa: E501
            live_data ([SofarLiveDataDto]): [optional]  # noqa: E501
            collection_data (CollectionDataDto): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.name = name
        self.sensor_id = sensor_id
        self.polygon = polygon
        self.depth = depth
        self.max_monthly_mean = max_monthly_mean
        self.timezone = timezone
        self.status = status
        self.video_stream = video_stream
        self.display = display
        self.created_at = created_at
        self.updated_at = updated_at
        self.region = region
        self.stream = stream
        self.admins = admins
        self.has_hobo = has_hobo
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, name, sensor_id, polygon, depth, max_monthly_mean, timezone, status, video_stream, display, created_at, updated_at, region, stream, admins, has_hobo, *args, **kwargs):  # noqa: E501
        """Site - a model defined in OpenAPI

        Args:
            id (float):
            name (str, none_type):
            sensor_id (str, none_type):
            polygon (UserLocation):
            depth (float, none_type):
            max_monthly_mean (float, none_type):
            timezone (str, none_type):
            status (str):
            video_stream (str, none_type):
            display (bool):
            created_at (datetime):
            updated_at (datetime):
            region (bool, date, datetime, dict, float, int, list, str, none_type):
            stream (bool, date, datetime, dict, float, int, list, str, none_type):
            admins ([User]):
            has_hobo (bool):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            surveys ([Survey]): [optional]  # noqa: E501
            historical_monthly_mean ([HistoricalMonthlyMean]): [optional]  # noqa: E501
            site_application (SiteApplication): [optional]  # noqa: E501
            live_data ([SofarLiveDataDto]): [optional]  # noqa: E501
            collection_data (CollectionDataDto): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.name = name
        self.sensor_id = sensor_id
        self.polygon = polygon
        self.depth = depth
        self.max_monthly_mean = max_monthly_mean
        self.timezone = timezone
        self.status = status
        self.video_stream = video_stream
        self.display = display
        self.created_at = created_at
        self.updated_at = updated_at
        self.region = region
        self.stream = stream
        self.admins = admins
        self.has_hobo = has_hobo
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
