# aqualink-api
The Aqualink public API documentation

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import aqualink_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import aqualink_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import aqualink_sdk
from pprint import pprint
from aqualink_sdk.api import collections_api
from aqualink_sdk.model.collection import Collection
from aqualink_sdk.model.create_collection_dto import CreateCollectionDto
from aqualink_sdk.model.inline_response401 import InlineResponse401
from aqualink_sdk.model.inline_response404 import InlineResponse404
from aqualink_sdk.model.update_collection_dto import UpdateCollectionDto
# Defining the host is optional and defaults to https://ocean-systems.uc.r.appspot.com/api
# See configuration.py for a list of all supported configuration parameters.
configuration = aqualink_sdk.Configuration(
    host = "https://ocean-systems.uc.r.appspot.com/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearer
configuration = aqualink_sdk.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with aqualink_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = collections_api.CollectionsApi(api_client)
    create_collection_dto = CreateCollectionDto(
        name="La Niña heatwave 20/21",
        user_id=1,
        site_ids=[1,3,5],
        is_public=True,
    ) # CreateCollectionDto | 

    try:
        # Creates a new collection
        api_response = api_instance.collections_controller_create(create_collection_dto)
        pprint(api_response)
    except aqualink_sdk.ApiException as e:
        print("Exception when calling CollectionsApi->collections_controller_create: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://ocean-systems.uc.r.appspot.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CollectionsApi* | [**collections_controller_create**](docs/CollectionsApi.md#collections_controller_create) | **POST** /collections | Creates a new collection
*CollectionsApi* | [**collections_controller_delete**](docs/CollectionsApi.md#collections_controller_delete) | **DELETE** /collections/{collectionId} | Delete specified collection
*CollectionsApi* | [**collections_controller_find**](docs/CollectionsApi.md#collections_controller_find) | **GET** /collections | Fetch all user&#39;s private collections
*CollectionsApi* | [**collections_controller_find_one**](docs/CollectionsApi.md#collections_controller_find_one) | **GET** /collections/{collectionId} | Fetch detailed data from specified private collection
*CollectionsApi* | [**collections_controller_find_one_public**](docs/CollectionsApi.md#collections_controller_find_one_public) | **GET** /collections/public/{collectionId} | Fetch detailed data from specified public collection
*CollectionsApi* | [**collections_controller_find_public**](docs/CollectionsApi.md#collections_controller_find_public) | **GET** /collections/public | Fetch all public collections
*CollectionsApi* | [**collections_controller_get_heat_stress_tracker**](docs/CollectionsApi.md#collections_controller_get_heat_stress_tracker) | **GET** /collections/heat-stress-tracker | Fetch the heat stress tracker
*CollectionsApi* | [**collections_controller_update**](docs/CollectionsApi.md#collections_controller_update) | **PUT** /collections/{collectionId} | Update specified collection
*DataUploadsApi* | [**data_uploads_controller_delete_data_uploads**](docs/DataUploadsApi.md#data_uploads_controller_delete_data_uploads) | **POST** /data-uploads/delete-uploads | Delete selected data uploads
*DataUploadsApi* | [**data_uploads_controller_get_data_uploads**](docs/DataUploadsApi.md#data_uploads_controller_get_data_uploads) | **GET** /data-uploads/sites/{siteId} | Find all data uploads for a site&#39;s survey point
*GoogleCloudStorageApi* | [**google_cloud_controller_delete_dangling_files**](docs/GoogleCloudStorageApi.md#google_cloud_controller_delete_dangling_files) | **DELETE** /google-cloud/dangling | Deletes all unused files stored
*GoogleCloudStorageApi* | [**google_cloud_controller_find_dangling_files**](docs/GoogleCloudStorageApi.md#google_cloud_controller_find_dangling_files) | **GET** /google-cloud/dangling | Returns all files stored that are not used
*HealthCheckApi* | [**health_check_controller_health_check**](docs/HealthCheckApi.md#health_check_controller_health_check) | **GET** /health-check | Checks if the backend is up and running.
*RegionsApi* | [**regions_controller_create**](docs/RegionsApi.md#regions_controller_create) | **POST** /regions | Creates new region
*RegionsApi* | [**regions_controller_delete**](docs/RegionsApi.md#regions_controller_delete) | **DELETE** /regions/{id} | Deletes specified region
*RegionsApi* | [**regions_controller_find**](docs/RegionsApi.md#regions_controller_find) | **GET** /regions | Returns regions filtered by provided filters
*RegionsApi* | [**regions_controller_find_one**](docs/RegionsApi.md#regions_controller_find_one) | **GET** /regions/{id} | Returns specified region
*RegionsApi* | [**regions_controller_update**](docs/RegionsApi.md#regions_controller_update) | **PUT** /regions/{id} | Updates specified region
*SensorsApi* | [**sensors_controller_find_sensor_data**](docs/SensorsApi.md#sensors_controller_find_sensor_data) | **GET** /sensors/{id}/data | Get data from a specified sensor
*SensorsApi* | [**sensors_controller_find_sensor_surveys**](docs/SensorsApi.md#sensors_controller_find_sensor_surveys) | **GET** /sensors/{id}/surveys | Get surveys and survey media from a specified sensor
*SensorsApi* | [**sensors_controller_find_sensors**](docs/SensorsApi.md#sensors_controller_find_sensors) | **GET** /sensors | Get all sites having sensors
*SiteApplicationsApi* | [**site_applications_controller_find_one_from_site**](docs/SiteApplicationsApi.md#site_applications_controller_find_one_from_site) | **GET** /site-applications/sites/{siteId} | Returns site application of specified site
*SiteApplicationsApi* | [**site_applications_controller_update**](docs/SiteApplicationsApi.md#site_applications_controller_update) | **PUT** /site-applications/{appId}/sites/{siteId} | Updates site application by providing its appId. Needs authentication.
*SitePointsOfInterestApi* | [**site_survey_points_controller_create**](docs/SitePointsOfInterestApi.md#site_survey_points_controller_create) | **POST** /site-survey-points | Creates a new site point of interest
*SitePointsOfInterestApi* | [**site_survey_points_controller_delete**](docs/SitePointsOfInterestApi.md#site_survey_points_controller_delete) | **DELETE** /site-survey-points/{id} | Deletes specified site point of interest
*SitePointsOfInterestApi* | [**site_survey_points_controller_find**](docs/SitePointsOfInterestApi.md#site_survey_points_controller_find) | **GET** /site-survey-points | Returns site points of interest filtered by the provided filters
*SitePointsOfInterestApi* | [**site_survey_points_controller_find_one**](docs/SitePointsOfInterestApi.md#site_survey_points_controller_find_one) | **GET** /site-survey-points/{id} | Returns specified site point of interest
*SitePointsOfInterestApi* | [**site_survey_points_controller_update**](docs/SitePointsOfInterestApi.md#site_survey_points_controller_update) | **PUT** /site-survey-points/{id} | Updates specified site point of interest
*SitesApi* | [**sites_controller_add_exclusion_dates**](docs/SitesApi.md#sites_controller_add_exclusion_dates) | **POST** /sites/{siteId}/exclusion_dates | Adds exclusion dates to spotter&#39;s data
*SitesApi* | [**sites_controller_create**](docs/SitesApi.md#sites_controller_create) | **POST** /sites | Creates a new site and its site application
*SitesApi* | [**sites_controller_delete**](docs/SitesApi.md#sites_controller_delete) | **DELETE** /sites/{siteId} | Deletes specified site
*SitesApi* | [**sites_controller_deploy_spotter**](docs/SitesApi.md#sites_controller_deploy_spotter) | **POST** /sites/{siteId}/deploy | Deploys site&#39;s spotter
*SitesApi* | [**sites_controller_find**](docs/SitesApi.md#sites_controller_find) | **GET** /sites | Returns sites filtered by provided filters
*SitesApi* | [**sites_controller_find_daily_data**](docs/SitesApi.md#sites_controller_find_daily_data) | **GET** /sites/{id}/daily_data | Returns daily data of the specified site
*SitesApi* | [**sites_controller_find_exclusion_dates**](docs/SitesApi.md#sites_controller_find_exclusion_dates) | **GET** /sites/{siteId}/exclusion_dates | Returns exclusion dates of specified site&#39;s spotter
*SitesApi* | [**sites_controller_find_live_data**](docs/SitesApi.md#sites_controller_find_live_data) | **GET** /sites/{id}/live_data | Returns live data of the specified site
*SitesApi* | [**sites_controller_find_one**](docs/SitesApi.md#sites_controller_find_one) | **GET** /sites/{id} | Returns specified site
*SitesApi* | [**sites_controller_get_spotter_data**](docs/SitesApi.md#sites_controller_get_spotter_data) | **GET** /sites/{id}/spotter_data | Returns spotter data of the specified site
*SitesApi* | [**sites_controller_update**](docs/SitesApi.md#sites_controller_update) | **PUT** /sites/{siteId} | Updates specified site
*SurveysApi* | [**surveys_controller_create**](docs/SurveysApi.md#surveys_controller_create) | **POST** /sites/{siteId}/surveys | Creates a new survey
*SurveysApi* | [**surveys_controller_create_media**](docs/SurveysApi.md#surveys_controller_create_media) | **POST** /sites/{siteId}/surveys/{id}/media | Creates a new survey media
*SurveysApi* | [**surveys_controller_delete**](docs/SurveysApi.md#surveys_controller_delete) | **DELETE** /sites/{siteId}/surveys/{id} | Deletes a specified survey
*SurveysApi* | [**surveys_controller_delete_media**](docs/SurveysApi.md#surveys_controller_delete_media) | **DELETE** /sites/{siteId}/surveys/media/{id} | Deletes a specified survey media
*SurveysApi* | [**surveys_controller_find**](docs/SurveysApi.md#surveys_controller_find) | **GET** /sites/{siteId}/surveys | Returns all site&#39;s survey
*SurveysApi* | [**surveys_controller_find_media**](docs/SurveysApi.md#surveys_controller_find_media) | **GET** /sites/{siteId}/surveys/{id}/media | Returns all media of a specified survey
*SurveysApi* | [**surveys_controller_find_one**](docs/SurveysApi.md#surveys_controller_find_one) | **GET** /sites/{siteId}/surveys/{id} | Returns specified survey
*SurveysApi* | [**surveys_controller_update**](docs/SurveysApi.md#surveys_controller_update) | **PUT** /sites/{siteId}/surveys/{id} | Updates a specified survey
*SurveysApi* | [**surveys_controller_update_media**](docs/SurveysApi.md#surveys_controller_update_media) | **PUT** /sites/{siteId}/surveys/media/{id} | Updates a specified survey media
*SurveysApi* | [**surveys_controller_upload**](docs/SurveysApi.md#surveys_controller_upload) | **POST** /sites/{siteId}/surveys/upload | Uploads a new survey media
*TimeSeriesApi* | [**time_series_controller_find_site_data**](docs/TimeSeriesApi.md#time_series_controller_find_site_data) | **GET** /time-series/sites/{siteId} | Returns specified time series data for a specified site
*TimeSeriesApi* | [**time_series_controller_find_site_data_range**](docs/TimeSeriesApi.md#time_series_controller_find_site_data_range) | **GET** /time-series/sites/{siteId}/range | Returns the range of the available time series data for a specified site
*TimeSeriesApi* | [**time_series_controller_find_survey_point_data**](docs/TimeSeriesApi.md#time_series_controller_find_survey_point_data) | **GET** /time-series/sites/{siteId}/site-survey-points/{surveyPointId} | Returns specified time series data for a specified site point of interest
*TimeSeriesApi* | [**time_series_controller_find_survey_point_data_range**](docs/TimeSeriesApi.md#time_series_controller_find_survey_point_data_range) | **GET** /time-series/sites/{siteId}/site-survey-points/{surveyPointId}/range | Returns the range of the available time series data for a specified site point of interest
*TimeSeriesApi* | [**time_series_controller_upload_time_series_data**](docs/TimeSeriesApi.md#time_series_controller_upload_time_series_data) | **POST** /time-series/sites/{siteId}/site-survey-points/{surveyPointId}/upload | Upload time series data
*UsersApi* | [**users_controller_create**](docs/UsersApi.md#users_controller_create) | **POST** /users | Creates a new user
*UsersApi* | [**users_controller_delete**](docs/UsersApi.md#users_controller_delete) | **DELETE** /users/{id} | Deletes specified user
*UsersApi* | [**users_controller_get_administered_sites**](docs/UsersApi.md#users_controller_get_administered_sites) | **GET** /users/current/administered-sites | Returns the administered sites of the signed in user
*UsersApi* | [**users_controller_get_self**](docs/UsersApi.md#users_controller_get_self) | **GET** /users/current | Returns the currently signed in user
*UsersApi* | [**users_controller_set_admin_level**](docs/UsersApi.md#users_controller_set_admin_level) | **PUT** /users/{id}/level | Updates the access level of a user


## Documentation For Models

 - [Collection](docs/Collection.md)
 - [CollectionDataDto](docs/CollectionDataDto.md)
 - [Coordinates](docs/Coordinates.md)
 - [CreateCollectionDto](docs/CreateCollectionDto.md)
 - [CreateRegionDto](docs/CreateRegionDto.md)
 - [CreateRegionDtoPolygon](docs/CreateRegionDtoPolygon.md)
 - [CreateSiteApplicationDto](docs/CreateSiteApplicationDto.md)
 - [CreateSiteDto](docs/CreateSiteDto.md)
 - [CreateSiteSurveyPointDto](docs/CreateSiteSurveyPointDto.md)
 - [CreateSurveyDto](docs/CreateSurveyDto.md)
 - [CreateSurveyMediaDto](docs/CreateSurveyMediaDto.md)
 - [CreateUserDto](docs/CreateUserDto.md)
 - [DailyData](docs/DailyData.md)
 - [DataUploads](docs/DataUploads.md)
 - [DataUploadsDeleteDto](docs/DataUploadsDeleteDto.md)
 - [DeploySpotterDto](docs/DeploySpotterDto.md)
 - [EditSurveyDto](docs/EditSurveyDto.md)
 - [EditSurveyMediaDto](docs/EditSurveyMediaDto.md)
 - [ExcludeSpotterDatesDto](docs/ExcludeSpotterDatesDto.md)
 - [ExclusionDates](docs/ExclusionDates.md)
 - [HistoricalMonthlyMean](docs/HistoricalMonthlyMean.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2001Metlog](docs/InlineResponse2001Metlog.md)
 - [InlineResponse2001MetlogWindGustSpeed](docs/InlineResponse2001MetlogWindGustSpeed.md)
 - [InlineResponse200Metlog](docs/InlineResponse200Metlog.md)
 - [InlineResponse200MetlogWindGustSpeed](docs/InlineResponse200MetlogWindGustSpeed.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [LatestData](docs/LatestData.md)
 - [Region](docs/Region.md)
 - [SetAdminLevelDto](docs/SetAdminLevelDto.md)
 - [Site](docs/Site.md)
 - [SiteApplication](docs/SiteApplication.md)
 - [SiteSurveyPoint](docs/SiteSurveyPoint.md)
 - [SofarLiveDataDto](docs/SofarLiveDataDto.md)
 - [SofarLiveDataDtoSite](docs/SofarLiveDataDtoSite.md)
 - [SofarLiveDataDtoSpotterPosition](docs/SofarLiveDataDtoSpotterPosition.md)
 - [SpotterDataDto](docs/SpotterDataDto.md)
 - [Survey](docs/Survey.md)
 - [SurveyMedia](docs/SurveyMedia.md)
 - [SurveyMediaSensorData](docs/SurveyMediaSensorData.md)
 - [SurveyMediaSensorDataHobo](docs/SurveyMediaSensorDataHobo.md)
 - [SurveyMediaSensorDataNoaa](docs/SurveyMediaSensorDataNoaa.md)
 - [SurveyMediaSensorDataSpotter](docs/SurveyMediaSensorDataSpotter.md)
 - [TimeSeriesPoint](docs/TimeSeriesPoint.md)
 - [TimeSeriesValueDto](docs/TimeSeriesValueDto.md)
 - [UpdateCollectionDto](docs/UpdateCollectionDto.md)
 - [UpdateRegionDto](docs/UpdateRegionDto.md)
 - [UpdateSiteApplicationDto](docs/UpdateSiteApplicationDto.md)
 - [UpdateSiteDto](docs/UpdateSiteDto.md)
 - [UpdateSiteSurveyPointDto](docs/UpdateSiteSurveyPointDto.md)
 - [UpdateSiteWithApplicationDto](docs/UpdateSiteWithApplicationDto.md)
 - [User](docs/User.md)
 - [UserLocation](docs/UserLocation.md)
 - [VideoStream](docs/VideoStream.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in aqualink_sdk.apis and aqualink_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from aqualink_sdk.api.default_api import DefaultApi`
- `from aqualink_sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import aqualink_sdk
from aqualink_sdk.apis import *
from aqualink_sdk.models import *
```

