# ducpy (Python)

<p align="center">
  <br/>
  <a href="https://duc.ducflair.com" target="_blank"><img width="256px" src="https://raw.githubusercontent.com/ducflair/assets/refs/heads/main/src/duc/duc-extended.png" /></a>
  <p align="center">2D CAD File Format</p>
  <p align="center" style="align: center;">
    <a href="https://pypi.org/project/ducpy/"><img src="https://shields.io/badge/Pip-blue?logo=Pypi&logoColor=white&style=round-square" alt="Pip" /></a>
    <a href="https://github.com/ducflair/duc/releases"><img src="https://img.shields.io/pypi/v/ducpy?style=round-square&label=latest%20stable" alt="PyPI ducpy@latest release" /></a>
    <a href="https://pypi.org/project/ducpy/"><img src="https://img.shields.io/pypi/dm/ducpy?style=round-square&color=salmon" alt="Downloads" /></a>
    <img src="https://shields.io/badge/Python-ffde57?logo=Python&logoColor=646464&style=round-square" alt="Python" />
  </p>
</p>


The `ducpy` package provides a robust Python implementation for the `duc` 2D CAD file format, a cornerstone of our advanced design system. Designed for professionals seeking precision and efficiency, this package ensures seamless integration and manipulation of `duc` files within your Python projects.

## Introduction

The `ducpy` package offers comprehensive Python types and helper functions to work effortlessly with the `duc` CAD file format. Built with efficiency and performance in mind, this package enables you to parse, validate, and manipulate `duc` files with ease.

## Features

- **Python Support:** Strongly-typed interfaces for all aspects of the `duc` file format, ensuring type safety and IDE support.
- **Utility Functions:** Easy-to-use functions for parsing, validating, and manipulating `duc` files.
- **Extensible Architecture:** Designed to integrate seamlessly with other `ducflair` packages and your custom tools.
- **Performance Optimized:** Efficient processing to handle complex CAD data with ease.

## Installation

Install the package using pip:

```bash
pip install ducpy
```

## Usage

```python
from ducpy import Duc # imports the raw `duc` class
```

## Documentation

For detailed documentation, including all available types and utility functions, visit our [Documentation](https://duc.ducflair.com).

## Tools

- [Playground](https://ducflair.com/core): Experiment with the `duc` format in a live environment.
- [Documentation](https://duc.ducflair.com): Comprehensive guides and API references.

## Contributing

At the moment we are not accepting contributions to this package. However, we welcome feedback and suggestions for future improvements. Feel free to open an issue or contact us at [Ducflair Support](https://www.ducflair.com/support).

## License

This project is licensed under the MIT License. See the [LICENSE](./LICENSE) file for more details.

## Commit Message Guidelines

To ensure smooth releases with semantic-release, please follow [these guidelines](https://semantic-release.gitbook.io/semantic-release#how-does-it-work).

---

*The duc format and libraries are constantly evolving, aiming to set new standards in the 2D CAD industry. Be a part of this transformation and help shape the future of design technology!*