import * as lambda from '@aws-cdk/aws-lambda';
import { BundlingOptions } from './types';
import { Construct } from '@aws-cdk/core';
/**
 * Properties for PythonLayerVersion
 */
export interface PythonLayerVersionProps extends lambda.LayerVersionOptions {
    /**
     * The path to the root directory of the lambda layer.
     */
    readonly entry: string;
    /**
     * The runtimes compatible with the python layer.
     *
     * @default - Only Python 3.7 is supported.
     */
    readonly compatibleRuntimes?: lambda.Runtime[];
    /**
     * The system architectures compatible with this layer.
     * @default [Architecture.X86_64]
     */
    readonly compatibleArchitectures?: lambda.Architecture[];
    /**
     * Bundling options to use for this function. Use this to specify custom bundling options like
     * the bundling Docker image, asset hash type, custom hash, architecture, etc.
     *
     * @default - Use the default bundling Docker image, with x86_64 architecture.
     */
    readonly bundling?: BundlingOptions;
}
/**
 * A lambda layer version.
 *
 */
export declare class PythonLayerVersion extends lambda.LayerVersion {
    constructor(scope: Construct, id: string, props: PythonLayerVersionProps);
}
