# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['toml_sort']

package_data = \
{'': ['*']}

install_requires = \
['tomlkit>=0.11.2']

entry_points = \
{'console_scripts': ['toml-sort = toml_sort.cli:cli']}

setup_kwargs = {
    'name': 'toml-sort',
    'version': '0.22.4',
    'description': 'Toml sorting library',
    'long_description': '# toml-sort\n\n[![pypi-version](https://img.shields.io/pypi/v/toml-sort.svg)](https://python.org/pypi/toml-sort)\n[![license](https://img.shields.io/pypi/l/toml-sort.svg)](https://python.org/pypi/toml-sort)\n[![image-python-versions](https://img.shields.io/badge/python->=3.7-blue)](https://python.org/pypi/jedi-language-server)\n[![image-pypi-downloads](https://pepy.tech/badge/toml-sort)](https://pepy.tech/project/toml-sort)\n[![readthedocs-status](https://readthedocs.org/projects/toml-sort/badge/?version=latest)](https://toml-sort.readthedocs.io/en/latest/?badge=latest)\n\nA command line utility to sort and format your toml files.\n\nRead the latest documentation here: <https://toml-sort.readthedocs.io/en/latest/>\n\n## Installation\n\n```bash\npip install toml-sort\n```\n\n## Motivation\n\nThis library sorts TOML files, providing the following features:\n\n- Sort tables and Arrays of Tables (AoT)\n- Option to sort non-tables / non-AoT\'s, or not\n- Preserve comments, where possible\n- Standardize whitespace and indentation\n\nI wrote this library/application because I couldn\'t find any "good" sorting utilities for TOML files. Now, I use this as part of my daily workflow. Hopefully it helps you too!\n\n## Command line usage\n\nThis project can be used as either a command line utility or a Python library. Read the docs for an overview of its library capabilities. For command line usage, see below:\n\n```console\n$ toml-sort --help\nusage: toml-sort [-h] [--version] [-o OUTPUT] [-i] [-I] [-a] [--no-sort-tables] [--sort-table-keys]\n                 [--sort-inline-tables] [--sort-inline-arrays] [--no-header] [--no-comments] [--no-header-comments]\n                 [--no-footer-comments] [--no-inline-comments] [--no-block-comments]\n                 [--spaces-before-inline-comment {1,2,3,4}] [--spaces-indent-inline-array {2,4,6,8}]\n                 [--trailing-comma-inline-array] [--check]\n                 [F [F ...]]\n\nToml sort: a sorting utility for toml files.\n\npositional arguments:\n  F                     filename(s) to be processed by toml-sort (default: -)\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --version             display version information and exit\n  -o OUTPUT, --output OUTPUT\n                        output filepath (default: \'-\')\n  -i, --in-place        overwrite the original input file with changes\n  --check               silently check if an original file would be changed by the formatter\n\nsort:\n  change sorting behavior\n\n  -I, --ignore-case     ignore case when sorting\n  -a, --all             sort ALL keys. This implies sort table-keys, inline-tables and inline arrays. (default: only\n                        sort non-inline \'tables and arrays of tables\')\n  --no-sort-tables      Disables the default behavior of sorting tables and arrays of tables by their header value.\n                        Setting this option will keep the order of tables in the toml file the same.\n  --sort-table-keys     Sort the keys in tables and arrays of tables (excluding inline tables and arrays).\n  --sort-inline-tables  Sort inline tables.\n  --sort-inline-arrays  Sort inline arrays.\n\ncomments:\n  exclude comments from output\n\n  --no-header           Deprecated. See --no-header-comments\n  --no-comments         remove all comments. Implies no header, footer, inline, or block comments\n  --no-header-comments  remove a document\'s leading comments\n  --no-footer-comments  remove a document\'s trailing comments\n  --no-inline-comments  remove a document\'s inline comments\n  --no-block-comments   remove a document\'s block comments\n\nformatting:\n  options to change output formatting\n\n  --spaces-before-inline-comment {1,2,3,4}\n                        the number of spaces before an inline comment (default: 1)\n  --spaces-indent-inline-array {2,4,6,8}\n                        the number of spaces to indent a multiline inline array (default: 2)\n  --trailing-comma-inline-array\n                        add trailing comma to the last item in a multiline inline array\n\nExamples:\n\n  - **Stdin -> Stdout**: cat input.toml | toml-sort\n  - **Disk -> Disk**: toml-sort -o output.toml input.toml\n  - **Linting**: toml-sort --check input.toml input2.toml input3.toml\n  - **Inplace Disk**: toml-sort --in-place input.toml input2.toml\n\nReturn codes:\n\n  - 0 : success.\n  - 1 : errors were found\n\nNotes:\n\n  - You cannot redirect from a file to itself in Bash. POSIX shells process\n    redirections first, then execute commands. --in-place exists for this\n    reason\n```\n\n## Configuration file\n\ntoml-sort can also be configured by using the `pyproject.toml` file. If the file exists and has a `tool.tomlsort` section, the configuration is used. If both command line arguments and the configuration are used, the options are merged. In the case of conflicts, the command line option is used.\n\nIn short, the names are the same as on the command line (and have the same meaning), but `-` is replaced with `_`. Please note, that only the below options are supported:\n\n```toml\n[tool.tomlsort]\nall = true\nin_place = true\nno_comments = true\nno_header_comments = true\nno_footer_comments = true\nno_inline_comments = true\nno_block_comments = true\nno_sort_tables = true\nsort_table_keys = true\nsort_inline_tables = true\nsort_inline_arrays = true\nspaces_before_inline_comment = 2\nspaces_indent_inline_array = 4\ntrailing_comma_inline_array = true\ncheck = true\nignore_case = true\n```\n\n## Comments\n\nDue to the free form nature of comments, it is hard to include them in a sort in a generic way that will work for everyone. `toml-sort` deals with four different types of comments. They are all enabled by default, but can be disabled using CLI switches, in which case comments of that type will be removed from the output.\n\n### Header\n\nThe first comments in a document, that are followed by a blank line, are treated as a header, and will always remain at the top of the document. If there is no blank line, the comment will be treated as a block comment instead.\n\n```toml\n# This is a header\n# it can be multiple lines, as long as it is followed with a blank line\n# it will always stay at the top of the sorted document\n\ntitle = "The example"\n```\n\n### Footer\n\nAny comments at the end of the document, after the last item in the toml, will be treated as a footer, and will always remain at the bottom of the document.\n\n```toml\ntitle = "The example"\n\n# this is a footer comment\n```\n\n### Inline\n\nInline comments are comments that are at the end of a line where the start of the line is a toml item.\n\n```toml\ntitle = "The example" # This is a inline comment\n```\n\n### Block\n\nBlock comments, are any comments that are on their own line. These comments are treated as _attached_ to the item in the toml that is directly below them, not separated by whitespace. These comments can be multiple lines. Inline comments will appear in the sorted output above the item they were attached to in the input toml.\n\n```toml\n# Comment attached to title\ntitle = "The example"\n\n# This comment is an orphan because it\n# is separated from a-section by whitespace\n\n# This comment is attached to a-section\n# attached comments can be multiple lines\n[a-section]\n# This comment is attached to date\ndate = "2019"\n```\n\n### Orphan\n\nOrphan comments are any comments that don\'t fall into the above categories, they will be removed from the output document.\n\n```toml\n# Header comment\n\n# Orphan comment, not attached to any item\n# because there is whitespace before title\n\ntitle = "The example"\n\n# This comment is an orphan because it\n# is separated from a-section by whitespace\n\n# This comment is attached to a-section\n[a-section]\n```\n\n## Example\n\nThe following example shows the input, and output, from the CLI with default options.\n\n### Unformatted, unsorted input\n\n```toml\n# My great TOML example\n\n  title = "The example"\n\n[[a-section.hello]]\nports = [ 8001, 8001, 8002 ]\ndob = 1979-05-27T07:32:00Z # First class dates? Why not?\n\n\n     # Attached to b-section\n  [b-section]\n  date = "2018"\n  name = "Richard Stallman"\n\n[[a-section.hello]]\nports = [ 80 ]\n    #Attached to dob\ndob = 1920-05-27T07:32:00Z # Another date!\n\n                          [a-section]\n                          date = "2019"\n                          name = "Samuel Roeca"\n```\n\n### Formatted, sorted output\n\n```toml\n# My great TOML example\n\ntitle = "The example"\n\n[a-section]\ndate = "2019"\nname = "Samuel Roeca"\n\n[[a-section.hello]]\nports = [ 8001, 8001, 8002 ]\ndob = 1979-05-27T07:32:00Z # First class dates? Why not?\n\n[[a-section.hello]]\nports = [ 80 ]\n# Attached to dob\ndob = 1920-05-27T07:32:00Z # Another date!\n\n# Attached to b-section\n[b-section]\ndate = "2018"\nname = "Richard Stallman"\n```\n\n## Local Development\n\nLocal development for this project is quite simple.\n\n**Dependencies**\n\nInstall the following tools manually.\n\n- [Poetry>=1.0](https://github.com/sdispater/poetry#installation)\n- [GNU Make](https://www.gnu.org/software/make/)\n\n_Recommended_\n\n- [asdf](https://github.com/asdf-vm/asdf)\n\n**Set up development environment**\n\n```bash\nmake setup\n```\n\n**Run Tests**\n\n```bash\nmake test\n```\n\n## Written by\n\nSamuel Roeca, *samuel.roeca@gmail.com*\n',
    'author': 'Sam Roeca',
    'author_email': 'samuel.roeca@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://toml-sort.readthedocs.io/en/latest/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
