## Description

A pattern for creating a custom date picker or polyfill.

## Documentation

This pattern provides a styleable date picker. It can be used as a fallback
for browsers which don't yet support the HTML5 date input.

### Examples

####Falling back to the browser's HTML5 picker if available.

Set the `behavior` option to `native` to use the browser's HTML5 date input
rendering when available.

    <input class="pat-date-picker" type="date" data-pat-date-picker="behavior: native">

####Enforcing the styled non-HTML5 picker universally.

By default this pattern will NOT defer to the browser's HTML5 picker.

    <input class="pat-date-picker" type="date">

####Default value

    <input class="pat-date-picker" type="date" value="2015-01-01">

####Specifying the "min" and "max" attributes.

    <input class="pat-date-picker" min="2015-01-01" max="2015-12-31" type="date">

####Show the week number.

    <input class="pat-date-picker" data-pat-date-picker="week-numbers: show;" type="date">

####Multilingual support with German translations

The picker's UI can be translated by providing a URL to the `i18n` option. This
URL must point to a JSON encoded resource containing the translations.

    <input class="pat-date-picker" data-pat-date-picker="i18n: /src/pat/date-picker/i18n.json;" type="date">

Here are all the i18n values in JSON format:

     {
       "previousMonth": "Previous Month",
       "nextMonth": "Next Month",
       "months": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
       "weekdays": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
       "weekdaysShort": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
     }


### Why did we base this library on Pikaday?

When looking for the underlying library to use for this pattern, we compared
pikaday and [pickadate](https://dbushell.github.io/Pikaday/).

* Prefixed CSS classes

Pikaday's CSS classes are prefixed to make them unique, whereas Pickadate's
classes are very generic and therefore prone to clash with existing classes and CSS in certain sites.

* Better markup

One of the main drawbacks of pickadate is the markup that it produces.
Pickaday's special markup is inserted relative to the input element being overridden.

In contrast, the markup generated by pikaday is appended to the end of the
`<body>` tag, and it then uses absolute positioning to position the picker.

This is easier to style and less prone to create problems when integrating the
picker in diverse styling environments.

* Simpler, more modest featureset and Javascript

Pikaday is only 5KB compressed. The code is AMD aware and easy to read and
understand.


### Option reference

The HTML5 attributes `min` and `max` will be honoured.

In addition, the following options can be passed to `data-pat-date-picker`:

|Property                    | Type    | Default Value | Available values  | Description                                                   |
|----------------------------|---------|---------------|-------------------|---------------------------------------------------------------|
|**behavior** (or behaviour) | string  | styled        | native, styled    | "native" to defer to the browser's HTML5 date support, or "styled" to universally use the custom picker. |
|**week-numbers**            | string  | hide          | show, hide        | "show" will show the weeks' numbers in a leftmost column.     |
|**i18n**                    | URL     |               |                   | Provide a URL to a JSON resource which gives the i18n values. |
|**first-day**               | Integer | 0             |                   | Set the first day of the week (0 -> Sunday, 1-> Monday, ...). |
