# -*- coding: utf-8 -*-

"""
firstapicalculator

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from firstapicalculator.api_helper import APIHelper


class SimpleCalculatorControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(SimpleCalculatorControllerTests, cls).setUpClass()
        cls.controller = cls.client.simple_calculator
        cls.response_catcher = cls.controller.http_call_back

    # Test the addition of values
    def test_sum(self):
        # Parameters for the API call
        operation = 'SUM'
        x = 10
        y = 3

        # Perform the API call through the SDK function
        result = self.controller.calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('13', self.response_catcher.response.text)

    # Multiplication of two operands
    def test_multiply(self):
        # Parameters for the API call
        operation = 'MULTIPLY'
        x = 5
        y = 6

        # Perform the API call through the SDK function
        result = self.controller.calculate(operation, x, y)

        # Test response code
        self.assertTrue(self.response_catcher.response.status_code in list(range(200, 209)))
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('30', self.response_catcher.response.text)

    # Subtraction of two operands
    def test_subtract(self):
        # Parameters for the API call
        operation = 'SUBTRACT'
        x = 9
        y = 5

        # Perform the API call through the SDK function
        result = self.controller.calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('4', self.response_catcher.response.text)

    # Division of two operands
    def test_division(self):
        # Parameters for the API call
        operation = 'DIVIDE'
        x = 25
        y = 5

        # Perform the API call through the SDK function
        result = self.controller.calculate(operation, x, y)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('5', self.response_catcher.response.text)

