/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.math.R.Log;
import org.math.R.RserveDaemon;
import org.math.R.RserverConf;
import org.math.R.Rsession;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class StartRserve {
    public static long TIMEOUT = Long.parseLong(System.getProperty("system.timeout", "60"));
    static String UGLY_FIXES = "";
    static volatile boolean locking = false;

    public static boolean isRserveInstalled() throws IOException {
        File dir = new File(RserveDaemon.app_dir(), "Rserve");
        if (dir.isDirectory()) {
            File desc = new File(dir, "DESCRIPTION");
            if (desc.isFile() && FileUtils.readFileToString((File)desc).contains("1.7-5") | FileUtils.readFileToString((File)desc).contains("1.8")) {
                return true;
            }
            Log.Err.println("Seems Rserve is not _well_ installed: " + (desc.isFile() ? FileUtils.readFileToString((File)desc) : "No DESCRIPTION") + " Force remove!");
            if (RserveDaemon.isWindows()) {
                StartRserve.KillAll("Rserve.exe");
                StartRserve.KillAll("Rserve_d.exe");
            }
            int n = 10;
            while (n-- > 0 && dir.isDirectory()) {
                FileUtils.forceDelete((File)dir);
            }
            if (dir.isDirectory()) {
                throw new IOException("Could not cleanup " + dir.getAbsolutePath() + " directory");
            }
            return false;
        }
        Log.Err.println("No Rserve directory in " + RserveDaemon.app_dir().getAbsolutePath());
        return false;
    }

    public static boolean installRserveFromLocalLibrary(String Rcmd) throws InterruptedException, IOException {
        block10: {
            if (StartRserve.isRserveInstalled()) {
                Log.Out.println("Rserve already available. (skip installRserveFromLocalLibrary)");
                return true;
            }
            Log.Out.println("Install/copy Rserve from local library");
            try {
                String result = StartRserve.doInR("which_Rserve = which(gregexpr('/Rserve$',list.files(.libPaths(),full.names=T))>0); if (length(which_Rserve)>0) print(readLines(file.path(list.files(.libPaths(),full.names=T)[which_Rserve],'DESCRIPTION'))[2]) else print(paste('No','Rserve'))", Rcmd, "--vanilla --silent", null);
                if (result.contains("No Rserve")) {
                    Log.Out.println("Rserve not available in standard lib.loc");
                    return false;
                }
                String version = result.replaceAll(">.*", "").trim();
                if (version.contains("1.7-5") || version.contains("1.7.5") || version.contains("1.8")) {
                    Log.Out.println("Rserve version suitable: " + version + ". Trying to copy in lib.loc=" + RserveDaemon.app_dir());
                    String print_path = StartRserve.doInR("which_Rserve = which(gregexpr('/Rserve$',list.files(.libPaths(),full.names=T))>0); print(file.path(list.files(.libPaths(),full.names=T)[which_Rserve]))", Rcmd, "--vanilla --silent", null);
                    Pattern regex = Pattern.compile("^(.*)/Rserve\"", 8);
                    Matcher regexMatcher = regex.matcher(print_path);
                    if (!regexMatcher.find()) {
                        Log.Err.println("Could not find pattern " + regex + " in " + print_path.replaceAll("\n", "\n  | "));
                        return false;
                    }
                    String match = RserveDaemon.isWindows() ? (regexMatcher.group(1) + "/Rserve").replaceAll("/", "\\\\") : regexMatcher.group(1) + "/Rserve";
                    File path = new File(match.substring(5));
                    FileUtils.copyDirectoryToDirectory((File)path, (File)RserveDaemon.app_dir());
                    for (File Rserve_exe : FileUtils.listFiles((File)RserveDaemon.app_dir(), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"Rserve"), (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
                        if (Rserve_exe.setExecutable(true)) continue;
                        Log.Err.println("Could not set executable: " + Rserve_exe);
                        return false;
                    }
                    for (File Rserve_exe : FileUtils.listFiles((File)RserveDaemon.app_dir(), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"Rserve.dbg"), (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
                        if (Rserve_exe.setExecutable(true)) continue;
                        Log.Err.println("Could not set executable: " + Rserve_exe);
                        return false;
                    }
                    for (File Rserve_exe : FileUtils.listFiles((File)RserveDaemon.app_dir(), (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"Rserve_d"), (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
                        if (Rserve_exe.setExecutable(true)) continue;
                        Log.Err.println("Could not set executable: " + Rserve_exe);
                        return false;
                    }
                    break block10;
                }
                Log.Out.println("Rserve library version not suitable: " + version);
                return false;
            }
            catch (Exception e) {
                Log.Err.println("Failed to check Rserve in standard lib.loc:" + e.getMessage());
                return false;
            }
        }
        if (StartRserve.isRserveInstalled()) {
            Log.Out.println(" well installed.");
            return true;
        }
        Log.Out.println(" not well installed !");
        return false;
    }

    public static boolean installRserve(String Rcmd, String http_proxy, String repository) throws IOException {
        if (StartRserve.isRserveInstalled()) {
            Log.Out.println("Rserve already available. (skip installRserve)");
            return true;
        }
        if (repository == null || repository.length() == 0) {
            repository = Rsession.DEFAULT_REPOS;
        }
        if (http_proxy == null) {
            http_proxy = "";
        }
        Log.Out.println("Install Rserve from " + repository + " (http_proxy='" + http_proxy + "') ");
        try {
            String result = StartRserve.doInR((http_proxy != null ? "Sys.setenv(http_proxy='" + http_proxy + "');" : "") + "install.packages('Rserve',repos='" + repository + "',lib='" + RserveDaemon.app_dir() + "')", Rcmd, "--vanilla --silent", null);
            String installed = StartRserve.doInR("'Rserve' %in% installed.packages(lib.loc='" + RserveDaemon.app_dir() + "')", Rcmd, "--vanilla --silent", null);
            if (result.contains("MD5") && result.contains("'Rserve'") || result.contains("* DONE (Rserve)") || installed.contains("TRUE")) {
                Log.Out.println("  OK: \n  |" + result.replaceAll("\n", "\n  | ") + "  ---\n" + installed.replaceAll("\n", "\n  | "));
            } else if (result.contains("FAILED") || result.contains("Error") || installed.contains("FALSE")) {
                Log.Out.println("  FAILED: \n  |" + result.replaceAll("\n", "\n  | ") + "  ---\n" + installed.replaceAll("\n", "\n  | "));
            } else {
                Log.Out.println("  UNKNOWN: \n  |" + result.replaceAll("\n", "\n  | ") + "  ---\n" + installed.replaceAll("\n", "\n  | "));
            }
        }
        catch (IOException ioe) {
            Log.Err.print("Rserve NOT well installed: " + ioe.getMessage());
            return false;
        }
        if (StartRserve.isRserveInstalled()) {
            Log.Out.println(" well installed.");
            return true;
        }
        Log.Out.println(" not well installed !");
        return false;
    }

    public static boolean installBundledRserve(String Rcmd) throws InterruptedException, IOException {
        File packFile;
        if (StartRserve.isRserveInstalled()) {
            Log.Out.println("Rserve already available. (skip installBundledRserve)");
            return true;
        }
        Log.Out.println("Install Rserve from Rsession bundle");
        String R_version_path = ".";
        String Rserve_version = "";
        String outv_str = "?";
        try {
            outv_str = StartRserve.doInR("cat(paste0(R.version[['major']],'.',floor(as.numeric(R.version[['minor']]))))", Rcmd, "--silent", null).replaceAll(">.*", "").trim();
            if (outv_str.startsWith("3.6")) {
                R_version_path = "R-3.6";
                Rserve_version = "1.7-5";
            } else if (outv_str.startsWith("4.1")) {
                R_version_path = "R-4.1";
                Rserve_version = "1.8-10";
            } else if (outv_str.startsWith("4.2")) {
                R_version_path = "R-4.2";
                Rserve_version = "1.8-10";
            } else {
                Log.Err.println("R version ('" + outv_str + "') not supported.\n  Will try to use source install." + (RserveDaemon.isWindows() ? " (assuming Rtools is available)" : ""));
            }
        }
        catch (Exception ex) {
            Log.Err.println(ex.getMessage() + ": \n" + outv_str);
            return false;
        }
        String pack_suffix = ".tar.gz";
        if (!R_version_path.equals(".")) {
            if (RserveDaemon.isWindows()) {
                pack_suffix = ".zip";
            } else if (RserveDaemon.isMacOSX()) {
                pack_suffix = ".tgz";
            } else {
                R_version_path = ".";
            }
        }
        try {
            packFile = File.createTempFile("Rserve_" + Rserve_version, pack_suffix);
            packFile.deleteOnExit();
        }
        catch (IOException ex) {
            Log.Err.println(ex.getMessage());
            return false;
        }
        try {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream fileStream = classloader.getResourceAsStream("org/math/R/" + R_version_path + "/Rserve_" + Rserve_version + pack_suffix);
            if (fileStream == null) {
                throw new IOException("Cannot find resource org/math/R/" + R_version_path + "/Rserve_" + Rserve_version + pack_suffix);
            }
            FileOutputStream out = new FileOutputStream(packFile);
            byte[] buffer = new byte[1024];
            int len = fileStream.read(buffer);
            while (len != -1) {
                ((OutputStream)out).write(buffer, 0, len);
                len = fileStream.read(buffer);
            }
            fileStream.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Log.Err.println(e.getMessage());
            return false;
        }
        if (!packFile.isFile()) {
            throw new IOException("Could not create file " + packFile);
        }
        String result = StartRserve.doInR("install.packages('" + packFile.getAbsolutePath().replace("\\", "/") + "', type=" + (packFile.getName().endsWith(".tar.gz") ? "'source'" : "'binary'") + ", repos=NULL,lib='" + RserveDaemon.app_dir() + "')", Rcmd, "--vanilla --silent", null);
        if (result.contains("package 'Rserve' successfully unpacked and MD5 sums checked") || result.contains("* DONE (Rserve)") || StartRserve.doInR("'Rserve' %in% installed.packages(lib.loc='" + RserveDaemon.app_dir() + "')", Rcmd, "--vanilla --silent", null).contains("TRUE")) {
            return true;
        }
        if (result.contains("FAILED") || result.contains("ERROR")) {
            Log.Out.println("\nRserve install failed: " + result.replaceAll("\n", "\n  | "));
            return false;
        }
        Log.Out.println("\nRserve install result:" + result.replaceAll("\n", "\n  | "));
        if (StartRserve.isRserveInstalled()) {
            Log.Out.println(" well installed.");
            return true;
        }
        Log.Out.println(" not well installed !");
        return false;
    }

    static String[] splitCommand(String command) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
        Matcher regexMatcher = regex.matcher(command);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String doInR(String todo, String Rcmd, String rargs, File out) throws IOException {
        Process p;
        if (out == null) {
            out = File.createTempFile("doInR_", ".Rout");
            out.deleteOnExit();
        }
        if ((p = StartRserve.system(Rcmd + " " + rargs + " -e \"" + todo + "\"", out, true)) == null) {
            throw new IOException("Failed to do in R: " + Rcmd + " " + rargs + " -e \"" + todo + "\"");
        }
        return FileUtils.readFileToString((File)out);
    }

    public static Process system(String command, File redirect, boolean waitFor) {
        command = command + " > " + redirect.getAbsolutePath() + (!RserveDaemon.isWindows() ? " 2>&1" : "");
        boolean system_log = Boolean.parseBoolean(System.getProperty("system.print", "false"));
        if (system_log) {
            Log.Out.println("  $  " + command);
        }
        Process p = null;
        try {
            if (RserveDaemon.isWindows()) {
                ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", command);
                pb.redirectError();
                p = pb.start();
                if (waitFor) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    for (int t = 0; (line = reader.readLine()) == null && t < 100; ++t) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    while ((line = reader.readLine()) != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        p.destroyForcibly();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", command);
                p = pb.start();
                if (waitFor) {
                    p.waitFor(TIMEOUT, TimeUnit.SECONDS);
                    try {
                        p.destroyForcibly();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception x) {
            Log.Err.println("Command: " + command + " failed:\n" + x.getMessage());
            return null;
        }
        return p;
    }

    public static boolean KillAll(String taskname) {
        try {
            String line;
            if (RserveDaemon.isWindows()) {
                String line2;
                ProcessBuilder pb = new ProcessBuilder(StartRserve.splitCommand("taskkill /F /IM " + taskname));
                pb.redirectErrorStream(true);
                Process k = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(k.getInputStream()));
                while ((line2 = reader.readLine()) != null) {
                }
                return true;
            }
            ProcessBuilder pb = new ProcessBuilder(StartRserve.splitCommand("killall " + taskname));
            pb.redirectErrorStream(true);
            Process k = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(k.getInputStream()));
            while ((line = reader.readLine()) != null) {
            }
            return k.waitFor(TIMEOUT, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Log.Err.println("Exception: " + ex.getMessage());
            return false;
        }
    }

    public static boolean Kill(int pid) {
        try {
            String line;
            Log.Out.print("Kill PID " + pid + ": ");
            if (RserveDaemon.isWindows()) {
                String line2;
                ProcessBuilder pb = new ProcessBuilder(StartRserve.splitCommand("taskkill /F /T /PID " + pid));
                pb.redirectErrorStream(true);
                Process k = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(k.getInputStream()));
                while ((line2 = reader.readLine()) != null) {
                    Log.Out.println("  " + line2);
                }
                return true;
            }
            ProcessBuilder pb = new ProcessBuilder(StartRserve.splitCommand("kill -9 " + pid));
            pb.redirectErrorStream(true);
            Process k = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(k.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Log.Out.println("  " + line);
            }
            return k.waitFor(TIMEOUT, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Log.Err.println("Exception: " + ex.getMessage());
            return false;
        }
    }

    public static ProcessToKill launchRserve(String Rcmd, String rargs, String rsrvargs, boolean debug, ServerSocket lock) throws IOException {
        Log.Out.println("Will launch Rserve (" + Rcmd + " " + rargs + ")");
        Log.Out.println("  With lib directory: " + RserveDaemon.app_dir());
        File wd = new File(RserveDaemon.app_dir(), new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(Calendar.getInstance().getTime()));
        Log.Out.println("  In working directory: " + wd.getAbsolutePath());
        try {
            FileUtils.forceMkdir((File)wd);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!wd.isDirectory()) {
            if (debug) {
                Log.Err.println("Working dir " + wd + " not available.");
            }
            throw new IOException("Working dir " + wd + " not available.");
        }
        wd.deleteOnExit();
        Process p = null;
        int[] last_pids = StartRserve.getRservePIDs();
        if (lock != null) {
            try {
                lock.close();
            }
            catch (IOException ex) {
                if (debug) {
                    Log.Err.println("Could not close Rserve locker");
                }
                throw new IOException("Could not close Rserve locker");
            }
        }
        File outstream = new File(RserveDaemon.app_dir(), new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(Calendar.getInstance().getTime()) + ".Rout");
        String todo = "library(Rserve,lib.loc='" + RserveDaemon.app_dir() + "'); setwd('" + wd.getAbsolutePath().replace('\\', '/') + "'); Rserve(" + (debug ? "TRUE" : "FALSE") + ",args='" + rsrvargs + "');" + UGLY_FIXES;
        p = StartRserve.system(Rcmd + " " + rargs + " -e \"" + todo + "\"", outstream, false);
        int attempts = 50;
        while (attempts-- > 10 && !outstream.exists()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (p == null) {
            if (debug) {
                Log.Err.println("Failed to do in R: " + Rcmd + " " + rargs + " -e \"" + todo + "\":\n" + FileUtils.readFileToString((File)outstream).replaceAll("\n", "\n  | "));
            }
            throw new IOException("Failed to do in R: " + Rcmd + " " + rargs + " -e \"" + todo + "\":\n" + FileUtils.readFileToString((File)outstream).replaceAll("\n", "\n  | "));
        }
        if (debug) {
            Log.Err.println(FileUtils.readFileToString((File)outstream).replaceAll("\n", "\n    | "));
        }
        int pid_attempts = 50;
        int pid = -1;
        while (pid < 0 && pid_attempts-- > 0) {
            pid = StartRserve.diff(StartRserve.getRservePIDs(), last_pids);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (pid == -1) {
            if (debug) {
                Log.Err.println("Failed to get Rserve PID:\n" + FileUtils.readFileToString((File)outstream).replaceAll("\n", "\n  | "));
            }
            throw new IOException("Failed to get Rserve PID:\n" + FileUtils.readFileToString((File)outstream).replaceAll("\n", "\n  | "));
        }
        Log.Out.println("  With PID: " + pid);
        int connect_attempts = 30;
        while (connect_attempts-- > 0) {
            try {
                RserverConf testconf;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RConnection c = null;
                int port = -1;
                if (rsrvargs.contains("--RS-port")) {
                    String rsport = rsrvargs.split("--RS-port")[1].trim().split(" ")[0];
                    port = Integer.parseInt(rsport);
                    testconf = new RserverConf("localhost", port, null, null);
                } else {
                    testconf = new RserverConf("localhost", -1, null, null);
                }
                c = testconf.connect();
                if (c == null) {
                    throw new RserverConf.TimeOut.TimeOutException("Failed start connection to " + testconf);
                }
                if (!c.isConnected()) {
                    throw new RserverConf.TimeOut.TimeOutException("Failed to connect to " + testconf);
                }
                Log.Out.println("  On port: " + testconf.port);
                if (c.eval("exists('.RSERVE_PID')").asInteger() != 0) {
                    int previous_pid = c.eval(".RSERVE_PID").asInteger();
                    StartRserve.Kill(pid);
                    throw new IOException("Rserve was already running on port " + port + " with previous PID " + previous_pid);
                }
                c.voidEval(".RSERVE_PID <- " + pid);
                Log.Out.println("  Rserve is well running on port " + testconf.port + " (PID " + pid + ")");
                c.close();
                return new ProcessToKill(p, pid);
            }
            catch (NumberFormatException | RserverConf.TimeOut.TimeOutException | REXPMismatchException | RserveException e2) {
                if (!debug) continue;
                Log.Err.println("  " + e2.getMessage());
            }
        }
        throw new IOException("Failed to launch Rserve:\n" + FileUtils.readFileToString((File)outstream).replaceAll("\n", "\n  | "));
    }

    static int diff(int[] news, int[] previous) {
        for (int i = 0; i < news.length; ++i) {
            boolean in = false;
            for (int j = 0; j < previous.length; ++j) {
                if (news[i] != previous[j]) continue;
                in = true;
                break;
            }
            if (in) continue;
            return news[i];
        }
        return -1;
    }

    public static int[] getRservePIDs() {
        int pid;
        String[] info;
        String line;
        BufferedReader reader;
        Process process;
        ProcessBuilder pb;
        LinkedList<Integer> pids = new LinkedList<Integer>();
        if (RserveDaemon.isWindows()) {
            try {
                pb = new ProcessBuilder("tasklist");
                pb.redirectErrorStream(true);
                process = pb.start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("Rserve.exe") && !line.startsWith("Rserve_d.exe")) continue;
                    info = line.split("\\s+");
                    pid = Integer.parseInt(info[1]);
                    pids.add(pid);
                }
            }
            catch (Exception e) {
                Log.Err.println(e.getMessage());
            }
        } else if (RserveDaemon.isLinux()) {
            try {
                pb = new ProcessBuilder(StartRserve.splitCommand("ps -aux"));
                pb.redirectErrorStream(true);
                process = pb.start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains("Rserve --vanilla") && !line.contains("Rserve_d --vanilla") || !line.contains("Ss")) continue;
                    info = line.split("\\s+");
                    pid = Integer.parseInt(info[1]);
                    pids.add(pid);
                }
                process.waitFor(TIMEOUT, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Log.Err.println(e.getMessage());
            }
        } else if (RserveDaemon.isMacOSX()) {
            try {
                pb = new ProcessBuilder(StartRserve.splitCommand("ps aux"));
                pb.redirectErrorStream(true);
                process = pb.start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains("Rserve --vanilla") && !line.contains("Rserve_d --vanilla") || !line.contains("Ss")) continue;
                    info = line.split("\\s+");
                    pid = Integer.parseInt(info[1]);
                    pids.add(pid);
                }
                process.waitFor(TIMEOUT, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Log.Err.println(e.getMessage());
            }
        } else {
            Log.Err.println("Cannot recognize OS: " + System.getProperty("os.name"));
        }
        int[] ps = new int[pids.size()];
        for (int i = 0; i < pids.size(); ++i) {
            ps[i] = (Integer)pids.get(i);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocket lockPort(final int p) {
        ServerSocket ss = null;
        final String id = "" + Math.random();
        FilterOutputStream dout = null;
        Socket cs = null;
        try {
            final ServerSocket sss = new ServerSocket(p);
            sss.setSoTimeout(5000);
            ss = sss;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        locking = true;
                        Socket s = sss.accept();
                        DataInputStream dis = new DataInputStream(s.getInputStream());
                        String str = dis.readUTF();
                        if (!str.equals(id)) {
                            throw new IOException("Wrong port id!");
                        }
                    }
                    catch (IOException ex) {
                        try {
                            sss.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        Log.Err.println("Lock port " + p + " failed: " + ex.getMessage());
                    }
                }
            });
            t.start();
            int n = 50;
            while (n-- > 0 && !locking) {
                Thread.sleep(100L);
            }
            if (!locking) {
                throw new IOException("Did not start ServerSocket on port " + p);
            }
            locking = false;
            cs = new Socket("localhost", p);
            dout = new DataOutputStream(cs.getOutputStream());
            ((DataOutputStream)dout).writeUTF(id);
            ((DataOutputStream)dout).flush();
            t.join();
        }
        catch (IOException | InterruptedException e) {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ServerSocket serverSocket = null;
            return serverSocket;
        }
        finally {
            if (dout != null) {
                try {
                    dout.close();
                }
                catch (IOException iOException) {}
            }
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ss.isClosed() ? null : ss;
    }

    public static boolean checkLocalRserve(int port) {
        if (StartRserve.isRserveListening(port)) {
            return true;
        }
        if (!RserveDaemon.findR_HOME(RserveDaemon.R_HOME)) {
            return false;
        }
        try {
            if (RserveDaemon.isWindows()) {
                ProcessToKill p = StartRserve.launchRserve(RserveDaemon.R_HOME + "\\bin\\R.exe", "--vanilla", "--vanilla --RS-port " + port, false, null);
                if (p == null) {
                    return false;
                }
                p.kill();
                return true;
            }
            ProcessToKill p = StartRserve.launchRserve(RserveDaemon.R_HOME + "/bin/R", "--vanilla", "--vanilla --RS-port " + port, false, null);
            if (p == null) {
                return false;
            }
            p.kill();
            return true;
        }
        catch (Exception e) {
            Log.Err.println("Local Rserve not available.");
            return false;
        }
    }

    public static boolean isRserveListening(int port) {
        try {
            RConnection c = new RConnection("localhost", port);
            Log.Out.println("Rserve is running on port " + port);
            c.close();
            return true;
        }
        catch (Exception e) {
            Log.Err.println("First connect try failed with: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        File dir = null;
        System.out.println("checkLocalRserve: " + StartRserve.checkLocalRserve(6311));
        try {
            RConnection c = new RConnection(RserverConf.DEFAULT_RSERVE_HOST, RserverConf.DEFAULT_RSERVE_PORT);
            dir = new File(c.eval("getwd()").asString());
            System.err.println("wd: " + dir);
            c.eval("download.file('https://www.r-project.org/',paste0(getwd(),'/log.txt'))");
            c.shutdown();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (new File(dir, "log.txt").exists()) {
            System.err.println("OK: file exists");
            if (new File(dir, "log.txt").length() > 10L) {
                System.err.println("OK: file not empty");
            } else {
                System.err.println("NO: file EMPTY");
            }
        } else {
            System.err.println("NO: file DOES NOT exist");
        }
    }

    public static class ProcessToKill {
        public Process process;
        public int pid;

        public ProcessToKill(Process p, int pid) {
            this.process = p;
            this.pid = pid;
        }

        public void kill() {
            try {
                this.process.destroyForcibly();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StartRserve.Kill(this.pid);
        }
    }
}

