/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.math.R.EvalListener;
import org.math.R.Log;
import org.math.R.RLog;
import org.math.R.RLogPrintStream;
import org.math.R.RserveDaemon;
import org.math.R.RserverConf;
import org.math.R.Rsession;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;
import org.rosuda.REngine.Rserve.RserveException;

public class RserveSession
extends Rsession
implements RLog {
    RConnection R;
    public static final int MinRserveVersion = 103;
    public boolean connected = false;
    RserveDaemon localRserve;
    public RserverConf RserveConf;
    public static final String STATUS_NOT_SET = "Unknown status";
    public static final String STATUS_READY = "Ready";
    public static final String STATUS_ERROR = "Error";
    public static final String STATUS_ENDED = "End";
    public static final String STATUS_NOT_CONNECTED = "Not connected";
    public static final String STATUS_CONNECTING = "Connecting...";
    public String status = "Unknown status";
    private static final String ENVIRONMENT_DEFAULT = "..rserve..";
    public static final String HEAD_SET = "[set] ";

    public static String cat(RList list) {
        if (list == null || list.names == null) {
            return null;
        }
        try {
            int i;
            StringBuffer sb = new StringBuffer("\t");
            double[][] data = new double[list.names.size()][];
            for (i = 0; i < list.size(); ++i) {
                String n = list.keyAt(i);
                sb.append(n + "\t");
                data[i] = list.at(n).asDoubles();
            }
            sb.append("\n");
            for (i = 0; i < data[0].length; ++i) {
                sb.append(i + 1 + "\t");
                for (int j = 0; j < data.length; ++j) {
                    sb.append(data[j][i] + "\t");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (REXPMismatchException r) {
            return "(Not a numeric dataframe)\n" + new REXPList(list).toDebugString();
        }
    }

    public static RserveSession newLocalInstance(RLog console, Properties localRProperties) {
        return new RserveSession(console, localRProperties, null);
    }

    public static RserveSession newRemoteInstance(RLog console, RserverConf serverconf) {
        return new RserveSession(console, null, serverconf);
    }

    public static RserveSession newInstanceTry(RLog console, RserverConf serverconf) {
        try {
            RConnection c = serverconf.connect();
            Log.Out.println("Rserve is available on " + serverconf);
            c.close();
        }
        catch (Exception e) {
            Log.Err.println("Rserve is not available on " + serverconf + ". Trying to spawn a new one");
            serverconf = null;
        }
        return new RserveSession(console, null, serverconf);
    }

    public static RserveSession newLocalInstance(PrintStream pconsole, Properties localRProperties) {
        return new RserveSession(pconsole, localRProperties, null);
    }

    public static RserveSession newRemoteInstance(PrintStream pconsole, RserverConf serverconf) {
        return new RserveSession(pconsole, null, serverconf);
    }

    public static RserveSession newInstanceTry(PrintStream pconsole, RserverConf serverconf) {
        return new RserveSession(pconsole, null, serverconf);
    }

    public RserveSession(RLog console, Properties properties, RserverConf serverconf) {
        super(console);
        this.envName = ENVIRONMENT_DEFAULT;
        this.RserveConf = serverconf;
        this.SINK_FILE = "./rout.txt";
        try {
            this.startup();
        }
        catch (Exception ex) {
            console.log(ex.getMessage(), RLog.Level.ERROR);
            ex.printStackTrace();
            return;
        }
        this.silentlyVoidEval("if (!any(file.access(.libPaths(),2)>=0)) .libPaths(new=tempdir())");
        this.setenv(properties);
    }

    public RserveSession(PrintStream p, Properties properties, RserverConf serverconf) {
        this(new RLogPrintStream(p), properties, serverconf);
    }

    public String getStatus() {
        return this.status;
    }

    void startup() throws Exception {
        this.log(this.RserveConf == null ? "Will start Rserve session without conf." : "Will start Rserve session using: " + this.RserveConf.toString(), RLog.Level.INFO);
        this.status = STATUS_NOT_CONNECTED;
        if (this.RserveConf == null) {
            this.RserveConf = new RserverConf(RserverConf.DEFAULT_RSERVE_HOST, -1, null, null);
            this.log("No Rserve conf given. Trying to use " + this.RserveConf.toString(), RLog.Level.INFO);
            try {
                this.localRserve = new RserveDaemon(this.RserveConf, this);
            }
            catch (Exception ex) {
                this.log(ex.getMessage(), RLog.Level.ERROR);
                throw ex;
            }
            this.localRserve.start();
            this.RserveConf = this.localRserve.conf;
        }
        this.status = STATUS_CONNECTING;
        this.R = this.RserveConf.connect();
        boolean bl = this.connected = this.R != null;
        if (!this.connected) {
            this.log("Rserve " + this.RserveConf + " is not accessible.", RLog.Level.ERROR);
            this.status = STATUS_ERROR;
            throw new Rsession.RException("Rserve " + this.RserveConf + " is not accessible.");
        }
        if (this.R.getServerVersion() < 103) {
            this.log("Rserve " + this.RserveConf + " version is too old.", RLog.Level.ERROR);
            this.status = STATUS_ERROR;
            throw new Rsession.RException("Rserve " + this.RserveConf + " version is too old.");
        }
        this.status = STATUS_READY;
    }

    @Override
    public void end() {
        super.end();
        if (this.R == null) {
            this.log("Void session terminated.", RLog.Level.INFO);
            this.cleanupListeners();
            return;
        }
        if ((!RserveDaemon.UNIX_OPTIMIZE || this.isWindows()) && this.localRserve != null) {
            this.log("Ending local service...", RLog.Level.INFO);
            this.localRserve.stop();
        }
        this.log("Closing session...", RLog.Level.INFO);
        this.R.close();
        this.log("Session teminated.", RLog.Level.INFO);
        this.R = null;
        this.cleanupListeners();
    }

    @Override
    public String getLastError() {
        if (!this.SINK_MESSAGE) {
            if (this.R != null) {
                return this.R.getLastError();
            }
            return null;
        }
        return this.lastMessage;
    }

    @Override
    public String gethomedir() {
        return this.asString(this.silentlyRawEval("path.expand('~')"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized boolean silentlyVoidEval(String expression, boolean tryEval) {
        if (!this.connected) {
            this.log("[exception] R environment not initialized.", RLog.Level.ERROR);
            return false;
        }
        if (expression == null) {
            return false;
        }
        if (expression.trim().length() == 0) {
            return true;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        REXP e = null;
        try {
            if (this.SINK_OUTPUT) {
                this.R.eval(".f <- file('" + this.SINK_FILE + "',open='wt')");
                this.R.eval("sink(.f,type='output')");
            }
            if (this.SINK_MESSAGE) {
                this.R.eval(".fm <- file('" + this.SINK_FILE + ".m',open='wt')");
                this.R.eval("sink(.fm,type='message')");
            }
            e = tryEval ? this.R.parseAndEval("try(eval(parse(text='" + expression.replace("'", "\\'") + "')),silent=FALSE)") : this.R.parseAndEval(expression);
        }
        catch (Exception ex) {
            this.log("[exception] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.SINK_OUTPUT) {
                try {
                    this.R.parseAndEval("sink(type='output')");
                    this.lastOuput = this.R.parseAndEval("paste(collapse='\n',readLines('" + this.SINK_FILE + "'))").asString();
                    this.log(this.lastOuput, RLog.Level.OUTPUT);
                }
                catch (Exception ex) {
                    this.lastOuput = ex.getMessage();
                    this.log(this.lastOuput, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.f)");
                        this.R.parseAndEval("unlink('" + this.SINK_FILE + "')");
                    }
                    catch (Exception ex) {
                        this.log(ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
            if (this.SINK_MESSAGE) {
                try {
                    this.R.parseAndEval("sink(type='message')");
                    this.lastMessage = this.R.parseAndEval("paste(collapse='\n',readLines('" + this.SINK_FILE + ".m'))").asString();
                    this.log(this.lastMessage, RLog.Level.INFO);
                }
                catch (Exception ex) {
                    this.lastMessage = ex.getMessage();
                    this.log(this.lastMessage, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.fm)");
                        this.R.parseAndEval("unlink('" + this.SINK_FILE + ".m')");
                    }
                    catch (Exception ex) {
                        this.log(ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
        }
        if (!tryEval) return true;
        if (e == null) return true;
        try {
            if (!e.inherits("try-error")) return true;
            this.log("[exception] " + e.asString() + "\n  " + expression, RLog.Level.WARNING);
            return false;
        }
        catch (REXPMismatchException ex) {
            this.log("[error] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized Object silentlyRawEval(String expression, boolean tryEval) {
        if (!this.connected) {
            this.log("[exception] R environment not initialized.", RLog.Level.ERROR);
            return new Rsession.RException("[exception] R environment not initialized.");
        }
        if (expression == null) {
            return null;
        }
        if (expression.trim().length() == 0) {
            return null;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        Object e = null;
        try {
            if (this.SINK_OUTPUT) {
                this.R.eval(".f <- file('" + this.SINK_FILE + "',open='wt')");
                this.R.eval("sink(.f,type='output')");
            }
            if (this.SINK_MESSAGE) {
                this.R.eval(".fm <- file('" + this.SINK_FILE + ".m',open='wt')");
                this.R.eval("sink(.fm,type='message')");
            }
            e = tryEval ? this.R.parseAndEval("try(eval(parse(text='" + expression.replace("'", "\\'") + "')),silent=FALSE)") : this.R.parseAndEval(expression);
        }
        catch (Exception ex) {
            this.log("[exception] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            Rsession.RException rException = new Rsession.RException("[exception] " + ex.getMessage() + "\n  " + expression);
            return rException;
        }
        finally {
            if (this.SINK_OUTPUT) {
                try {
                    this.R.parseAndEval("sink(type='output')");
                    this.lastOuput = this.R.parseAndEval("paste(collapse='\n',readLines('" + this.SINK_FILE + "'))").asString();
                    this.log(this.lastOuput, RLog.Level.OUTPUT);
                }
                catch (Exception ex) {
                    this.lastOuput = ex.getMessage();
                    this.log(this.lastOuput, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.f)");
                        this.R.parseAndEval("unlink('" + this.SINK_FILE + "')");
                    }
                    catch (Exception ex) {
                        this.log("[exception] " + ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
            if (this.SINK_MESSAGE) {
                try {
                    this.R.parseAndEval("sink(type='message')");
                    this.lastMessage = this.R.parseAndEval("paste(collapse='\n',readLines('" + this.SINK_FILE + ".m'))").asString();
                    this.log(this.lastMessage, RLog.Level.INFO);
                }
                catch (Exception ex) {
                    this.lastMessage = ex.getMessage();
                    this.log(this.lastMessage, RLog.Level.WARNING);
                }
                finally {
                    try {
                        this.R.eval("close(.fm)");
                        this.R.parseAndEval("unlink('" + this.SINK_FILE + ".m')");
                    }
                    catch (Exception ex) {
                        this.log("[exception] " + ex.getMessage(), RLog.Level.ERROR);
                    }
                }
            }
        }
        if (!tryEval) return e;
        if (e == null) return e;
        try {
            if (!e.inherits("try-error")) return e;
            this.log("[exception] " + e.asString() + "\n  " + expression, RLog.Level.WARNING);
            return new Rsession.RException("[exception] " + e.asString() + "\n  " + expression);
        }
        catch (REXPMismatchException ex) {
            this.log("[error] " + ex.getMessage() + "\n  " + expression, RLog.Level.ERROR);
            return new Rsession.RException("[error] " + ex.getMessage() + "\n  " + expression);
        }
    }

    public String getRServeOS() {
        String os = this.asString(this.rawEval("Sys.info()['sysname']", this.TRY_MODE));
        return os == null ? "NA" : os;
    }

    @Override
    public boolean isWindows() {
        return this.getRServeOS().startsWith("Windows");
    }

    @Override
    public boolean isLinux() {
        return this.getRServeOS().startsWith("Linux");
    }

    @Override
    public boolean isMacOSX() {
        return this.getRServeOS().startsWith("Darwin");
    }

    private static RList buildRList(double[][] data, String ... names) {
        if (data == null) {
            if (names == null) {
                return null;
            }
            REXP[] nulls = new REXP[names.length];
            for (int i = 0; i < nulls.length; ++i) {
                nulls[i] = new REXPDouble(new double[0]);
            }
            return new RList(nulls, names);
        }
        if (data[0].length != 0 && data[0].length != names.length) {
            throw new IllegalArgumentException("Cannot build R list from " + Arrays.deepToString((Object[])data) + " & " + Arrays.toString(names));
        }
        REXP[] vals = new REXP[names.length];
        for (int i = 0; i < names.length; ++i) {
            double[] coli = new double[data.length];
            for (int j = 0; j < coli.length; ++j) {
                coli[j] = data[j] == null ? Double.NaN : (data[j].length > i ? data[j][i] : Double.NaN);
            }
            vals[i] = new REXPDouble(coli);
        }
        return new RList(vals, names);
    }

    private static RList buildRList(List<double[]> coldata, String ... names) {
        return RserveSession.buildRList((double[][])coldata.toArray((T[])new double[coldata.size()][]), names);
    }

    protected static String toRcode(RList l) {
        String sl = "list(";
        for (String k : l.keys()) {
            if (l.get((Object)k) instanceof REXPDouble) {
                REXPDouble v = (REXPDouble)l.get((Object)k);
                sl = sl + k + "=" + RserveSession.toRcode(v.asDoubles()) + ",";
                continue;
            }
            sl = sl + k + "=" + l.get((Object)k).toString() + ",";
        }
        return sl.substring(0, sl.length() - 2) + ")";
    }

    protected static String toRcode(Object o) {
        if (o instanceof RList) {
            return RserveSession.toRcode((RList)o);
        }
        return Rsession.toRcode(o);
    }

    @Override
    public synchronized boolean set(String varname, double[][] data, String ... names) {
        this.note_code("`" + varname + "` <- " + (data == null ? "list()" : RserveSession.toRcode(data)));
        this.note_code("names(" + varname + ") <- " + RserveSession.toRcode(names));
        this.note_code("`" + varname + "` <- data.frame(" + varname + ")");
        RList list = RserveSession.buildRList(data, names);
        this.log(HEAD_SET + varname + " <- " + list, RLog.Level.INFO);
        try {
            this.R.assign(varname, REXP.createDataFrame((RList)list));
        }
        catch (REXPMismatchException re) {
            this.log("[error]  RList " + list.toString() + " not convertible as dataframe.", RLog.Level.ERROR);
            return false;
        }
        catch (RserveException ex) {
            this.log("[exception] " + ex.getMessage() + "\n  set(String varname=" + varname + ",double[][] data, String... names)", RLog.Level.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean set(String varname, Object var) throws Rsession.RException {
        this.note_code("`" + varname + "` <- " + RserveSession.toRcode(var));
        if (!this.connected) {
            this.log("[exception] R environment not initialized. Please make sure that R.init() method was called first.", RLog.Level.ERROR);
            return false;
        }
        this.log(HEAD_SET + varname + " <- " + var, RLog.Level.INFO);
        if (var == null) {
            this.rm(varname);
            return true;
        }
        if (var instanceof RList) {
            RList l = (RList)var;
            try {
                this.R.assign(varname, (REXP)new REXPList(l));
            }
            catch (RserveException ex) {
                this.log("[exception] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (RList) var)", RLog.Level.ERROR);
                return false;
            }
        }
        if (var instanceof File) {
            this.putFile((File)var);
            return this.silentlyVoidEval(varname + "<-'" + ((File)var).getName() + "'");
        }
        if (var instanceof Integer) {
            return this.silentlyVoidEval(varname + "<-" + (Integer)var);
        }
        if (var instanceof Double) {
            return this.silentlyVoidEval(varname + "<-" + (Double)var);
        }
        if (var instanceof Double[]) {
            Double[] varD = (Double[])var;
            double[] vard = new double[varD.length];
            System.arraycopy(varD, 0, vard, 0, varD.length);
            try {
                this.R.assign(varname, vard);
            }
            catch (REngineException ex) {
                this.log("[error] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (Double[]) var)", RLog.Level.ERROR);
                return false;
            }
            return this.silentlyVoidEval(varname);
        }
        if (var instanceof double[]) {
            try {
                this.R.assign(varname, (double[])var);
            }
            catch (REngineException ex) {
                this.log("[error] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[]) var)", RLog.Level.ERROR);
                return false;
            }
            return this.silentlyVoidEval(varname);
        }
        if (var instanceof Double[][]) {
            Double[][] array = (Double[][])var;
            int rows = array.length;
            int col = array[0].length;
            try {
                this.R.assign("row_" + varname, RserveSession.reshapeAsRow(array));
            }
            catch (REngineException ex) {
                this.log("[error] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[][]) var)", RLog.Level.ERROR);
                return false;
            }
            boolean done = this.silentlyVoidEval(varname + "<-array(row_" + varname + ",c(" + rows + "," + col + "))");
            return done && this.silentlyVoidEval("rm(row_" + varname + ")");
        }
        if (var instanceof double[][]) {
            double[][] array = (double[][])var;
            int rows = array.length;
            int col = array[0].length;
            try {
                this.R.assign("row_" + varname, RserveSession.reshapeAsRow(array));
            }
            catch (REngineException ex) {
                this.log("[error] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[][]) var)", RLog.Level.ERROR);
                return false;
            }
            boolean done = this.silentlyVoidEval(varname + "<-array(row_" + varname + ",c(" + rows + "," + col + "))");
            return done && this.silentlyVoidEval("rm(row_" + varname + ")");
        }
        if (var instanceof String) {
            try {
                this.R.assign(varname, (String)var);
            }
            catch (RserveException ex) {
                this.log("[exception] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (String) var)", RLog.Level.ERROR);
                return false;
            }
            return this.silentlyVoidEval(varname);
        }
        if (var instanceof String[]) {
            try {
                this.R.assign(varname, (String[])var);
            }
            catch (REngineException ex) {
                this.log("[error] " + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (String[]) var)", RLog.Level.ERROR);
                return false;
            }
            return this.silentlyVoidEval(varname);
        }
        if (var instanceof Map) {
            Map m = (Map)var;
            try {
                this.R.eval(varname + " <- list()");
            }
            catch (RserveException ex) {
                this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                return false;
            }
            for (Object k : m.keySet()) {
                String h = this.hash(k);
                this.set(varname + "." + h, m.get(k));
                try {
                    this.R.eval(varname + "[['" + k + "']] <- " + varname + "." + h);
                }
                catch (RserveException ex) {
                    this.log("[error] " + ex.getMessage(), RLog.Level.ERROR);
                    return false;
                }
                try {
                    this.rm(varname + "." + h);
                }
                catch (Rsession.RException e) {
                    this.log("[error] " + e.getMessage(), RLog.Level.WARNING);
                }
            }
            return this.silentlyVoidEval(varname);
        }
        throw new IllegalArgumentException("Variable " + varname + " is not double, double[],  double[][], String or String[]. R engine can not handle.");
        return true;
    }

    public static REXPList asRList(Map m) {
        RList l = new RList();
        for (Object o : m.keySet()) {
            Object v = m.get(o);
            if (v instanceof Double) {
                l.put((Object)o.toString(), (Object)new REXPDouble(((Double)v).doubleValue()));
                continue;
            }
            if (v instanceof double[]) {
                l.put((Object)o.toString(), (Object)new REXPDouble((double[])v));
                continue;
            }
            if (v instanceof Integer) {
                l.put((Object)o.toString(), (Object)new REXPInteger(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof int[]) {
                l.put((Object)o.toString(), (Object)new REXPInteger((int[])v));
                continue;
            }
            if (v instanceof String) {
                l.put((Object)o.toString(), (Object)new REXPString((String)v));
                continue;
            }
            if (v instanceof String[]) {
                l.put((Object)o.toString(), (Object)new REXPString((String[])v));
                continue;
            }
            if (v instanceof Boolean) {
                l.put((Object)o.toString(), (Object)new REXPLogical(((Boolean)v).booleanValue()));
                continue;
            }
            if (v instanceof boolean[]) {
                l.put((Object)o.toString(), (Object)new REXPLogical((boolean[])v));
                continue;
            }
            if (v instanceof Map) {
                l.put((Object)o.toString(), (Object)RserveSession.asRList((Map)v));
                continue;
            }
            if (v instanceof RList) {
                l.put((Object)o.toString(), (Object)((RList)v));
                continue;
            }
            if (v == null) {
                l.put((Object)o.toString(), (Object)new REXPNull());
                continue;
            }
            Log.Err.println("[asRList] Could not cast object " + o + " : " + v);
        }
        return new REXPList(l);
    }

    @Override
    public double asDouble(Object o) throws ClassCastException {
        if (o == null) {
            return (Double)null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asDouble] Not an REXP object: " + o);
        }
        try {
            return ((REXP)o).asDouble();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asDouble] Cannot cast to double " + o);
        }
    }

    @Override
    public double[] asArray(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof double[]) {
            return (double[])o;
        }
        if (o instanceof Double) {
            return new double[]{(Double)o};
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asArray] Not an REXP object: " + o);
        }
        if (((REXP)o).isNull()) {
            return null;
        }
        try {
            return ((REXP)o).asDoubles();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asArray] Cannot cast to double[] " + o);
        }
    }

    @Override
    public double[][] asMatrix(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof double[][]) {
            return (double[][])o;
        }
        if (o instanceof Map) {
            double[][] vals = null;
            int i = 0;
            try {
                for (Object k : ((Map)o).keySet()) {
                    double[] v = null;
                    try {
                        v = (double[])((Map)o).get(k);
                    }
                    catch (Exception ex) {
                        throw new ClassCastException("[asMatrix] Cannot cast list element to double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                    }
                    if (v == null) {
                        throw new ClassCastException("[asMatrix] Cannot get list element as double[] " + ((Map)o).get(k) + " for key " + k + " in " + o);
                    }
                    if (vals == null) {
                        vals = new double[v.length][((Map)o).size()];
                    }
                    for (int j = 0; j < v.length; ++j) {
                        vals[j][i] = v[j];
                    }
                    ++i;
                }
                return vals;
            }
            catch (Exception ex) {
                throw new ClassCastException("[asMatrix] Cannot cast Map to matrix: " + ex.getMessage());
            }
        }
        if (o instanceof double[]) {
            return this.t(new double[][]{(double[])o});
        }
        if (o instanceof Double) {
            return new double[][]{{(Double)o}};
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asMatrix] Not an REXP object: " + o);
        }
        if (((REXP)o).isNull()) {
            return null;
        }
        try {
            return ((REXP)o).asDoubleMatrix();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asMatrix] Cannot cast to matrix " + o);
        }
    }

    @Override
    public String asString(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asString] Not an REXP object: " + o);
        }
        try {
            return ((REXP)o).asString();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asString] Cannot cast to string " + o);
        }
    }

    @Override
    public String[] asStrings(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asStrings] Not an REXP object: " + o);
        }
        if (((REXP)o).isNull()) {
            return null;
        }
        try {
            return ((REXP)o).asStrings();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asStrings] Cannot cast to strings " + o);
        }
    }

    @Override
    public int asInteger(Object o) throws ClassCastException {
        if (o == null) {
            return (Integer)null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asInteger] Not an REXP object: " + o.getClass());
        }
        try {
            return ((REXP)o).asInteger();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asInteger] Cannot cast to integer " + o);
        }
    }

    @Override
    public int[] asIntegers(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asIntegers] Not an REXP object: " + o);
        }
        if (((REXP)o).isNull()) {
            return null;
        }
        try {
            return ((REXP)o).asIntegers();
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asIntegers] Cannot cast to integers " + o);
        }
    }

    @Override
    public boolean asLogical(Object o) throws ClassCastException {
        if (o == null) {
            return (Boolean)null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Rsession.RException) {
            throw new IllegalArgumentException("[asLogical] Exception: " + ((Rsession.RException)o).getMessage());
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asLogical] Not an REXP object: " + o);
        }
        try {
            return ((REXP)o).asInteger() == 1;
        }
        catch (Exception ex) {
            throw new ClassCastException("[asLogical] Cannot cast to logical " + o);
        }
    }

    @Override
    public boolean[] asLogicals(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        if (o instanceof Boolean) {
            return new boolean[]{(Boolean)o};
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asLogicals] Not an REXP object: " + o);
        }
        if (((REXP)o).isNull()) {
            return null;
        }
        try {
            int[] i = ((REXP)o).asIntegers();
            boolean[] ok = new boolean[i.length];
            for (int j = 0; j < ok.length; ++j) {
                ok[j] = i[j] == 1;
            }
            return ok;
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asLogicals] Cannot cast to logicals " + o);
        }
    }

    @Override
    public Map asList(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return (Map)o;
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[asList] Not an REXP object: " + o);
        }
        if (((REXP)o).isNull()) {
            return null;
        }
        try {
            RList l = ((REXP)o).asList();
            HashMap<String, Object> m = new HashMap<String, Object>(l.size());
            for (String k : l.keys()) {
                m.put(k, this.cast(l.at(k)));
            }
            return m;
        }
        catch (REXPMismatchException ex) {
            throw new ClassCastException("[asList] Cannot cast to matrix " + o);
        }
    }

    @Override
    public Object cast(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        if (!(o instanceof REXP)) {
            throw new ClassCastException("[cast] Not an REXP object: " + o);
        }
        REXP eval = (REXP)o;
        try {
            if (eval.isNumeric()) {
                if (eval.dim() == null || eval.dim().length == 1) {
                    if (eval.isInteger()) {
                        int[] array = eval.asIntegers();
                        if (array.length == 0) {
                            return null;
                        }
                        if (array.length == 1) {
                            return array[0];
                        }
                        return array;
                    }
                    double[] array = eval.asDoubles();
                    if (array.length == 0) {
                        return null;
                    }
                    if (array.length == 1) {
                        return array[0];
                    }
                    return array;
                }
                double[][] mat = eval.asDoubleMatrix();
                if (mat.length == 0) {
                    return null;
                }
                if (mat.length == 1) {
                    if (mat[0].length == 0) {
                        return null;
                    }
                    if (mat[0].length == 1) {
                        return mat[0][0];
                    }
                    return mat[0];
                }
                if (mat[0].length == 0) {
                    return null;
                }
                if (mat[0].length == 1) {
                    double[] dmat = new double[mat.length];
                    for (int i = 0; i < dmat.length; ++i) {
                        dmat[i] = mat[i][0];
                    }
                    return dmat;
                }
                return mat;
            }
            if (eval.isString()) {
                String[] s = eval.asStrings();
                if (s.length == 1) {
                    return s[0];
                }
                return s;
            }
            if (eval.isLogical()) {
                return eval.asInteger() == 1;
            }
            if (eval.isList()) {
                return this.asList(eval);
            }
            try {
                String name = "function_" + (int)Math.floor(1000.0 * Math.random());
                this.R.assign(name, eval);
                if (this.R.eval("is.function(" + name + ")").asInteger() == 1) {
                    return new Rsession.Function(this, name);
                }
            }
            catch (RserveException ex) {
                throw new REXPMismatchException(eval, "assign");
            }
        }
        catch (REXPMismatchException e) {
            throw new ClassCastException("Cannot cast " + eval + ": REXPMismatchException on " + eval.toDebugString());
        }
        if (eval.isNull()) {
            return null;
        }
        Log.Err.println("Cannot cast " + eval + ": unsupported type " + eval.toDebugString());
        throw new ClassCastException("Cannot cast " + eval + ": unsupported type " + eval.toDebugString());
    }

    @Override
    public boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (!(o instanceof REXP)) {
            throw new IllegalArgumentException("[isNull] Not an REXP object: " + o);
        }
        try {
            return ((REXP)o).isNull();
        }
        catch (Exception ex) {
            throw new ClassCastException("[isNull] Cannot check is null " + o);
        }
    }

    @Override
    public String toString(Object o) {
        if (o instanceof REXP) {
            if (o instanceof REXPNull) {
                return "NULL";
            }
            if (((REXP)o).isList()) {
                RList l = ((REXPGenericVector)o).asList();
                String s = "";
                for (String k : l.keys()) {
                    s = s + k + ": " + this.toString(l.get((Object)k)) + "\n";
                }
                return s;
            }
            if (((REXP)o).isVector()) {
                try {
                    String[] ss = ((REXP)o).asStrings();
                    if (((REXP)o).length() > 10) {
                        return Arrays.asList(ss[0], ss[1], "...(" + ss.length + ")...", ss[ss.length - 2], ss[ss.length - 1]).toString();
                    }
                    return Arrays.asList(((REXP)o).asStrings()).toString();
                }
                catch (Exception ex) {
                    throw new ClassCastException("[toString] Cannot toString " + o);
                }
            }
            try {
                return ((REXP)o).asString();
            }
            catch (Exception ex) {
                throw new ClassCastException("[toString] Cannot toString " + o);
            }
        }
        if (o.getClass().isArray()) {
            return Arrays.asList(o).toString();
        }
        return o.toString();
    }

    @Override
    public File putFileInWorkspace(File file) {
        return this.putFile(file, this.local2remotePath(file).getPath());
    }

    @Override
    public void getFileFromWorkspace(File file) {
        this.getFile(this.remote2localPath(file), file.getPath());
    }

    @Override
    public void save(File f, String ... vars) throws Rsession.RException {
        super.save(this.local2remotePath(f), vars);
    }

    @Override
    public void savels(File f, String ... vars) throws Rsession.RException {
        super.savels(this.local2remotePath(f), vars);
    }

    @Override
    public void toGraphic(File f, int width, int height, String fileformat, String ... commands) {
        super.toGraphic(this.local2remotePath(f), width, height, fileformat, commands);
    }

    @Override
    public String asR2HTML(String command) {
        String html = super.asR2HTML(command);
        this.deleteFile("htmlfile_" + command.hashCode());
        return html;
    }

    public void getFile(File localfile) {
        this.getFile(localfile, localfile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getFile(File localfile, String remoteFile) {
        try {
            if (((REXP)this.silentlyRawEval("file.exists('" + remoteFile.replace("\\", "/") + "')", this.TRY_MODE)).asInteger() != 1) {
                this.log("[error] [IO] file " + remoteFile + " not found.", RLog.Level.ERROR);
            }
        }
        catch (Exception ex) {
            this.log("[error] " + ex.getMessage() + "\n  getFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")", RLog.Level.ERROR);
            return;
        }
        if (localfile.exists() && !this.RserveConf.isLocal() && !remoteFile.equals(localfile.getAbsolutePath())) {
            if (!localfile.delete()) {
                this.log("[error] [IO] file " + localfile + " cannot be deleted.", RLog.Level.ERROR);
                return;
            }
            if (!localfile.exists()) {
                this.log("[IO] Local file " + localfile + " deleted.", RLog.Level.INFO);
            } else {
                this.log("[error] [IO] file " + localfile + " still exists !", RLog.Level.ERROR);
                return;
            }
        }
        if (localfile.getParentFile() != null && !localfile.getParentFile().isDirectory() && !localfile.getParentFile().mkdir()) {
            this.log("[error] [IO] parent directory " + localfile.getParentFile() + " not created.", RLog.Level.ERROR);
            return;
        }
        this.note_code("file.copy(from='" + localfile + "',to='" + remoteFile + "') # Rserve.putFile");
        RFileInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = this.R.openFile(remoteFile.replace("\\", "/"));
            os = new BufferedOutputStream(new FileOutputStream(localfile));
            IOUtils.copy((InputStream)is, (OutputStream)os);
            this.log("[IO] File " + remoteFile + " received.", RLog.Level.INFO);
            is.close();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            try {
                this.log("[error] [IO] " + this.R.getLastError() + ": file " + remoteFile + " not transmitted.\n" + e.getMessage(), RLog.Level.ERROR);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    private synchronized void deleteFile(String remoteFile) {
        try {
            this.R.removeFile(remoteFile.replace("\\", "/"));
        }
        catch (RserveException ex) {
            this.log("[exception] " + ex.getMessage() + "\n  removeFile(String remoteFile=" + remoteFile + ")", RLog.Level.ERROR);
        }
    }

    public File putFile(File localfile) {
        return this.putFile(localfile, localfile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File putFile(File localfile, String remoteFile) {
        if (!localfile.exists()) {
            this.log("[error] [IO] " + this.R.getLastError() + "\n  file " + localfile.getAbsolutePath() + " does not exists.", RLog.Level.ERROR);
        }
        try {
            if (((REXP)this.silentlyRawEval("file.exists('" + remoteFile.replace("\\", "/") + "')", this.TRY_MODE)).asInteger() == 1) {
                this.silentlyVoidEval("file.remove('" + remoteFile.replace("\\", "/") + "')", this.TRY_MODE);
                this.log("[IO] Remote file " + remoteFile + " deleted.", RLog.Level.INFO);
            }
        }
        catch (REXPMismatchException ex) {
            this.log("[error] " + ex.getMessage() + "\n  putFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")", RLog.Level.ERROR);
            return null;
        }
        BufferedInputStream is = null;
        RFileOutputStream os = null;
        try {
            os = this.R.createFile(remoteFile.replace("\\", "/"));
            is = new BufferedInputStream(new FileInputStream(localfile));
            IOUtils.copy((InputStream)is, (OutputStream)os);
            this.log("[IO] File " + remoteFile + " sent.", RLog.Level.INFO);
            ((InputStream)is).close();
            os.close();
        }
        catch (IOException e) {
            try {
                this.log("[error] [IO] " + this.R.getLastError() + ": file " + remoteFile + " not writable.\n" + e.getMessage(), RLog.Level.ERROR);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        return new File(remoteFile);
    }

    @Override
    public synchronized Object proxyEval(String expression, Map<String, Object> vars) throws Rsession.RException {
        Object out = super.proxyEval(expression, vars);
        if (out == null) {
            boolean restartR = false;
            try {
                double testOut = this.asDouble(this.rawEval("1+pi"));
                if (testOut == Double.NaN || Math.abs(testOut - 4.141592653589793) > 0.1) {
                    restartR = true;
                }
            }
            catch (Exception e) {
                restartR = true;
            }
            if (restartR) {
                Log.Err.println("Problem occured, R engine restarted.");
                this.log("[cache] Problem occured, R engine restarted.", RLog.Level.INFO);
                this.end();
                try {
                    this.startup();
                }
                catch (Exception ex) {
                    throw new Rsession.RException(ex.getMessage());
                }
                return this.proxyEval(expression, vars);
            }
        }
        return out;
    }

    @Override
    public boolean isAvailable() {
        return this.connected;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            args = new String[10];
            for (int i = 0; i < args.length; ++i) {
                args[i] = Math.random() + "+pi";
            }
        }
        RserveSession R = null;
        int i = 0;
        if (args[0].startsWith("R://")) {
            ++i;
            R = new RserveSession(System.out, null, RserverConf.parse(args[0]));
        } else {
            R = new RserveSession(System.out, null, null);
        }
        for (int j = i; j < args.length; ++j) {
            System.out.print(args[j] + ": ");
            System.out.println(R.cast(R.rawEval(args[j])));
        }
        R.closeLog();
        System.out.println(R.notebook());
    }

    @Override
    public void setGlobalEnv(String envName) {
        envName = envName == null ? ENVIRONMENT_DEFAULT : ".." + envName + "..";
        try {
            if (!this.asLogical(this.R.eval("exists('" + this.envName + "')"))) {
                this.R.eval(this.envName + " = new.env()");
            }
            this.R.eval("for (.n in ls()) {\n " + this.envName + "[[.n]] = .GlobalEnv[[.n]]\n}");
            this.rmAll();
            if (!this.asLogical(this.R.eval("exists('" + envName + "')"))) {
                this.R.eval(envName + " = new.env()");
            }
            this.R.eval("for (.n in ls(" + envName + ")) {\n .GlobalEnv[[.n]] = " + envName + "[[.n]]\n}");
        }
        catch (RserveException ex) {
            Log.Err.println(ex.getMessage());
        }
        this.envName = envName;
    }

    @Override
    public void copyGlobalEnv(String envName) {
        envName = envName == null ? ENVIRONMENT_DEFAULT : ".." + envName + "..";
        try {
            if (!this.asLogical(this.R.eval("exists('" + envName + "')"))) {
                this.R.eval(envName + " = new.env()");
            }
            this.R.eval("for (.n in ls()) {\n " + envName + "[[.n]] = .GlobalEnv[[.n]]\n}");
        }
        catch (RserveException ex) {
            Log.Err.println(ex.getMessage());
        }
    }
}

