/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.math.R.Log;
import org.math.R.RLog;
import org.math.R.RLogSlf4j;
import org.math.R.RegistryHog;
import org.math.R.RserverConf;
import org.math.R.StartRserve;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class RserveDaemon {
    RserverConf conf;
    Process process;
    private final RLog log;
    static int rand = Math.round((float)Math.random() * 10000.0f);
    private static File R_APP_DIR = new File(new File(System.getProperty("Rserve.HOME", FileUtils.getTempDirectoryPath()), ".Rserve"), "" + rand){

        @Override
        public String toString() {
            if (RserveDaemon.isWindows()) {
                return super.toString().replace("\\", "/");
            }
            return super.toString();
        }
    };
    public static String R_HOME = null;
    public static String R_VERSION = null;
    private static String OS = System.getProperty("os.name").toLowerCase();
    public static final String R_HOME_KEY = "R_HOME";
    boolean stopped = false;
    static String RESERVE_ARGS = "--vanilla";
    public StartRserve.ProcessToKill rserve;
    public static boolean USE_RSERVE_FROM_CRAN = Boolean.parseBoolean(System.getProperty("Rserve.INSTALL_FROM_CRAN", "false"));
    static volatile boolean starting = false;
    static final Object launchRserveLock = new Object();
    public static final boolean UNIX_OPTIMIZE = Boolean.parseBoolean(System.getProperty("Rserve.NO_INC_PORT", "false"));

    static File app_dir() throws IOException {
        boolean app_dir_ok = false;
        if (!R_APP_DIR.exists()) {
            app_dir_ok = R_APP_DIR.mkdirs();
        } else {
            boolean bl = app_dir_ok = R_APP_DIR.isDirectory() && R_APP_DIR.canWrite();
        }
        if (!app_dir_ok && !(R_APP_DIR = new File(new File(FileUtils.getUserDirectory(), ".Rserve"), "" + rand)).mkdirs()) {
            throw new IOException("Could not create directory " + new File(new File(System.getProperty("Rserve.HOME", FileUtils.getTempDirectoryPath()), ".Rserve"), "" + rand) + "\n or " + new File(new File(FileUtils.getUserDirectory(), ".Rserve"), "" + rand));
        }
        return R_APP_DIR;
    }

    static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    static boolean isMacOSX() {
        return OS.indexOf("mac") >= 0;
    }

    static boolean isLinux() {
        return OS.indexOf("inux") >= 0;
    }

    public RserveDaemon(RserverConf conf, RLog log, String R_HOME) throws Exception {
        this.conf = conf;
        RLog rLog = this.log = log != null ? log : new RLogSlf4j();
        if (!RserveDaemon.findR_HOME(R_HOME)) {
            throw new Exception("Failed to find R_HOME (with default " + R_HOME + ") as " + RserveDaemon.R_HOME);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RserveDaemon.this._stop();
            }
        });
    }

    private void _stop() {
        this.stop();
    }

    public RserveDaemon(RserverConf conf, RLog log) throws Exception {
        this(conf, log, null);
    }

    public static boolean findR_HOME(String r_HOME) {
        Map<String, String> env = System.getenv();
        Properties prop = System.getProperties();
        if (r_HOME != null) {
            R_HOME = r_HOME;
        }
        if (R_HOME == null || !new File(R_HOME).isDirectory()) {
            if (env.containsKey(R_HOME_KEY)) {
                R_HOME = env.get(R_HOME_KEY);
            }
            if (R_HOME == null || prop.containsKey(R_HOME_KEY) || !new File(R_HOME).isDirectory()) {
                R_HOME = prop.getProperty(R_HOME_KEY);
            }
            if (R_HOME == null || !new File(R_HOME).isDirectory()) {
                R_HOME = "R";
            }
            if (R_HOME == null || !new File(R_HOME).isDirectory()) {
                String[] paths;
                R_HOME = null;
                if (RserveDaemon.isWindows()) {
                    try {
                        Process rp = Runtime.getRuntime().exec("reg query HKLM\\Software\\R-core\\R");
                        RegistryHog regHog = new RegistryHog(rp.getInputStream(), true);
                        rp.waitFor(StartRserve.TIMEOUT, TimeUnit.SECONDS);
                        regHog.join();
                        R_HOME = regHog.getInstallPath();
                        if (new File(R_HOME).isDirectory()) {
                            throw new Exception("R_HOME from HKLM\\Software\\R-core\\R is not correct: " + R_HOME);
                        }
                    }
                    catch (Exception rge) {
                        for (int version = 4; version >= 0; --version) {
                            block5: for (int major = 20; major >= 0; --major) {
                                for (int minor = 10; minor >= 0; --minor) {
                                    r_HOME = "C:\\Progra~1\\R\\R-" + version + "." + major + "." + minor + "\\";
                                    if (!new File(r_HOME).isDirectory() || !new File(r_HOME, "bin").isDirectory()) continue;
                                    R_HOME = r_HOME;
                                    continue block5;
                                }
                            }
                        }
                    }
                    if (!new File(R_HOME).isDirectory() && new File(r_HOME = "C:\\R").isDirectory() && new File(r_HOME, "bin").isDirectory()) {
                        R_HOME = r_HOME;
                    }
                } else if (RserveDaemon.isMacOSX()) {
                    int minor;
                    String[] version = paths = new String[]{"/Library/Frameworks/R.framework/Resources/", "/usr/lib/R", "/usr/local/lib/R"};
                    int major = version.length;
                    for (minor = 0; minor < major; ++minor) {
                        String r_home = version[minor];
                        R_HOME = r_home;
                        if (!new File(R_HOME).isDirectory()) continue;
                        return true;
                    }
                    for (int version2 = 4; version2 >= 0; --version2) {
                        block9: for (major = 20; major >= 0; --major) {
                            for (minor = 10; minor >= 0; --minor) {
                                r_HOME = "/usr/local/Cellar/r/" + version2 + "." + major + "." + minor;
                                if (new File(r_HOME + "_3").isDirectory()) {
                                    R_HOME = r_HOME + "_3";
                                    continue block9;
                                }
                                if (new File(r_HOME + "_2").isDirectory()) {
                                    R_HOME = r_HOME + "_2";
                                    continue block9;
                                }
                                if (new File(r_HOME + "_1").isDirectory()) {
                                    R_HOME = r_HOME + "_1";
                                    continue block9;
                                }
                                if (!new File(r_HOME).isDirectory()) continue;
                                R_HOME = r_HOME;
                                continue block9;
                            }
                        }
                    }
                } else {
                    for (String r_home : paths = new String[]{"/usr/lib/R", "/usr/local/lib/R/", "/usr/lib64/R"}) {
                        R_HOME = r_home;
                        if (!new File(R_HOME).isDirectory()) continue;
                        return true;
                    }
                }
            }
        }
        if (R_HOME == null) {
            Log.Err.println("Failed to find R_HOME");
            return false;
        }
        if (!new File(R_HOME).isDirectory()) {
            Log.Err.println("Found wrong R_HOME: " + R_HOME);
            return false;
        }
        try {
            File bin = new File(R_HOME + File.separator + "bin" + File.separator + "R" + (RserveDaemon.isWindows() ? ".exe" : ""));
            if (!bin.isFile()) {
                Log.Err.println("R binary not found in R_HOME: " + R_HOME + "\n  which contains only:\n" + Arrays.toString(new File(R_HOME).listFiles()));
                return false;
            }
            File out = File.createTempFile("Rversion", "out");
            out.deleteOnExit();
            StartRserve.system(bin.getAbsolutePath() + " --silent  -e \"cat(R.version[['major']])\"", out, true);
            R_VERSION = FileUtils.readFileToString((File)out).replaceAll(">.*", "").trim();
            return true;
        }
        catch (Exception e) {
            Log.Err.println("Failed to get R version: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    static void setRecursiveExecutable(File path) {
        for (File f : path.listFiles()) {
            if (f.isDirectory()) {
                f.setExecutable(true);
                RserveDaemon.setRecursiveExecutable(f);
                continue;
            }
            if (f.canExecute() || !f.getName().endsWith(".so") && !f.getName().endsWith(".dll")) continue;
            f.setExecutable(true);
        }
    }

    public void stop() {
        block16: {
            if (this.stopped) {
                this.log.log("R daemon " + this.conf + " already stopped.", RLog.Level.INFO);
                return;
            }
            this.log.log("Stopping R daemon... " + this.conf, RLog.Level.INFO);
            if (!this.conf.isLocal()) {
                throw new UnsupportedOperationException("Not authorized to stop a remote R daemon: " + this.conf.toString());
            }
            try {
                RConnection s = this.conf.connection;
                if (s == null || !s.isConnected()) {
                    s = this.conf.connect();
                }
                if (s != null && s.isConnected()) {
                    try {
                        s.serverShutdown();
                    }
                    catch (RserveException ex) {
                        this.log.log("Could not remotely shutdown server", RLog.Level.WARNING);
                    }
                    s.shutdown();
                    break block16;
                }
                this.log.log("Could not connect Rserve to shutdown", RLog.Level.WARNING);
            }
            catch (Exception ex) {
                this.log.log("Failed to connect Rserve to shutdown", RLog.Level.WARNING);
            }
        }
        try {
            if (this.rserve.pid > 0) {
                int[] pids = StartRserve.getRservePIDs();
                boolean in = false;
                for (int i = 0; i < pids.length; ++i) {
                    if (pids[i] != this.rserve.pid) continue;
                    in = true;
                    break;
                }
                if (in) {
                    this.rserve.kill();
                } else {
                    this.log.log("Rserve PID not active.", RLog.Level.INFO);
                }
            } else {
                this.log.log("No Rserve PID.", RLog.Level.WARNING);
            }
            if (this.rserve.process != null && this.rserve.process.isAlive()) {
                this.rserve.process.destroyForcibly();
                this.rserve.process.getInputStream().close();
                this.rserve.process.getErrorStream().close();
            }
        }
        catch (Exception ex) {
            this.log.log("Could not kill Rserve process: " + ex.getMessage(), RLog.Level.ERROR);
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (R_HOME == null || !new File(R_HOME).exists()) {
            throw new IllegalArgumentException("R_HOME environment variable not correctly set.\nYou can set it using 'java ... -DR_HOME=[Path to R] ...' startup command.");
        }
        String Rcmd = R_HOME + File.separator + "bin" + File.separator + "R" + (RserveDaemon.isWindows() ? ".exe" : "");
        if (!this.conf.isLocal()) {
            throw new UnsupportedOperationException("Unable to start a remote R daemon: " + this.conf.toString());
        }
        boolean RserveInstalled = StartRserve.isRserveInstalled();
        if (!RserveInstalled) {
            RserveInstalled = StartRserve.installRserveFromLocalLibrary(Rcmd);
            if (!RserveInstalled && !USE_RSERVE_FROM_CRAN) {
                RserveInstalled = StartRserve.installBundledRserve(Rcmd);
            }
            if (!RserveInstalled) {
                RserveInstalled = StartRserve.installRserve(Rcmd, System.getenv("http_proxy"), null);
            }
            if (!RserveInstalled) {
                String notice = "Please install Rserve in your R environment using \"install.packages('Rserve')\" command, from R.";
                throw new Exception(notice);
            }
        }
        ServerSocket portLocker = null;
        Object object = launchRserveLock;
        synchronized (object) {
            while (starting) {
                launchRserveLock.wait();
            }
            starting = true;
            try {
                if (this.conf.port < 0) {
                    int rserverPort = RserverConf.DEFAULT_RSERVE_PORT;
                    if (RserveDaemon.isWindows() || !UNIX_OPTIMIZE) {
                        while (portLocker == null) {
                            portLocker = StartRserve.lockPort(++rserverPort);
                        }
                    }
                    this.conf.port = rserverPort;
                } else {
                    portLocker = StartRserve.lockPort(this.conf.port);
                    if (portLocker == null) {
                        throw new Exception("R daemon could not lock port " + this.conf.port);
                    }
                }
                this.log.log("Starting R daemon... " + this.conf, RLog.Level.INFO);
                String RserveArgs = RESERVE_ARGS + " --RS-port " + this.conf.port;
                if (this.rserve != null) {
                    this.rserve.kill();
                }
                this.rserve = StartRserve.launchRserve(Rcmd, "--vanilla", RserveArgs.toString(), Boolean.parseBoolean(System.getProperty("Rserve.debug", "false")), portLocker);
                this.log.log("                 ... R daemon started.", RLog.Level.INFO);
            }
            catch (Exception e) {
                this.log.log("R daemon startup failed: " + e.getMessage(), RLog.Level.ERROR);
                throw e;
            }
            finally {
                starting = false;
                launchRserveLock.notify();
            }
        }
    }
}

