/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.math.R.Log;
import org.math.R.Rsession;
import org.math.R.UpdateObjectsListener;

public class RObjectsPanel
extends JPanel
implements UpdateObjectsListener {
    private RObjectsModel _model;
    private List<File> Rfiles = new LinkedList<File>();
    private static int _fontSize = 12;
    private static Font _smallFont = new Font("Arial", 0, _fontSize - 2);
    TypeCellRenderer typerenderer = new TypeCellRenderer();
    ObjectCellRenderer objectrenderer = new ObjectCellRenderer();
    Map<String, String> prints = new HashMap<String, String>();
    String[] ls = new String[0];
    Map<String, String> typeOf = new HashMap<String, String>(){

        @Override
        public String get(Object key) {
            if (key == null) {
                return null;
            }
            String keystr = (String)key;
            if (!super.containsKey(keystr)) {
                super.put(keystr, RObjectsPanel.this.R == null ? "" : RObjectsPanel.this.R.typeOf(keystr));
            }
            return (String)super.get(keystr);
        }
    };
    Rsession R;
    public JButton _add;
    private JToolBar _bar;
    public JButton _del;
    private JTable _oList;
    public JButton _save;
    private JButton jButton1;
    private JScrollPane jScrollPane1;

    @Override
    public void setTarget(Rsession r) {
        this.R = r;
    }

    public void setAutoUpdate(boolean autoupdate) {
        if (autoupdate) {
            this.jButton1.setEnabled(false);
            this.R.addUpdateObjectsListener(this);
        } else {
            this.jButton1.setEnabled(true);
            this.R.removeUpdateObjectsListener(this);
        }
    }

    public RObjectsPanel(Rsession r) {
        this.setTarget(r);
        this.initComponents();
        this._model = (RObjectsModel)this._oList.getModel();
        this._oList.setAutoResizeMode(4);
        this._oList.getTableHeader().setFont(_smallFont);
        this._oList.getTableHeader().setReorderingAllowed(false);
        for (ObjectColumns col : ObjectColumns.values()) {
            this._oList.getColumnModel().getColumn(col.value).setPreferredWidth(col.width);
        }
        this._oList.getColumnModel().getColumn(ObjectColumns.NAME.value).setCellRenderer(this.objectrenderer);
        this._oList.getColumnModel().getColumn(ObjectColumns.TYPE.value).setCellRenderer(this.typerenderer);
        this._oList.setSelectionMode(2);
        this._oList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
    }

    @Override
    public void update() {
        try {
            String[] rls;
            this.ls = this.R == null ? new String[0] : ((rls = this.R.asStrings(this.R.silentlyRawEval("ls()"))) != null ? rls : new String[0]);
            if (this.ls != null && this.ls.length > 0) {
                for (String l : this.ls) {
                    try {
                        String print = this.R.asHTML(l);
                        this.prints.put(l, print);
                    }
                    catch (Exception re) {
                        this.prints.put(l, "?:" + re.getMessage());
                    }
                }
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RObjectsPanel.this._model.fireTableDataChanged();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this._oList = new JTable();
        this._bar = new JToolBar();
        this.jButton1 = new JButton();
        this._add = new JButton();
        this._del = new JButton();
        this._save = new JButton();
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this._oList.setAutoCreateRowSorter(true);
        this._oList.setModel(new RObjectsModel());
        this.jScrollPane1.setViewportView(this._oList);
        this._bar.setFloatable(false);
        this._bar.setOrientation(1);
        this._bar.setRollover(true);
        this.jButton1.setText("Update");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RObjectsPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this._bar.add(this.jButton1);
        this._add.setText("Add");
        this._add.setToolTipText("Add R object");
        this._add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RObjectsPanel.this._addActionPerformed(evt);
            }
        });
        this._bar.add(this._add);
        this._del.setText("Delete");
        this._del.setToolTipText("Remove R object");
        this._del.setFocusable(false);
        this._del.setHorizontalTextPosition(0);
        this._del.setVerticalTextPosition(3);
        this._del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RObjectsPanel.this._delActionPerformed(evt);
            }
        });
        this._bar.add(this._del);
        this._save.setText("Save");
        this._save.setToolTipText("Remove R object");
        this._save.setFocusable(false);
        this._save.setHorizontalTextPosition(0);
        this._save.setVerticalTextPosition(3);
        this._save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RObjectsPanel.this._saveActionPerformed(evt);
            }
        });
        this._bar.add(this._save);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this._bar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 406, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 197, Short.MAX_VALUE).addComponent(this._bar, -1, 197, Short.MAX_VALUE));
    }

    private void _addActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".R") || f.getName().endsWith(".Rdata");
            }

            @Override
            public String getDescription() {
                return "R object file";
            }
        });
        if (fc.showOpenDialog(this) == 0 && fc.getSelectedFiles() != null) {
            File[] files;
            for (File file : files = fc.getSelectedFiles()) {
                if (file.getName().endsWith(".R")) {
                    if (this.R == null) continue;
                    this.R.source(file);
                    continue;
                }
                if (file.getName().endsWith(".Rdata")) {
                    if (this.R == null) continue;
                    this.R.load(file);
                    continue;
                }
                Log.Out.println("Not loading/sourcing " + file.getName());
            }
        }
        this.update();
    }

    private void _delActionPerformed(ActionEvent evt) {
        int[] i = this._oList.getSelectedRows();
        String[] o = new String[i.length];
        for (int j = 0; j < i.length; ++j) {
            o[j] = (String)this._oList.getValueAt(i[j], 0);
        }
        if (this.R != null) {
            try {
                this.R.rm(o);
            }
            catch (Rsession.RException ex) {
                ex.printStackTrace();
            }
        }
        this.update();
    }

    private void _saveActionPerformed(ActionEvent evt) {
        int[] i = this._oList.getSelectedRows();
        String[] o = new String[i.length];
        for (int j = 0; j < i.length; ++j) {
            o[j] = (String)this._oList.getValueAt(i[j], 0);
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("R data file", "Rdata"));
        if (this.R != null) {
            fc.setSelectedFile(new File(Rsession.cat("_", o) + ".Rdata"));
            if (fc.showSaveDialog(this) == 0 && fc.getSelectedFile() != null) {
                try {
                    this.R.save(fc.getSelectedFile(), o);
                }
                catch (Rsession.RException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.update();
    }

    public class RObjectsModel
    extends DefaultTableModel {
        public RObjectsModel() {
            super((Object[])ObjectColumns.values(), 0);
        }

        @Override
        public int getRowCount() {
            return RObjectsPanel.this.ls.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == ObjectColumns.NAME.value) {
                return RObjectsPanel.this.ls[row];
            }
            if (col == ObjectColumns.TYPE.value) {
                return RObjectsPanel.this.typeOf.get(RObjectsPanel.this.ls[row]);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        public Class getColumnClass(int col) {
            return String.class;
        }
    }

    class ObjectCellRenderer
    extends TypeCellRenderer {
        ObjectCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object name, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, col);
            this.setToolTipText(RObjectsPanel.this.prints.get(name.toString()));
            return this;
        }
    }

    class TypeCellRenderer
    extends DefaultTableCellRenderer {
        TypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object name, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, col);
            this.setText((String)name);
            this.setFont(_smallFont);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static enum ObjectColumns {
        NAME(0, 100, "Object"),
        TYPE(1, 100, "Type");

        String name;
        int value;
        int width;

        private ObjectColumns(int v, int w, String n2) {
            this.value = v;
            this.width = w;
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

