# swx_sdk
Digital Model API documentation

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.8.12
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swx_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swx_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import swx_sdk
from pprint import pprint
from swx_sdk.api import actions_api
from swx_sdk.model.action_delay_list_response import ActionDelayListResponse
from swx_sdk.model.action_delete_response import ActionDeleteResponse
from swx_sdk.model.action_list_response import ActionListResponse
from swx_sdk.model.action_request import ActionRequest
from swx_sdk.model.action_response_element1 import ActionResponseElement1
from swx_sdk.model.action_update_request import ActionUpdateRequest
from swx_sdk.model.action_update_response import ActionUpdateResponse
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = swx_sdk.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with swx_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = actions_api.ActionsApi(api_client)
    space = "altair" # str | 
collection_name = "ElectronicBoards" # str | 
thing_id = "01edb9j75vymj8p7qppm19h8nx" # str | 
action = "delay" # str | 
action_request = ActionRequest(
        delay=ActionRequestDelay(
            input=ActionRequestDelayInput(
                delay=5,
            ),
        ),
    ) # ActionRequest | Create a new action

    try:
        # Request action
        api_response = api_instance.add_action(space, collection_name, thing_id, action, action_request)
        pprint(api_response)
    except swx_sdk.ApiException as e:
        print("Exception when calling ActionsApi->add_action: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActionsApi* | [**add_action**](docs/ActionsApi.md#add_action) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action} | Request action
*ActionsApi* | [**delete_action**](docs/ActionsApi.md#delete_action) | **DELETE** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Delete Action
*ActionsApi* | [**list_actions**](docs/ActionsApi.md#list_actions) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions | Lists all the action queues for a thing
*ActionsApi* | [**list_actions_by_name**](docs/ActionsApi.md#list_actions_by_name) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action} | List the queue of actions from a thing
*ActionsApi* | [**show_action**](docs/ActionsApi.md#show_action) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Show action requested
*ActionsApi* | [**update_action**](docs/ActionsApi.md#update_action) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Update action inside a queue
*CollectionsApi* | [**add_collection**](docs/CollectionsApi.md#add_collection) | **POST** /spaces/{space}/collections | Create collection
*CollectionsApi* | [**delete_collection**](docs/CollectionsApi.md#delete_collection) | **DELETE** /spaces/{space}/collections/{collection-name} | Delete collection
*CollectionsApi* | [**list_collections**](docs/CollectionsApi.md#list_collections) | **GET** /spaces/{space}/collections | List collections
*CollectionsApi* | [**show_collection**](docs/CollectionsApi.md#show_collection) | **GET** /spaces/{space}/collections/{collection-name} | Show collection
*CollectionsApi* | [**update_collection**](docs/CollectionsApi.md#update_collection) | **PUT** /spaces/{space}/collections/{collection-name} | Update collection
*EventsApi* | [**add_event**](docs/EventsApi.md#add_event) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event} | Add event
*EventsApi* | [**list_events**](docs/EventsApi.md#list_events) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events | List history of all events
*EventsApi* | [**list_events_by_name**](docs/EventsApi.md#list_events_by_name) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event} | List history of one type of event
*EventsApi* | [**show_event**](docs/EventsApi.md#show_event) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event}/{event-id} | Show event
*ItemsApi* | [**list_items**](docs/ItemsApi.md#list_items) | **GET** /spaces/{space}/collections/{collection-name}/things-status | List items
*ItemsApi* | [**show_item**](docs/ItemsApi.md#show_item) | **GET** /spaces/{space}/collections/{collection-name}/things-status/{thing-id} | Show item
*ModelVersionsApi* | [**add_version**](docs/ModelVersionsApi.md#add_version) | **POST** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions | Create version
*ModelVersionsApi* | [**delete_version**](docs/ModelVersionsApi.md#delete_version) | **DELETE** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Delete version
*ModelVersionsApi* | [**list_version**](docs/ModelVersionsApi.md#list_version) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions | List version
*ModelVersionsApi* | [**show_version**](docs/ModelVersionsApi.md#show_version) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Show version
*ModelVersionsApi* | [**update_version**](docs/ModelVersionsApi.md#update_version) | **PUT** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Update version
*ModelsApi* | [**add_model**](docs/ModelsApi.md#add_model) | **POST** /spaces/{space}/collections/{collection-name}/models | Create model
*ModelsApi* | [**delete_model**](docs/ModelsApi.md#delete_model) | **DELETE** /spaces/{space}/collections/{collection-name}/models/{model-name} | Delete model
*ModelsApi* | [**list_models**](docs/ModelsApi.md#list_models) | **GET** /spaces/{space}/collections/{collection-name}/models | List models
*ModelsApi* | [**show_model**](docs/ModelsApi.md#show_model) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name} | Show model
*ModelsApi* | [**update_model**](docs/ModelsApi.md#update_model) | **PUT** /spaces/{space}/collections/{collection-name}/models/{model-name} | Update model
*PropertiesApi* | [**list_properties**](docs/PropertiesApi.md#list_properties) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties | List properties
*PropertiesApi* | [**show_property**](docs/PropertiesApi.md#show_property) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties/{property} | Show property
*PropertiesApi* | [**update_property**](docs/PropertiesApi.md#update_property) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties/{property} | Update property
*ThingsApi* | [**add_thing**](docs/ThingsApi.md#add_thing) | **POST** /spaces/{space}/collections/{collection-name}/things | Add a thing description
*ThingsApi* | [**delete_thing**](docs/ThingsApi.md#delete_thing) | **DELETE** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Delete thing
*ThingsApi* | [**list_things**](docs/ThingsApi.md#list_things) | **GET** /spaces/{space}/collections/{collection-name}/things | List thing descriptions
*ThingsApi* | [**reset_client_secret**](docs/ThingsApi.md#reset_client_secret) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/reset-secret | Reset Client Secret
*ThingsApi* | [**show_thing**](docs/ThingsApi.md#show_thing) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Show thing
*ThingsApi* | [**update_thing**](docs/ThingsApi.md#update_thing) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Update thing description


## Documentation For Models

 - [ActionDelay](docs/ActionDelay.md)
 - [ActionDelayInput](docs/ActionDelayInput.md)
 - [ActionDelayInputProperties](docs/ActionDelayInputProperties.md)
 - [ActionDelayInputPropertiesInput](docs/ActionDelayInputPropertiesInput.md)
 - [ActionDelayListResponse](docs/ActionDelayListResponse.md)
 - [ActionDelayResponse](docs/ActionDelayResponse.md)
 - [ActionDeleteResponse](docs/ActionDeleteResponse.md)
 - [ActionListResponse](docs/ActionListResponse.md)
 - [ActionReboot](docs/ActionReboot.md)
 - [ActionRebootResponse](docs/ActionRebootResponse.md)
 - [ActionRequest](docs/ActionRequest.md)
 - [ActionRequestDelay](docs/ActionRequestDelay.md)
 - [ActionRequestDelayInput](docs/ActionRequestDelayInput.md)
 - [ActionResponseElement1](docs/ActionResponseElement1.md)
 - [ActionResponseElement1Delay](docs/ActionResponseElement1Delay.md)
 - [ActionResponseElement2](docs/ActionResponseElement2.md)
 - [ActionResponseElement2Delay](docs/ActionResponseElement2Delay.md)
 - [ActionResponseElement2DelayInput](docs/ActionResponseElement2DelayInput.md)
 - [ActionResponseElement3](docs/ActionResponseElement3.md)
 - [ActionResponseElement3Reboot](docs/ActionResponseElement3Reboot.md)
 - [ActionUpdateRequest](docs/ActionUpdateRequest.md)
 - [ActionUpdateRequestDelay](docs/ActionUpdateRequestDelay.md)
 - [ActionUpdateResponse](docs/ActionUpdateResponse.md)
 - [ActionUpdateResponseDelay](docs/ActionUpdateResponseDelay.md)
 - [CollectionListResponse](docs/CollectionListResponse.md)
 - [CollectionListResponsePaging](docs/CollectionListResponsePaging.md)
 - [CollectionRequest](docs/CollectionRequest.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionUpdateRequest](docs/CollectionUpdateRequest.md)
 - [CollectionUpdateResponse](docs/CollectionUpdateResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ErrorResponseError](docs/ErrorResponseError.md)
 - [EventHighCPU](docs/EventHighCPU.md)
 - [EventHighCPUData](docs/EventHighCPUData.md)
 - [EventHighCPUListResponse](docs/EventHighCPUListResponse.md)
 - [EventHighCPUResponse](docs/EventHighCPUResponse.md)
 - [EventRequest](docs/EventRequest.md)
 - [EventRequestHighCPU](docs/EventRequestHighCPU.md)
 - [EventResponse](docs/EventResponse.md)
 - [EventResponse2](docs/EventResponse2.md)
 - [EventResponse2HighCPU](docs/EventResponse2HighCPU.md)
 - [EventResponseHighCPU](docs/EventResponseHighCPU.md)
 - [ModelListResponse](docs/ModelListResponse.md)
 - [ModelProperty](docs/ModelProperty.md)
 - [ModelRequest](docs/ModelRequest.md)
 - [ModelResponse](docs/ModelResponse.md)
 - [ModelUpdateRequest](docs/ModelUpdateRequest.md)
 - [ModelUpdateResponse](docs/ModelUpdateResponse.md)
 - [ModelVersionListResponse](docs/ModelVersionListResponse.md)
 - [ModelVersionRequest](docs/ModelVersionRequest.md)
 - [ModelVersionResponse](docs/ModelVersionResponse.md)
 - [Properties](docs/Properties.md)
 - [PropertyCPU](docs/PropertyCPU.md)
 - [PropertyCPUResponse](docs/PropertyCPUResponse.md)
 - [PropertyCPUResponseLinks](docs/PropertyCPUResponseLinks.md)
 - [PropertyDisk](docs/PropertyDisk.md)
 - [PropertyDiskResponse](docs/PropertyDiskResponse.md)
 - [PropertyMemory](docs/PropertyMemory.md)
 - [PropertyMemoryResponse](docs/PropertyMemoryResponse.md)
 - [Secret](docs/Secret.md)
 - [ThingCreateResponse](docs/ThingCreateResponse.md)
 - [ThingCreateResponseActions](docs/ThingCreateResponseActions.md)
 - [ThingCreateResponseCredentials](docs/ThingCreateResponseCredentials.md)
 - [ThingCreateResponseCredentialsHttp](docs/ThingCreateResponseCredentialsHttp.md)
 - [ThingCreateResponseCredentialsMqtt](docs/ThingCreateResponseCredentialsMqtt.md)
 - [ThingCreateResponseCredentialsMqttData](docs/ThingCreateResponseCredentialsMqttData.md)
 - [ThingCreateResponseCredentialsMqttThing](docs/ThingCreateResponseCredentialsMqttThing.md)
 - [ThingCreateResponseEvents](docs/ThingCreateResponseEvents.md)
 - [ThingCreateResponseLinks](docs/ThingCreateResponseLinks.md)
 - [ThingCreateResponseProperties](docs/ThingCreateResponseProperties.md)
 - [ThingDeleteResponse](docs/ThingDeleteResponse.md)
 - [ThingDeleteResponseErrorClusterBackend](docs/ThingDeleteResponseErrorClusterBackend.md)
 - [ThingListResponse](docs/ThingListResponse.md)
 - [ThingRequest](docs/ThingRequest.md)
 - [ThingRequestActions](docs/ThingRequestActions.md)
 - [ThingRequestEvents](docs/ThingRequestEvents.md)
 - [ThingRequestProperties](docs/ThingRequestProperties.md)
 - [ThingResponse](docs/ThingResponse.md)
 - [ThingStatusListResponse](docs/ThingStatusListResponse.md)
 - [ThingStatusResponse](docs/ThingStatusResponse.md)
 - [ThingUpdateRequest](docs/ThingUpdateRequest.md)
 - [ThingUpdateResponse](docs/ThingUpdateResponse.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in swx_sdk.apis and swx_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from swx_sdk.api.default_api import DefaultApi`
- `from swx_sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import swx_sdk
from swx_sdk.apis import *
from swx_sdk.models import *
```

LICENSE
This project is licensed under the MIT License - see the license file for details.
LICENSE
This project is licensed under the MIT License - see the license file for details.
LICENSE
This project is licensed under the MIT License - see the license file for details.
LICENSE
This project is licensed under the MIT License - see the license file for details.
LICENSE
This project is licensed under the MIT License - see the license file for details.
LICENSE
This project is licensed under the MIT License - see the license file for details.
