# coding: utf-8

"""
    Mainnet Cash

    A developer friendly bitcoin cash wallet api  This API is currently in active development, breaking changes may be made prior to official release of version 1.  **Important:** This library is in active development   # noqa: E501

    The version of the OpenAPI document: 0.0.1-rc
    Contact: hello@mainnet.cash
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mainnet.configuration import Configuration


class ContractFnRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'contract_id': 'str',
        'wallet_id': 'str',
        'action': 'str',
        'get_hex_only': 'bool',
        'utxo_ids': 'list[str]'
    }

    attribute_map = {
        'contract_id': 'contractId',
        'wallet_id': 'walletId',
        'action': 'action',
        'get_hex_only': 'getHexOnly',
        'utxo_ids': 'utxoIds'
    }

    def __init__(self, contract_id=None, wallet_id=None, action=None, get_hex_only=None, utxo_ids=None, local_vars_configuration=None):  # noqa: E501
        """ContractFnRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._contract_id = None
        self._wallet_id = None
        self._action = None
        self._get_hex_only = None
        self._utxo_ids = None
        self.discriminator = None

        self.contract_id = contract_id
        self.wallet_id = wallet_id
        self.action = action
        if get_hex_only is not None:
            self.get_hex_only = get_hex_only
        if utxo_ids is not None:
            self.utxo_ids = utxo_ids

    @property
    def contract_id(self):
        """Gets the contract_id of this ContractFnRequest.  # noqa: E501

        serialized contract   # noqa: E501

        :return: The contract_id of this ContractFnRequest.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this ContractFnRequest.

        serialized contract   # noqa: E501

        :param contract_id: The contract_id of this ContractFnRequest.  # noqa: E501
        :type contract_id: str
        """
        if self.local_vars_configuration.client_side_validation and contract_id is None:  # noqa: E501
            raise ValueError("Invalid value for `contract_id`, must not be `None`")  # noqa: E501

        self._contract_id = contract_id

    @property
    def wallet_id(self):
        """Gets the wallet_id of this ContractFnRequest.  # noqa: E501

        ID that is returned in `wallet` field of /wallet call   # noqa: E501

        :return: The wallet_id of this ContractFnRequest.  # noqa: E501
        :rtype: str
        """
        return self._wallet_id

    @wallet_id.setter
    def wallet_id(self, wallet_id):
        """Sets the wallet_id of this ContractFnRequest.

        ID that is returned in `wallet` field of /wallet call   # noqa: E501

        :param wallet_id: The wallet_id of this ContractFnRequest.  # noqa: E501
        :type wallet_id: str
        """
        if self.local_vars_configuration.client_side_validation and wallet_id is None:  # noqa: E501
            raise ValueError("Invalid value for `wallet_id`, must not be `None`")  # noqa: E501

        self._wallet_id = wallet_id

    @property
    def action(self):
        """Gets the action of this ContractFnRequest.  # noqa: E501

        Action for finalization of contract.  # noqa: E501

        :return: The action of this ContractFnRequest.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this ContractFnRequest.

        Action for finalization of contract.  # noqa: E501

        :param action: The action of this ContractFnRequest.  # noqa: E501
        :type action: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["spend", "refund"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def get_hex_only(self):
        """Gets the get_hex_only of this ContractFnRequest.  # noqa: E501

        getHexOnly (default:false), if true, will cause only the transaction hex to be returned; if false, the transaction will be sent to the network   # noqa: E501

        :return: The get_hex_only of this ContractFnRequest.  # noqa: E501
        :rtype: bool
        """
        return self._get_hex_only

    @get_hex_only.setter
    def get_hex_only(self, get_hex_only):
        """Sets the get_hex_only of this ContractFnRequest.

        getHexOnly (default:false), if true, will cause only the transaction hex to be returned; if false, the transaction will be sent to the network   # noqa: E501

        :param get_hex_only: The get_hex_only of this ContractFnRequest.  # noqa: E501
        :type get_hex_only: bool
        """

        self._get_hex_only = get_hex_only

    @property
    def utxo_ids(self):
        """Gets the utxo_ids of this ContractFnRequest.  # noqa: E501


        :return: The utxo_ids of this ContractFnRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._utxo_ids

    @utxo_ids.setter
    def utxo_ids(self, utxo_ids):
        """Sets the utxo_ids of this ContractFnRequest.


        :param utxo_ids: The utxo_ids of this ContractFnRequest.  # noqa: E501
        :type utxo_ids: list[str]
        """

        self._utxo_ids = utxo_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContractFnRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContractFnRequest):
            return True

        return self.to_dict() != other.to_dict()
