# Generated by Django 3.0.3 on 2020-03-18 10:54

import django.contrib.postgres.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="QuizQuestion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("SC", "Single Choice"),
                            ("MC", "Multiple Choice"),
                            ("DD", "Drag and Drop"),
                            ("RG", "Ranking"),
                            ("HS", "Hotspot"),
                        ],
                        max_length=2,
                    ),
                ),
                (
                    "difficulty",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, "Neuling"),
                            (2, "Einsteiger"),
                            (3, "Fortgeschrittener"),
                            (4, "Erfahrener"),
                            (5, "Experte"),
                        ]
                    ),
                ),
                ("text", models.TextField()),
                ("img", models.ImageField(blank=True, null=True, upload_to="quiz/")),
                ("img_alt", models.CharField(blank=True, default="", max_length=200)),
                (
                    "tags",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=100),
                        blank=True,
                        default=list,
                        help_text="If you want to add more than one tag, seperate them with commas.",
                        size=None,
                    ),
                ),
            ],
        ),
    ]
