#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.threads',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200718',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'threading and communication/synchronisation conveniences',
  long_description =
    ('Thread related convenience classes and functions.\n'    
 '\n'    
 '*Latest release 20200718*:\n'    
 '@locked: apply the interior __doc__ to the wrapper.\n'    
 '\n'    
 '## Class `AdjustableSemaphore`\n'    
 '\n'    
 'A semaphore whose value may be tuned after instantiation.\n'    
 '\n'    
 '### Method `AdjustableSemaphore.acquire(self, blocking=True)`\n'    
 '\n'    
 'The acquire() method calls the base acquire() method if not blocking.\n'    
 'If blocking is true, the base acquire() is called inside a lock to\n'    
 'avoid competing with a reducing adjust().\n'    
 '\n'    
 '### Method `AdjustableSemaphore.adjust(self, newvalue)`\n'    
 '\n'    
 'Set capacity to `newvalue`\n'    
 'by calling release() or acquire() an appropriate number of times.\n'    
 '\n'    
 'If `newvalue` lowers the semaphore capacity then adjust()\n'    
 'may block until the overcapacity is released.\n'    
 '\n'    
 '### Method `AdjustableSemaphore.adjust_delta(self, delta)`\n'    
 '\n'    
 'Adjust capacity by `delta` by calling release() or acquire()\n'    
 'an appropriate number of times.\n'    
 '\n'    
 'If `delta` lowers the semaphore capacity then adjust() may block\n'    
 'until the overcapacity is released.\n'    
 '\n'    
 '### Method `AdjustableSemaphore.release(self)`\n'    
 '\n'    
 'Release the semaphore.\n'    
 '\n'    
 '## Class `LockableMixin`\n'    
 '\n'    
 'Trite mixin to control access to an object via its ._lock attribute.\n'    
 'Exposes the ._lock as the property .lock.\n'    
 "Presents a context manager interface for obtaining an object's lock.\n"    
 '\n'    
 '## Class `PriorityLock`\n'    
 '\n'    
 'A priority based mutex which is acquired by and released to waiters\n'    
 'in priority order.\n'    
 '\n'    
 'The initialiser sets a default priority, itself defaulting to `0`.\n'    
 '\n'    
 'The `acquire()` method accepts an optional `priority` value\n'    
 'which specifies the priority of the acquire request;\n'    
 'lower values have higher priorities.\n'    
 '`acquire` returns a new `PriorityLockSubLock`.\n'    
 '\n'    
 'Note that internally this allocates a `threading.Lock` per acquirer.\n'    
 '\n'    
 'When `acquire` is called, if the `PriorityLock` is taken\n'    
 'then the acquirer blocks on their personal `Lock`.\n'    
 '\n'    
 'When `release()` is called the highest priority `Lock` is released.\n'    
 '\n'    
 'Within a priority level `acquire`s are served in FIFO order.\n'    
 '\n'    
 'Used as a context manager, the mutex is obtained at the default priority.\n'    
 'The `priority()` method offers a context manager\n'    
 'with a specified priority.\n'    
 'Both context managers return the `PriorityLockSubLock`\n'    
 'allocated by the `acquire`.\n'    
 '\n'    
 '### Method `PriorityLock.__init__(self, default_priority=0, name=None)`\n'    
 '\n'    
 'Initialise the `PriorityLock`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `default_priority`: the default `acquire` priority,\n'    
 '  default `0`.\n'    
 '* `name`: optional identifying name\n'    
 '\n'    
 '### Method `PriorityLock.__enter__(self)`\n'    
 '\n'    
 'Enter the mutex as a context manager at the default priority.\n'    
 'Returns the new `Lock`.\n'    
 '\n'    
 '### Method `PriorityLock.__exit__(self, *_)`\n'    
 '\n'    
 'Exit the context manager.\n'    
 '\n'    
 '### Method `PriorityLock.acquire(self, priority=None)`\n'    
 '\n'    
 'Acquire the mutex with `priority` (default from `default_priority`).\n'    
 'Return the new `PriorityLockSubLock`.\n'    
 '\n'    
 'This blocks behind any higher priority `acquire`s\n'    
 'or any earlier `acquire`s of the same priority.\n'    
 '\n'    
 '### Method `PriorityLock.priority(self, this_priority)`\n'    
 '\n'    
 'A context manager with the specified `this_priority`.\n'    
 'Returns the new `Lock`.\n'    
 '\n'    
 '### Method `PriorityLock.release(self)`\n'    
 '\n'    
 'Release the mutex.\n'    
 '\n'    
 'Internally, this releases the highest priority `Lock`,\n'    
 'allowing that `acquire`r to go forward.\n'    
 '\n'    
 '## Class `PriorityLockSubLock(PriorityLockSubLock,builtins.tuple)`\n'    
 '\n'    
 'The record for the per-`acquire`r `Lock` held by `PriorityLock.acquire`.\n'    
 '\n'    
 '## Class `WTPoolEntry(builtins.tuple)`\n'    
 '\n'    
 'WTPoolEntry(thread, queue)\n'    
 '\n'    
 '## Class `WorkerThreadPool(cs.resources.MultiOpenMixin)`\n'    
 '\n'    
 'A pool of worker threads to run functions.\n'    
 '\n'    
 '### Method `WorkerThreadPool.__init__(self, name=None, max_spare=4)`\n'    
 '\n'    
 'Initialise the WorkerThreadPool.\n'    
 '\n'    
 'Parameters:\n'    
 '* `name`: optional name for the pool\n'    
 '* `max_spare`: maximum size of each idle pool (daemon and non-daemon)\n'    
 '\n'    
 '### Method `WorkerThreadPool.dispatch(self, *a, **kw)`\n'    
 '\n'    
 'Wrapper function to check that this instance is not closed.\n'    
 '\n'    
 '### Method `WorkerThreadPool.join(self)`\n'    
 '\n'    
 'Wait for all outstanding Threads to complete.\n'    
 '\n'    
 '### Method `WorkerThreadPool.shutdown(self)`\n'    
 '\n'    
 'Shut down the pool.\n'    
 '\n'    
 'Close all the request queues.\n'    
 '\n'    
 'Note: does not wait for all Threads to complete; call .join after close.\n'    
 '\n'    
 '### Method `WorkerThreadPool.startup(self)`\n'    
 '\n'    
 'Start the pool.\n'    
 '\n'    
 '## Function `bg(func, daemon=None, name=None, no_start=False, '    
 'no_logexc=False, args=None, kwargs=None)`\n'    
 '\n'    
 'Dispatch the callable `func` in its own `Thread`;\n'    
 'return the `Thread`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `func`: a callable for the `Thread` target.\n'    
 '* `daemon`: optional argument specifying the `.daemon` attribute.\n'    
 '* `name`: optional argument specifying the `Thread` name,\n'    
 '  default: the name of `func`.\n'    
 '* `no_start`: optional argument, default `False`.\n'    
 '  If true, do not start the `Thread`.\n'    
 '* `no_logexc`: if false (default `False`), wrap `func` in `@logexc`.\n'    
 '* `args`, `kwargs`: passed to the `Thread` constructor\n'    
 '\n'    
 '## Function `locked(*da, **dkw)`\n'    
 '\n'    
 'A decorator for instance methods that must run within a lock.\n'    
 '\n'    
 'Decorator keyword arguments:\n'    
 '* `initial_timeout`:\n'    
 '  the initial lock attempt timeout;\n'    
 '  if this is `>0` and exceeded a warning is issued\n'    
 '  and then an indefinite attempt is made.\n'    
 '  Default: `2.0`s\n'    
 '* `lockattr`:\n'    
 '  the name of the attribute of `self`\n'    
 '  which references the lock object.\n'    
 "  Default `'_lock'`\n"    
 '\n'    
 '## Function `locked_property(*da, **dkw)`\n'    
 '\n'    
 'A thread safe property whose value is cached.\n'    
 'The lock is taken if the value needs to computed.\n'    
 '\n'    
 'The default lock attribute is `._lock`.\n'    
 'The default attribute for the cached value is `._`funcname\n'    
 'where funcname is `func.__name__`.\n'    
 'The default "unset" value for the cache is `None`.\n'    
 '\n'    
 '## Function `via(cmanager, func, *a, **kw)`\n'    
 '\n'    
 'Return a callable that calls the supplied `func` inside a\n'    
 'with statement using the context manager `cmanager`.\n'    
 'This intended use case is aimed at deferred function calls.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20200718*:\n'    
 '@locked: apply the interior __doc__ to the wrapper.\n'    
 '\n'    
 '*Release 20200521*:\n'    
 '@locked_property: decorate with @cs.deco.decorator to support keyword '    
 'arguments.\n'    
 '\n'    
 '*Release 20191102*:\n'    
 '@locked: report slow-to-acquire locks, add initial_timeout and lockattr '    
 'decorator keyword parameters.\n'    
 '\n'    
 '*Release 20190923.2*:\n'    
 'Fix annoying docstring typo.\n'    
 '\n'    
 '*Release 20190923.1*:\n'    
 'Docstring updates.\n'    
 '\n'    
 '*Release 20190923*:\n'    
 'Remove dependence on cs.obj.\n'    
 '\n'    
 '*Release 20190921*:\n'    
 'New PriorityLock class for a mutex which releases in (priority,fifo) order.\n'    
 '\n'    
 '*Release 20190812*:\n'    
 'bg: compute default name before wrapping `func` in @logexc.\n'    
 '\n'    
 '*Release 20190729*:\n'    
 'bg: provide default `name`, run callable inside Pfx, add optional '    
 'no_logexc=False param preventing @logec wrapper if true.\n'    
 '\n'    
 '*Release 20190422*:\n'    
 'bg(): new optional `no_start=False` keyword argument, preventing '    
 'Thread.start if true\n'    
 '\n'    
 '*Release 20190102*:\n'    
 '* Drop some unused classes.\n'    
 '* New LockableMixin, presenting a context manager and a .lock property.\n'    
 '\n'    
 '*Release 20160828*:\n'    
 'Use "install_requires" instead of "requires" in DISTINFO.\n'    
 '\n'    
 '*Release 20160827*:\n'    
 '* Replace bare "excepts" with "except BaseException".\n'    
 '* Doc updates. Other minor improvements.\n'    
 '\n'    
 '*Release 20150115*:\n'    
 'First PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.deco', 'cs.excutils', 'cs.logutils', 'cs.pfx', 'cs.py.func', 'cs.py3', 'cs.queues', 'cs.seq'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.threads'],
)
