/**
 * @license
 * Copyright 2018-2021 Streamlit Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Table, Vector } from "apache-arrow";
import { StructRow } from "apache-arrow/vector/row";
export declare type CellType = "blank" | "index" | "columns" | "data";
/** Data types used by ArrowJS. */
export declare type DataType = null | boolean | number | string | Date | Int32Array | Uint8Array | Vector | StructRow;
export interface ArrowDataframeProto {
    data: ArrowTableProto;
    height: string;
    width: string;
}
export interface ArrowTableProto {
    data: Uint8Array;
    index: Uint8Array;
    columns: Uint8Array;
    styler?: Styler;
}
export interface Cell {
    classNames: string;
    content: DataType;
    id?: string;
    type: CellType;
}
export interface Styler {
    caption?: string;
    displayValuesTable: Table;
    styles?: string;
    uuid: string;
}
export declare class ArrowTable {
    private readonly dataTable;
    private readonly indexTable;
    private readonly columnsTable;
    private readonly styler?;
    constructor(dataBuffer: Uint8Array, indexBuffer: Uint8Array, columnsBuffer: Uint8Array, styler?: any);
    get rows(): number;
    get columns(): number;
    get headerRows(): number;
    get headerColumns(): number;
    get dataRows(): number;
    get dataColumns(): number;
    get uuid(): string | undefined;
    get caption(): string | undefined;
    get styles(): string | undefined;
    get table(): Table;
    get index(): Table;
    get columnTable(): Table;
    getCell: (rowIndex: number, columnIndex: number) => Cell;
    getContent: (table: Table<any>, rowIndex: number, columnIndex: number) => DataType;
    /**
     * Serialize arrow table.
     */
    serialize(): ArrowTableProto;
    /**
     * Returns apache-arrow specific typeId of column.
     */
    private getColumnTypeId;
    private nanosToDate;
}
