"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const config_file_1 = require("../config-file");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.file = new config_file_1.ConfigFile('config.json', JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlnLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3dlYmFwcC9jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsZ0RBQTRDO0FBc0U1QyxNQUFhLFlBQVk7SUFFdkIsWUFBb0MsS0FBd0I7UUFBeEIsVUFBSyxHQUFMLEtBQUssQ0FBbUI7UUFDMUQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLHdCQUFVLENBQUMsYUFBYSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFDakYsQ0FBQztJQUVELElBQVksY0FBYzs7UUFDeEIsT0FBTztZQUNMLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxZQUFZLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsbUNBQUksSUFBSTtZQUNqRCxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO1NBQ3RDLENBQUM7SUFDSixDQUFDO0lBRUQsSUFBWSxZQUFZOztRQUN0QixNQUFNLFlBQVksU0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksbUNBQUksRUFBRSxDQUFDO1FBQ25ELDhDQUE4QztRQUM5QyxPQUFPLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLGNBQWMsRUFBRSxHQUFHLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBRUQsSUFBWSxXQUFXOztRQUNyQixNQUFNLFdBQVcsU0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsbUNBQUksRUFBRSxDQUFDO1FBQ2pELGdEQUFnRDtRQUNoRCxPQUFPLFdBQVcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLFNBQVMsRUFBRSxHQUFHLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBRUQsSUFBWSxnQkFBZ0I7O1FBQzFCLE1BQU0sTUFBTSxTQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLG1DQUFJO1lBQzVDLFFBQVEsRUFBRTtnQkFDUjtvQkFDRSxJQUFJLEVBQUUsa0JBQWtCO29CQUN4QixlQUFlLEVBQUUsRUFBRTtpQkFDcEI7YUFDRjtTQUNGLENBQUM7UUFDRixLQUFLLE1BQU0sT0FBTyxJQUFJLE1BQU0sQ0FBQyxRQUFRLEVBQUU7WUFDckMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEtBQUssU0FBUyxJQUFJLE9BQU8sQ0FBQyxlQUFlLEtBQUssU0FBUyxDQUFDO2dCQUM3RSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEtBQUssU0FBUyxJQUFJLE9BQU8sQ0FBQyxlQUFlLEtBQUssU0FBUyxDQUFDLEVBQUU7Z0JBQ2pGLE1BQU0sSUFBSSxLQUFLLENBQUMsMEVBQTBFLENBQUMsQ0FBQzthQUM3RjtTQUNGO1FBQ0QsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztDQUNGO0FBN0NELG9DQTZDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEZlYXR1cmVkUGFja2FnZXMsIEZlYXR1cmVGbGFncywgUGFja2FnZUxpbmtDb25maWcgfSBmcm9tICcuJztcbmltcG9ydCB7IENvbmZpZ0ZpbGUgfSBmcm9tICcuLi9jb25maWctZmlsZSc7XG5pbXBvcnQgeyBQYWNrYWdlVGFnQ29uZmlnIH0gZnJvbSAnLi4vcGFja2FnZS10YWcnO1xuXG5pbnRlcmZhY2UgRnJvbnRlbmRQYWNrYWdlTGlua0NvbmZpZyB7XG4gIGxpbmtMYWJlbDogc3RyaW5nO1xuICBjb25maWdLZXk6IHN0cmluZztcbiAgbGlua1RleHQ/OiBzdHJpbmc7XG59XG5cbmludGVyZmFjZSBGcm9udGVuZFBhY2thZ2VUYWdDb25maWdCYXNlIHtcbiAgbGFiZWw6IHN0cmluZztcbiAgY29sb3I/OiBzdHJpbmc7XG59XG5cbmludGVyZmFjZSBGcm9udGVuZFBhY2thZ2VUYWdIaWdobGlnaHRDb25maWcgZXh0ZW5kcyBGcm9udGVuZFBhY2thZ2VUYWdDb25maWdCYXNle1xuICBpY29uPzogc3RyaW5nO1xufVxuXG5pbnRlcmZhY2UgRnJvbnRlbmRQYWNrYWdlVGFnU2VhcmNoRmlsdGVyQ29uZmlnIHtcbiAgZGlzcGxheTogc3RyaW5nO1xuICBncm91cEJ5OiBzdHJpbmc7XG59XG5cbmludGVyZmFjZSBGcm9udGVuZFBhY2thZ2VUYWdDb25maWcge1xuICBpZDogc3RyaW5nO1xuICBrZXl3b3JkPzogRnJvbnRlbmRQYWNrYWdlVGFnQ29uZmlnQmFzZTtcbiAgaGlnaGxpZ2h0PzogRnJvbnRlbmRQYWNrYWdlVGFnSGlnaGxpZ2h0Q29uZmlnO1xuICBzZWFyY2hGaWx0ZXI/OiBGcm9udGVuZFBhY2thZ2VUYWdTZWFyY2hGaWx0ZXJDb25maWc7XG59XG5cbnR5cGUgRnJvbnRlbmRGZWF0dXJlZFBhY2thZ2VzQ29uZmlnID0gRmVhdHVyZWRQYWNrYWdlcztcblxuaW50ZXJmYWNlIEZyb250ZW5kQ29uZmlnIHtcbiAgcGFja2FnZUxpbmtzPzogRnJvbnRlbmRQYWNrYWdlTGlua0NvbmZpZ1tdO1xuICBwYWNrYWdlVGFncz86IEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZ1tdO1xuICBmZWF0dXJlZFBhY2thZ2VzPzogRnJvbnRlbmRGZWF0dXJlZFBhY2thZ2VzQ29uZmlnO1xuICBwYWNrYWdlU3RhdHM/OiBib29sZWFuO1xuICBmZWF0dXJlRmxhZ3M/OiBGZWF0dXJlRmxhZ3M7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgV2ViYXBwQ29uZmlnUHJvcHMge1xuICAvKipcbiAgICogQ29uZmlndXJhdGlvbiBmb3IgY3VzdG9tIHBhY2thZ2UgcGFnZSBsaW5rcy5cbiAgICovXG4gIHJlYWRvbmx5IHBhY2thZ2VMaW5rcz86IFBhY2thZ2VMaW5rQ29uZmlnW107XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyYXRpb24gZm9yIGN1c3RvbSBjb21wdXRlZCB0YWdzLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFja2FnZVRhZ3M/OiBQYWNrYWdlVGFnQ29uZmlnW107XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyYXRpb24gZm9yIHBhY2thZ2VzIHRvIGZlYXR1cmUgb24gdGhlIGhvbWUgcGFnZS5cbiAgICogQGRlZmF1bHQgLSBEaXNwbGF5IHRoZSAxMCBtb3N0IHJlY2VudGx5IHVwZGF0ZWQgcGFja2FnZXNcbiAgICovXG4gIHJlYWRvbmx5IGZlYXR1cmVkUGFja2FnZXM/OiBGZWF0dXJlZFBhY2thZ2VzO1xuXG4gIC8qKlxuICAgKiBDb25maWd1cmUgZmVhdHVyZSBmbGFncyBmb3IgdGhlIHdlYiBhcHAuXG4gICAqL1xuICByZWFkb25seSBmZWF0dXJlRmxhZ3M/OiBGZWF0dXJlRmxhZ3M7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gZGlzcGxheSBwYWNrYWdlIHN0YXRzIGZyb20gYHN0YXRzLmpzb25gIG9uXG4gICAqIHBhY2thZ2UgY2FyZHMuXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHNob3dQYWNrYWdlU3RhdHM/OiBib29sZWFuO1xufVxuXG5leHBvcnQgY2xhc3MgV2ViYXBwQ29uZmlnIHtcbiAgcHVibGljIHJlYWRvbmx5IGZpbGU6IENvbmZpZ0ZpbGU7XG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBXZWJhcHBDb25maWdQcm9wcykge1xuICAgIHRoaXMuZmlsZSA9IG5ldyBDb25maWdGaWxlKCdjb25maWcuanNvbicsIEpTT04uc3RyaW5naWZ5KHRoaXMuZnJvbnRlbmRDb25maWcpKTtcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IGZyb250ZW5kQ29uZmlnKCk6IEZyb250ZW5kQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgcGFja2FnZUxpbmtzOiB0aGlzLnBhY2thZ2VMaW5rcyxcbiAgICAgIHBhY2thZ2VUYWdzOiB0aGlzLnBhY2thZ2VUYWdzLFxuICAgICAgZmVhdHVyZWRQYWNrYWdlczogdGhpcy5mZWF0dXJlZFBhY2thZ2VzLFxuICAgICAgcGFja2FnZVN0YXRzOiB0aGlzLnByb3BzLnNob3dQYWNrYWdlU3RhdHMgPz8gdHJ1ZSxcbiAgICAgIGZlYXR1cmVGbGFnczogdGhpcy5wcm9wcy5mZWF0dXJlRmxhZ3MsXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IHBhY2thZ2VMaW5rcygpOiBGcm9udGVuZFBhY2thZ2VMaW5rQ29uZmlnW10ge1xuICAgIGNvbnN0IHBhY2thZ2VMaW5rcyA9IHRoaXMucHJvcHMucGFja2FnZUxpbmtzID8/IFtdO1xuICAgIC8vIHJlbW92ZSBhbGxvd2VkIGRvbWFpbnMgZnJvbSBmcm9udGVuZCBjb25maWdcbiAgICByZXR1cm4gcGFja2FnZUxpbmtzLm1hcCgoeyBhbGxvd2VkRG9tYWlucywgLi4ucmVzdCB9KSA9PiByZXN0KTtcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IHBhY2thZ2VUYWdzKCk6IEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZ1tdIHtcbiAgICBjb25zdCBwYWNrYWdlVGFncyA9IHRoaXMucHJvcHMucGFja2FnZVRhZ3MgPz8gW107XG4gICAgLy8gcmVtb3ZlIGNvbmRpdGlvbmFsIGxvZ2ljIGZyb20gZnJvbnRlbmQgY29uZmlnXG4gICAgcmV0dXJuIHBhY2thZ2VUYWdzLm1hcCgoeyBjb25kaXRpb24sIC4uLnJlc3QgfSkgPT4gcmVzdCk7XG4gIH1cblxuICBwcml2YXRlIGdldCBmZWF0dXJlZFBhY2thZ2VzKCk6IEZyb250ZW5kRmVhdHVyZWRQYWNrYWdlc0NvbmZpZyB7XG4gICAgY29uc3QgY29uZmlnID0gdGhpcy5wcm9wcy5mZWF0dXJlZFBhY2thZ2VzID8/IHtcbiAgICAgIHNlY3Rpb25zOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBuYW1lOiAnUmVjZW50bHkgdXBkYXRlZCcsXG4gICAgICAgICAgc2hvd0xhc3RVcGRhdGVkOiAxMCxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfTtcbiAgICBmb3IgKGNvbnN0IHNlY3Rpb24gb2YgY29uZmlnLnNlY3Rpb25zKSB7XG4gICAgICBpZiAoKHNlY3Rpb24uc2hvd1BhY2thZ2VzICE9PSB1bmRlZmluZWQgJiYgc2VjdGlvbi5zaG93TGFzdFVwZGF0ZWQgIT09IHVuZGVmaW5lZCkgfHxcbiAgICAgICAgICAoc2VjdGlvbi5zaG93UGFja2FnZXMgPT09IHVuZGVmaW5lZCAmJiBzZWN0aW9uLnNob3dMYXN0VXBkYXRlZCA9PT0gdW5kZWZpbmVkKSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0V4YWN0bHkgb25lIG9mIFxcJ3Nob3dQYWNrYWdlc1xcJyBhbmQgXFwnc2hvd1BhY2thZ2VzXFwnIHNob3VsZCBiZSBwcm92aWRlZC4nKTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIGNvbmZpZztcbiAgfVxufVxuIl19