export declare function s3(): AWS.S3;
/**
 * Checks whether an object exists in S3 at the provided bucket and key.
 */
export declare function s3ObjectExists(bucket: string, key: string): Promise<boolean>;
export declare function sqs(): AWS.SQS;
export declare function stepFunctions(): AWS.StepFunctions;
export declare function lambda(): AWS.Lambda;
export declare function codeArtifact(): AWS.CodeArtifact;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
export declare function reset(): void;
