"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const semver_1 = require("semver");
const client_lambda_shared_1 = require("../catalog-builder/client.lambda-shared");
const constants_1 = require("../shared/constants");
/**
 * This function checks whether the catalog object needs updating following the
 * ingestion of the provided package object. This is the case if the package is
 * representative of a new major version line, or if the package is newer than,
 * or at the same version than the one already in catalog for the same major
 * version line.
 *
 * This is used to reduce how many calls are made into the catalog builder
 * function, as that function runs with singleton concurrency. This ultimately
 * allows workflows to complete faster when they are targetting older versions
 * of packages.
 */
async function handler(event) {
    var _a;
    console.log(`Event: ${JSON.stringify(event, null, 2)}`);
    const [, packageName, version] = (_a = constants_1.STORAGE_KEY_FORMAT_REGEX.exec(event.package.key)) !== null && _a !== void 0 ? _a : die(`Unecpedted/invalid package key: ${event.package.key}`);
    const packageMajor = semver_1.major(version);
    const catalogClient = await client_lambda_shared_1.CatalogClient.newClient();
    const existingEntry = catalogClient.packages.find((pkg) => pkg.name === packageName && pkg.major === packageMajor);
    if (existingEntry == null) {
        return true;
    }
    return semver_1.compare(version, existingEntry.version) >= 0;
}
exports.handler = handler;
function die(message) {
    const error = new Error(message);
    Error.captureStackTrace(error, die);
    throw error;
}
//# sourceMappingURL=data:application/json;base64,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