# Primality

**Primality** helps you easily find, test and work with prime numbers in Python.

```python
primality.isprime(516349073509121311)
>> True

primality.nthprime(9999)
>> 104729

primality.prange(10)
>> [2, 3, 5, 7, 11, 13, 17, 19, 23, 29]
```

## Installation

Use the package manager pip to install Primality.

```bash
pip install primality
```

## Implementation

Primality officially supports Python 3.8+.

```python
from primality import primality
```

## Usage

**isprime(p: int)** True if {p} is prime.

```python
primality.isprime(13)
>> True
primality.isprime(20)
>> False
primality.isprime(516349073509121311)
>> True
```

**nthprime(nth: int)** Returns the {nth} prime, starting from n = 0, returning 2.

```python
primality.nthprime(0)
>> 2
primality.nthprime(100)
>> 547
primality.nthprime(9999)
>> 104729
```

**prange(n: int)** Returns a list with the form of [2, 3, ..., {n}th prime].

```python
primality.prange(3)
>> [2, 3, 5]
primality.prange(10)
>> [2, 3, 5, 7, 11, 13, 17, 19, 23, 29]
```
