"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpdxLicense = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
/* eslint-disable @typescript-eslint/member-ordering */
/**
 * Valid SPDX License identifiers.
 */
class SpdxLicense {
    //#endregion
    constructor(id) {
        this.id = id;
        /* istanbul ignore if (should never happen) */
        if (SpdxLicense._ALL.has(id)) {
            throw new Error(`Duplicated SPDX License ID: ${id}`);
        }
        SpdxLicense._ALL.set(id, this);
    }
    //#endregion
    //#region Bundles of SPDX Licenses
    /** All valid SPDX Licenses */
    static all() {
        return Array.from(SpdxLicense._ALL.values());
    }
    /** All OSI-Approved SPDX Licenses */
    static osiApproved() {
        return [
            SpdxLicense.ZERO_BSD,
            SpdxLicense.AAL,
            SpdxLicense.AFL_1_1,
            SpdxLicense.AFL_1_2,
            SpdxLicense.AFL_2_0,
            SpdxLicense.AFL_2_1,
            SpdxLicense.AFL_3_0,
            SpdxLicense.AGPL_3_0,
            SpdxLicense.AGPL_3_0_ONLY,
            SpdxLicense.AGPL_3_0_OR_LATER,
            SpdxLicense.APL_1_0,
            SpdxLicense.APSL_1_0,
            SpdxLicense.APSL_1_1,
            SpdxLicense.APSL_1_2,
            SpdxLicense.APSL_2_0,
            SpdxLicense.APACHE_1_1,
            SpdxLicense.APACHE_2_0,
            SpdxLicense.ARTISTIC_1_0,
            SpdxLicense.ARTISTIC_1_0_PERL,
            SpdxLicense.ARTISTIC_1_0_CL8,
            SpdxLicense.ARTISTIC_2_0,
            SpdxLicense.BSD_1_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE_PATENT,
            SpdxLicense.BSD_3_CLAUSE,
            SpdxLicense.BSD_3_CLAUSE_LBNL,
            SpdxLicense.BSL_1_0,
            SpdxLicense.CAL_1_0,
            SpdxLicense.CAL_1_0_COMBINED_WORK_EXCEPTION,
            SpdxLicense.CATOSL_1_1,
            SpdxLicense.CDDL_1_0,
            SpdxLicense.CECILL_2_1,
            SpdxLicense.CNRI_PYTHON,
            SpdxLicense.CPAL_1_0,
            SpdxLicense.CPL_1_0,
            SpdxLicense.CUA_OPL_1_0,
            SpdxLicense.ECL_1_0,
            SpdxLicense.ECL_2_0,
            SpdxLicense.EFL_1_0,
            SpdxLicense.EFL_2_0,
            SpdxLicense.EPL_1_0,
            SpdxLicense.EPL_2_0,
            SpdxLicense.EUDATAGRID,
            SpdxLicense.EUPL_1_1,
            SpdxLicense.EUPL_1_2,
            SpdxLicense.ENTESSA,
            SpdxLicense.FAIR,
            SpdxLicense.FRAMEWORX_1_0,
            SpdxLicense.GPL_2_0,
            SpdxLicense.GPL_2_0_PLUS,
            SpdxLicense.GPL_2_0_ONLY,
            SpdxLicense.GPL_2_0_OR_LATER,
            SpdxLicense.GPL_3_0,
            SpdxLicense.GPL_3_0_PLUS,
            SpdxLicense.GPL_3_0_ONLY,
            SpdxLicense.GPL_3_0_OR_LATER,
            SpdxLicense.GPL_3_0_WITH_GCC_EXCEPTION,
            SpdxLicense.HPND,
            SpdxLicense.IPA,
            SpdxLicense.IPL_1_0,
            SpdxLicense.ISC,
            SpdxLicense.INTEL,
            SpdxLicense.LGPL_2_0,
            SpdxLicense.LGPL_2_0_PLUS,
            SpdxLicense.LGPL_2_0_ONLY,
            SpdxLicense.LGPL_2_0_OR_LATER,
            SpdxLicense.LGPL_2_1,
            SpdxLicense.LGPL_2_1_PLUS,
            SpdxLicense.LGPL_2_1_ONLY,
            SpdxLicense.LGPL_2_1_OR_LATER,
            SpdxLicense.LGPL_3_0,
            SpdxLicense.LGPL_3_0_PLUS,
            SpdxLicense.LGPL_3_0_ONLY,
            SpdxLicense.LGPL_3_0_OR_LATER,
            SpdxLicense.LPL_1_0,
            SpdxLicense.LPL_1_02,
            SpdxLicense.LPPL_1_3C,
            SpdxLicense.LILIQ_P_1_1,
            SpdxLicense.LILIQ_R_1_1,
            SpdxLicense.LILIQ_RPLUS_1_1,
            SpdxLicense.MIT,
            SpdxLicense.MIT_0,
            SpdxLicense.MPL_1_0,
            SpdxLicense.MPL_1_1,
            SpdxLicense.MPL_2_0,
            SpdxLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION,
            SpdxLicense.MS_PL,
            SpdxLicense.MS_RL,
            SpdxLicense.MIR_O_S,
            SpdxLicense.MOTOSOTO,
            SpdxLicense.MULANPSL_2_0,
            SpdxLicense.MULTICS,
            SpdxLicense.NASA_1_3,
            SpdxLicense.NCSA,
            SpdxLicense.NGPL,
            SpdxLicense.NPOSL_3_0,
            SpdxLicense.NTP,
            SpdxLicense.NAUMEN,
            SpdxLicense.NOKIA,
            SpdxLicense.OCLC_2_0,
            SpdxLicense.OFL_1_1,
            SpdxLicense.OFL_1_1_RFN,
            SpdxLicense.OFL_1_1_NO_RFN,
            SpdxLicense.OGTSL,
            SpdxLicense.OLDAP_2_8,
            SpdxLicense.OSET_PL_2_1,
            SpdxLicense.OSL_1_0,
            SpdxLicense.OSL_2_0,
            SpdxLicense.OSL_2_1,
            SpdxLicense.OSL_3_0,
            SpdxLicense.PHP_3_0,
            SpdxLicense.PHP_3_01,
            SpdxLicense.POSTGRE_SQ_L,
            SpdxLicense.PYTHON_2_0,
            SpdxLicense.QPL_1_0,
            SpdxLicense.RPL_1_1,
            SpdxLicense.RPL_1_5,
            SpdxLicense.RPSL_1_0,
            SpdxLicense.RSCPL,
            SpdxLicense.SISSL,
            SpdxLicense.SPL_1_0,
            SpdxLicense.SIMPL_2_0,
            SpdxLicense.SLEEPYCAT,
            SpdxLicense.UCL_1_0,
            SpdxLicense.UPL_1_0,
            SpdxLicense.UNICODE_DFS_2016,
            SpdxLicense.UNLICENSE,
            SpdxLicense.VSL_1_0,
            SpdxLicense.W3_C,
            SpdxLicense.WATCOM_1_0,
            SpdxLicense.XNET,
            SpdxLicense.ZPL_2_0,
            SpdxLicense.ZLIB,
        ];
    }
    /** The Apache family of licenses */
    static apache() {
        return [
            SpdxLicense.APACHE_1_0,
            SpdxLicense.APACHE_1_1,
            SpdxLicense.APACHE_2_0,
        ];
    }
    /** The BSD family of licenses */
    static bsd() {
        return [
            SpdxLicense.ZERO_BSD,
            SpdxLicense.BSD_1_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE_FREEBSD,
            SpdxLicense.BSD_2_CLAUSE_NETBSD,
            SpdxLicense.BSD_2_CLAUSE_PATENT,
            SpdxLicense.BSD_2_CLAUSE_VIEWS,
            SpdxLicense.BSD_3_CLAUSE,
            SpdxLicense.BSD_3_CLAUSE_ATTRIBUTION,
            SpdxLicense.BSD_3_CLAUSE_CLEAR,
            SpdxLicense.BSD_3_CLAUSE_LBNL,
            SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE,
            SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014,
            SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY,
            SpdxLicense.BSD_3_CLAUSE_OPEN_MPI,
            SpdxLicense.BSD_4_CLAUSE,
            SpdxLicense.BSD_4_CLAUSE_UC,
            SpdxLicense.BSD_PROTECTION,
            SpdxLicense.BSD_SOURCE_CODE,
        ];
    }
    /** The CDDL family of licenses */
    static cddl() {
        return [
            SpdxLicense.CDDL_1_0,
            SpdxLicense.CDDL_1_1,
        ];
    }
    /** The EPL family of licenses */
    static epl() {
        return [
            SpdxLicense.EPL_1_0,
            SpdxLicense.EPL_2_0,
        ];
    }
    /** The MIT family of licenses */
    static mit() {
        return [
            SpdxLicense.AML,
            SpdxLicense.MIT,
            SpdxLicense.MIT_0,
            SpdxLicense.MIT_CMU,
            SpdxLicense.MIT_ADVERTISING,
            SpdxLicense.MIT_ENNA,
            SpdxLicense.MIT_FEH,
            SpdxLicense.MIT_OPEN_GROUP,
            SpdxLicense.MITNFA,
        ];
    }
    /** The MPL family of licenses */
    static mpl() {
        return [
            SpdxLicense.MPL_1_0,
            SpdxLicense.MPL_1_1,
            SpdxLicense.MPL_2_0,
            SpdxLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION,
        ];
    }
}
exports.SpdxLicense = SpdxLicense;
_a = JSII_RTTI_SYMBOL_1;
SpdxLicense[_a] = { fqn: "construct-hub.SpdxLicense", version: "0.3.255" };
SpdxLicense._ALL = new Map();
//#region Individual SPDX Licenses
/**
 * BSD Zero Clause License
 *
 * @osiApproved
 *
 * @see http://landley.net/toybox/license.html
 */
SpdxLicense.ZERO_BSD = new SpdxLicense('0BSD');
/**
 * Attribution Assurance License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/attribution
 */
SpdxLicense.AAL = new SpdxLicense('AAL');
/**
 * Amazon Digital Services License
 *
 * @see https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense
 */
SpdxLicense.ADSL = new SpdxLicense('ADSL');
/**
 * Academic Free License v1.1
 *
 * @osiApproved
 *
 * @see http://opensource.linux-mirror.org/licenses/afl-1.1.txt
 */
SpdxLicense.AFL_1_1 = new SpdxLicense('AFL-1.1');
/**
 * Academic Free License v1.2
 *
 * @osiApproved
 *
 * @see http://opensource.linux-mirror.org/licenses/afl-1.2.txt
 */
SpdxLicense.AFL_1_2 = new SpdxLicense('AFL-1.2');
/**
 * Academic Free License v2.0
 *
 * @osiApproved
 *
 * @see http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt
 */
SpdxLicense.AFL_2_0 = new SpdxLicense('AFL-2.0');
/**
 * Academic Free License v2.1
 *
 * @osiApproved
 *
 * @see http://opensource.linux-mirror.org/licenses/afl-2.1.txt
 */
SpdxLicense.AFL_2_1 = new SpdxLicense('AFL-2.1');
/**
 * Academic Free License v3.0
 *
 * @osiApproved
 *
 * @see http://www.rosenlaw.com/AFL3.0.htm
 */
SpdxLicense.AFL_3_0 = new SpdxLicense('AFL-3.0');
/**
 * Affero General Public License v1.0
 *
 * @see http://www.affero.org/oagpl.html
 */
SpdxLicense.AGPL_1_0 = new SpdxLicense('AGPL-1.0');
/**
 * Affero General Public License v1.0 only
 *
 * @see http://www.affero.org/oagpl.html
 */
SpdxLicense.AGPL_1_0_ONLY = new SpdxLicense('AGPL-1.0-only');
/**
 * Affero General Public License v1.0 or later
 *
 * @see http://www.affero.org/oagpl.html
 */
SpdxLicense.AGPL_1_0_OR_LATER = new SpdxLicense('AGPL-1.0-or-later');
/**
 * GNU Affero General Public License v3.0
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/agpl.txt
 */
SpdxLicense.AGPL_3_0 = new SpdxLicense('AGPL-3.0');
/**
 * GNU Affero General Public License v3.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/agpl.txt
 */
SpdxLicense.AGPL_3_0_ONLY = new SpdxLicense('AGPL-3.0-only');
/**
 * GNU Affero General Public License v3.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/agpl.txt
 */
SpdxLicense.AGPL_3_0_OR_LATER = new SpdxLicense('AGPL-3.0-or-later');
/**
 * AMD's plpa_map.c License
 *
 * @see https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License
 */
SpdxLicense.AMDPLPA = new SpdxLicense('AMDPLPA');
/**
 * Apple MIT License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Apple_MIT_License
 */
SpdxLicense.AML = new SpdxLicense('AML');
/**
 * Academy of Motion Picture Arts and Sciences BSD
 *
 * @see https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD
 */
SpdxLicense.AMPAS = new SpdxLicense('AMPAS');
/**
 * ANTLR Software Rights Notice
 *
 * @see http://www.antlr2.org/license.html
 */
SpdxLicense.ANTLR_PD = new SpdxLicense('ANTLR-PD');
/**
 * ANTLR Software Rights Notice with license fallback
 *
 * @see http://www.antlr2.org/license.html
 */
SpdxLicense.ANTLR_PD_FALLBACK = new SpdxLicense('ANTLR-PD-fallback');
/**
 * Adobe Postscript AFM License
 *
 * @see https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM
 */
SpdxLicense.APAFML = new SpdxLicense('APAFML');
/**
 * Adaptive Public License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/APL-1.0
 */
SpdxLicense.APL_1_0 = new SpdxLicense('APL-1.0');
/**
 * Apple Public Source License 1.0
 *
 * @osiApproved
 *
 * @see https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0
 */
SpdxLicense.APSL_1_0 = new SpdxLicense('APSL-1.0');
/**
 * Apple Public Source License 1.1
 *
 * @osiApproved
 *
 * @see http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE
 */
SpdxLicense.APSL_1_1 = new SpdxLicense('APSL-1.1');
/**
 * Apple Public Source License 1.2
 *
 * @osiApproved
 *
 * @see http://www.samurajdata.se/opensource/mirror/licenses/apsl.php
 */
SpdxLicense.APSL_1_2 = new SpdxLicense('APSL-1.2');
/**
 * Apple Public Source License 2.0
 *
 * @osiApproved
 *
 * @see http://www.opensource.apple.com/license/apsl/
 */
SpdxLicense.APSL_2_0 = new SpdxLicense('APSL-2.0');
/**
 * Abstyles License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Abstyles
 */
SpdxLicense.ABSTYLES = new SpdxLicense('Abstyles');
/**
 * Adobe Systems Incorporated Source Code License Agreement
 *
 * @see https://fedoraproject.org/wiki/Licensing/AdobeLicense
 */
SpdxLicense.ADOBE_2006 = new SpdxLicense('Adobe-2006');
/**
 * Adobe Glyph List License
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph
 */
SpdxLicense.ADOBE_GLYPH = new SpdxLicense('Adobe-Glyph');
/**
 * Afmparse License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Afmparse
 */
SpdxLicense.AFMPARSE = new SpdxLicense('Afmparse');
/**
 * Aladdin Free Public License
 *
 * @see http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm
 */
SpdxLicense.ALADDIN = new SpdxLicense('Aladdin');
/**
 * Apache License 1.0
 *
 * @see http://www.apache.org/licenses/LICENSE-1.0
 */
SpdxLicense.APACHE_1_0 = new SpdxLicense('Apache-1.0');
/**
 * Apache License 1.1
 *
 * @osiApproved
 *
 * @see http://apache.org/licenses/LICENSE-1.1
 */
SpdxLicense.APACHE_1_1 = new SpdxLicense('Apache-1.1');
/**
 * Apache License 2.0
 *
 * @osiApproved
 *
 * @see http://www.apache.org/licenses/LICENSE-2.0
 */
SpdxLicense.APACHE_2_0 = new SpdxLicense('Apache-2.0');
/**
 * Artistic License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Artistic-1.0
 */
SpdxLicense.ARTISTIC_1_0 = new SpdxLicense('Artistic-1.0');
/**
 * Artistic License 1.0 (Perl)
 *
 * @osiApproved
 *
 * @see http://dev.perl.org/licenses/artistic.html
 */
SpdxLicense.ARTISTIC_1_0_PERL = new SpdxLicense('Artistic-1.0-Perl');
/**
 * Artistic License 1.0 w/clause 8
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Artistic-1.0
 */
SpdxLicense.ARTISTIC_1_0_CL8 = new SpdxLicense('Artistic-1.0-cl8');
/**
 * Artistic License 2.0
 *
 * @osiApproved
 *
 * @see http://www.perlfoundation.org/artistic_license_2_0
 */
SpdxLicense.ARTISTIC_2_0 = new SpdxLicense('Artistic-2.0');
/**
 * BSD 1-Clause License
 *
 * @osiApproved
 *
 * @see https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823
 */
SpdxLicense.BSD_1_CLAUSE = new SpdxLicense('BSD-1-Clause');
/**
 * BSD 2-Clause "Simplified" License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/BSD-2-Clause
 */
SpdxLicense.BSD_2_CLAUSE = new SpdxLicense('BSD-2-Clause');
/**
 * BSD 2-Clause FreeBSD License
 *
 * @see http://www.freebsd.org/copyright/freebsd-license.html
 */
SpdxLicense.BSD_2_CLAUSE_FREEBSD = new SpdxLicense('BSD-2-Clause-FreeBSD');
/**
 * BSD 2-Clause NetBSD License
 *
 * @see http://www.netbsd.org/about/redistribution.html#default
 */
SpdxLicense.BSD_2_CLAUSE_NETBSD = new SpdxLicense('BSD-2-Clause-NetBSD');
/**
 * BSD-2-Clause Plus Patent License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/BSDplusPatent
 */
SpdxLicense.BSD_2_CLAUSE_PATENT = new SpdxLicense('BSD-2-Clause-Patent');
/**
 * BSD 2-Clause with views sentence
 *
 * @see http://www.freebsd.org/copyright/freebsd-license.html
 */
SpdxLicense.BSD_2_CLAUSE_VIEWS = new SpdxLicense('BSD-2-Clause-Views');
/**
 * BSD 3-Clause "New" or "Revised" License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/BSD-3-Clause
 */
SpdxLicense.BSD_3_CLAUSE = new SpdxLicense('BSD-3-Clause');
/**
 * BSD with attribution
 *
 * @see https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution
 */
SpdxLicense.BSD_3_CLAUSE_ATTRIBUTION = new SpdxLicense('BSD-3-Clause-Attribution');
/**
 * BSD 3-Clause Clear License
 *
 * @see http://labs.metacarta.com/license-explanation.html#license
 */
SpdxLicense.BSD_3_CLAUSE_CLEAR = new SpdxLicense('BSD-3-Clause-Clear');
/**
 * Lawrence Berkeley National Labs BSD variant license
 *
 * @osiApproved
 *
 * @see https://fedoraproject.org/wiki/Licensing/LBNLBSD
 */
SpdxLicense.BSD_3_CLAUSE_LBNL = new SpdxLicense('BSD-3-Clause-LBNL');
/**
 * BSD 3-Clause No Nuclear License
 *
 * @see http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc
 */
SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE = new SpdxLicense('BSD-3-Clause-No-Nuclear-License');
/**
 * BSD 3-Clause No Nuclear License 2014
 *
 * @see https://java.net/projects/javaeetutorial/pages/BerkeleyLicense
 */
SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014 = new SpdxLicense('BSD-3-Clause-No-Nuclear-License-2014');
/**
 * BSD 3-Clause No Nuclear Warranty
 *
 * @see https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt
 */
SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY = new SpdxLicense('BSD-3-Clause-No-Nuclear-Warranty');
/**
 * BSD 3-Clause Open MPI variant
 *
 * @see https://www.open-mpi.org/community/license.php
 */
SpdxLicense.BSD_3_CLAUSE_OPEN_MPI = new SpdxLicense('BSD-3-Clause-Open-MPI');
/**
 * BSD 4-Clause "Original" or "Old" License
 *
 * @see http://directory.fsf.org/wiki/License:BSD_4Clause
 */
SpdxLicense.BSD_4_CLAUSE = new SpdxLicense('BSD-4-Clause');
/**
 * BSD-4-Clause (University of California-Specific)
 *
 * @see http://www.freebsd.org/copyright/license.html
 */
SpdxLicense.BSD_4_CLAUSE_UC = new SpdxLicense('BSD-4-Clause-UC');
/**
 * BSD Protection License
 *
 * @see https://fedoraproject.org/wiki/Licensing/BSD_Protection_License
 */
SpdxLicense.BSD_PROTECTION = new SpdxLicense('BSD-Protection');
/**
 * BSD Source Code Attribution
 *
 * @see https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt
 */
SpdxLicense.BSD_SOURCE_CODE = new SpdxLicense('BSD-Source-Code');
/**
 * Boost Software License 1.0
 *
 * @osiApproved
 *
 * @see http://www.boost.org/LICENSE_1_0.txt
 */
SpdxLicense.BSL_1_0 = new SpdxLicense('BSL-1.0');
/**
 * Business Source License 1.1
 *
 * @see https://mariadb.com/bsl11/
 */
SpdxLicense.BUSL_1_1 = new SpdxLicense('BUSL-1.1');
/**
 * Bahyph License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Bahyph
 */
SpdxLicense.BAHYPH = new SpdxLicense('Bahyph');
/**
 * Barr License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Barr
 */
SpdxLicense.BARR = new SpdxLicense('Barr');
/**
 * Beerware License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Beerware
 */
SpdxLicense.BEERWARE = new SpdxLicense('Beerware');
/**
 * BitTorrent Open Source License v1.0
 *
 * @see http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s
 */
SpdxLicense.BITTORRENT_1_0 = new SpdxLicense('BitTorrent-1.0');
/**
 * BitTorrent Open Source License v1.1
 *
 * @see http://directory.fsf.org/wiki/License:BitTorrentOSL1.1
 */
SpdxLicense.BITTORRENT_1_1 = new SpdxLicense('BitTorrent-1.1');
/**
 * Blue Oak Model License 1.0.0
 *
 * @see https://blueoakcouncil.org/license/1.0.0
 */
SpdxLicense.BLUEOAK_1_0_0 = new SpdxLicense('BlueOak-1.0.0');
/**
 * Borceux license
 *
 * @see https://fedoraproject.org/wiki/Licensing/Borceux
 */
SpdxLicense.BORCEUX = new SpdxLicense('Borceux');
/**
 * Cryptographic Autonomy License 1.0
 *
 * @osiApproved
 *
 * @see http://cryptographicautonomylicense.com/license-text.html
 */
SpdxLicense.CAL_1_0 = new SpdxLicense('CAL-1.0');
/**
 * Cryptographic Autonomy License 1.0 (Combined Work Exception)
 *
 * @osiApproved
 *
 * @see http://cryptographicautonomylicense.com/license-text.html
 */
SpdxLicense.CAL_1_0_COMBINED_WORK_EXCEPTION = new SpdxLicense('CAL-1.0-Combined-Work-Exception');
/**
 * Computer Associates Trusted Open Source License 1.1
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/CATOSL-1.1
 */
SpdxLicense.CATOSL_1_1 = new SpdxLicense('CATOSL-1.1');
/**
 * Creative Commons Attribution 1.0 Generic
 *
 * @see https://creativecommons.org/licenses/by/1.0/legalcode
 */
SpdxLicense.CC_BY_1_0 = new SpdxLicense('CC-BY-1.0');
/**
 * Creative Commons Attribution 2.0 Generic
 *
 * @see https://creativecommons.org/licenses/by/2.0/legalcode
 */
SpdxLicense.CC_BY_2_0 = new SpdxLicense('CC-BY-2.0');
/**
 * Creative Commons Attribution 2.5 Generic
 *
 * @see https://creativecommons.org/licenses/by/2.5/legalcode
 */
SpdxLicense.CC_BY_2_5 = new SpdxLicense('CC-BY-2.5');
/**
 * Creative Commons Attribution 3.0 Unported
 *
 * @see https://creativecommons.org/licenses/by/3.0/legalcode
 */
SpdxLicense.CC_BY_3_0 = new SpdxLicense('CC-BY-3.0');
/**
 * Creative Commons Attribution 3.0 Austria
 *
 * @see https://creativecommons.org/licenses/by/3.0/at/legalcode
 */
SpdxLicense.CC_BY_3_0_AT = new SpdxLicense('CC-BY-3.0-AT');
/**
 * Creative Commons Attribution 3.0 United States
 *
 * @see https://creativecommons.org/licenses/by/3.0/us/legalcode
 */
SpdxLicense.CC_BY_3_0_US = new SpdxLicense('CC-BY-3.0-US');
/**
 * Creative Commons Attribution 4.0 International
 *
 * @see https://creativecommons.org/licenses/by/4.0/legalcode
 */
SpdxLicense.CC_BY_4_0 = new SpdxLicense('CC-BY-4.0');
/**
 * Creative Commons Attribution Non Commercial 1.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc/1.0/legalcode
 */
SpdxLicense.CC_BY_NC_1_0 = new SpdxLicense('CC-BY-NC-1.0');
/**
 * Creative Commons Attribution Non Commercial 2.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc/2.0/legalcode
 */
SpdxLicense.CC_BY_NC_2_0 = new SpdxLicense('CC-BY-NC-2.0');
/**
 * Creative Commons Attribution Non Commercial 2.5 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc/2.5/legalcode
 */
SpdxLicense.CC_BY_NC_2_5 = new SpdxLicense('CC-BY-NC-2.5');
/**
 * Creative Commons Attribution Non Commercial 3.0 Unported
 *
 * @see https://creativecommons.org/licenses/by-nc/3.0/legalcode
 */
SpdxLicense.CC_BY_NC_3_0 = new SpdxLicense('CC-BY-NC-3.0');
/**
 * Creative Commons Attribution Non Commercial 4.0 International
 *
 * @see https://creativecommons.org/licenses/by-nc/4.0/legalcode
 */
SpdxLicense.CC_BY_NC_4_0 = new SpdxLicense('CC-BY-NC-4.0');
/**
 * Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode
 */
SpdxLicense.CC_BY_NC_ND_1_0 = new SpdxLicense('CC-BY-NC-ND-1.0');
/**
 * Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode
 */
SpdxLicense.CC_BY_NC_ND_2_0 = new SpdxLicense('CC-BY-NC-ND-2.0');
/**
 * Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode
 */
SpdxLicense.CC_BY_NC_ND_2_5 = new SpdxLicense('CC-BY-NC-ND-2.5');
/**
 * Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode
 */
SpdxLicense.CC_BY_NC_ND_3_0 = new SpdxLicense('CC-BY-NC-ND-3.0');
/**
 * Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/3.0/igo/legalcode
 */
SpdxLicense.CC_BY_NC_ND_3_0_IGO = new SpdxLicense('CC-BY-NC-ND-3.0-IGO');
/**
 * Creative Commons Attribution Non Commercial No Derivatives 4.0 International
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode
 */
SpdxLicense.CC_BY_NC_ND_4_0 = new SpdxLicense('CC-BY-NC-ND-4.0');
/**
 * Creative Commons Attribution Non Commercial Share Alike 1.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode
 */
SpdxLicense.CC_BY_NC_SA_1_0 = new SpdxLicense('CC-BY-NC-SA-1.0');
/**
 * Creative Commons Attribution Non Commercial Share Alike 2.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode
 */
SpdxLicense.CC_BY_NC_SA_2_0 = new SpdxLicense('CC-BY-NC-SA-2.0');
/**
 * Creative Commons Attribution Non Commercial Share Alike 2.5 Generic
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode
 */
SpdxLicense.CC_BY_NC_SA_2_5 = new SpdxLicense('CC-BY-NC-SA-2.5');
/**
 * Creative Commons Attribution Non Commercial Share Alike 3.0 Unported
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
 */
SpdxLicense.CC_BY_NC_SA_3_0 = new SpdxLicense('CC-BY-NC-SA-3.0');
/**
 * Creative Commons Attribution Non Commercial Share Alike 4.0 International
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode
 */
SpdxLicense.CC_BY_NC_SA_4_0 = new SpdxLicense('CC-BY-NC-SA-4.0');
/**
 * Creative Commons Attribution No Derivatives 1.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nd/1.0/legalcode
 */
SpdxLicense.CC_BY_ND_1_0 = new SpdxLicense('CC-BY-ND-1.0');
/**
 * Creative Commons Attribution No Derivatives 2.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-nd/2.0/legalcode
 */
SpdxLicense.CC_BY_ND_2_0 = new SpdxLicense('CC-BY-ND-2.0');
/**
 * Creative Commons Attribution No Derivatives 2.5 Generic
 *
 * @see https://creativecommons.org/licenses/by-nd/2.5/legalcode
 */
SpdxLicense.CC_BY_ND_2_5 = new SpdxLicense('CC-BY-ND-2.5');
/**
 * Creative Commons Attribution No Derivatives 3.0 Unported
 *
 * @see https://creativecommons.org/licenses/by-nd/3.0/legalcode
 */
SpdxLicense.CC_BY_ND_3_0 = new SpdxLicense('CC-BY-ND-3.0');
/**
 * Creative Commons Attribution No Derivatives 4.0 International
 *
 * @see https://creativecommons.org/licenses/by-nd/4.0/legalcode
 */
SpdxLicense.CC_BY_ND_4_0 = new SpdxLicense('CC-BY-ND-4.0');
/**
 * Creative Commons Attribution Share Alike 1.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-sa/1.0/legalcode
 */
SpdxLicense.CC_BY_SA_1_0 = new SpdxLicense('CC-BY-SA-1.0');
/**
 * Creative Commons Attribution Share Alike 2.0 Generic
 *
 * @see https://creativecommons.org/licenses/by-sa/2.0/legalcode
 */
SpdxLicense.CC_BY_SA_2_0 = new SpdxLicense('CC-BY-SA-2.0');
/**
 * Creative Commons Attribution Share Alike 2.0 England and Wales
 *
 * @see https://creativecommons.org/licenses/by-sa/2.0/uk/legalcode
 */
SpdxLicense.CC_BY_SA_2_0_UK = new SpdxLicense('CC-BY-SA-2.0-UK');
/**
 * Creative Commons Attribution Share Alike 2.5 Generic
 *
 * @see https://creativecommons.org/licenses/by-sa/2.5/legalcode
 */
SpdxLicense.CC_BY_SA_2_5 = new SpdxLicense('CC-BY-SA-2.5');
/**
 * Creative Commons Attribution Share Alike 3.0 Unported
 *
 * @see https://creativecommons.org/licenses/by-sa/3.0/legalcode
 */
SpdxLicense.CC_BY_SA_3_0 = new SpdxLicense('CC-BY-SA-3.0');
/**
 * Creative Commons Attribution-Share Alike 3.0 Austria
 *
 * @see https://creativecommons.org/licenses/by-sa/3.0/at/legalcode
 */
SpdxLicense.CC_BY_SA_3_0_AT = new SpdxLicense('CC-BY-SA-3.0-AT');
/**
 * Creative Commons Attribution Share Alike 4.0 International
 *
 * @see https://creativecommons.org/licenses/by-sa/4.0/legalcode
 */
SpdxLicense.CC_BY_SA_4_0 = new SpdxLicense('CC-BY-SA-4.0');
/**
 * Creative Commons Public Domain Dedication and Certification
 *
 * @see https://creativecommons.org/licenses/publicdomain/
 */
SpdxLicense.CC_PDDC = new SpdxLicense('CC-PDDC');
/**
 * Creative Commons Zero v1.0 Universal
 *
 * @see https://creativecommons.org/publicdomain/zero/1.0/legalcode
 */
SpdxLicense.CC0_1_0 = new SpdxLicense('CC0-1.0');
/**
 * Common Development and Distribution License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/cddl1
 */
SpdxLicense.CDDL_1_0 = new SpdxLicense('CDDL-1.0');
/**
 * Common Development and Distribution License 1.1
 *
 * @see http://glassfish.java.net/public/CDDL+GPL_1_1.html
 */
SpdxLicense.CDDL_1_1 = new SpdxLicense('CDDL-1.1');
/**
 * Community Data License Agreement Permissive 1.0
 *
 * @see https://cdla.io/permissive-1-0
 */
SpdxLicense.CDLA_PERMISSIVE_1_0 = new SpdxLicense('CDLA-Permissive-1.0');
/**
 * Community Data License Agreement Sharing 1.0
 *
 * @see https://cdla.io/sharing-1-0
 */
SpdxLicense.CDLA_SHARING_1_0 = new SpdxLicense('CDLA-Sharing-1.0');
/**
 * CeCILL Free Software License Agreement v1.0
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html
 */
SpdxLicense.CECILL_1_0 = new SpdxLicense('CECILL-1.0');
/**
 * CeCILL Free Software License Agreement v1.1
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html
 */
SpdxLicense.CECILL_1_1 = new SpdxLicense('CECILL-1.1');
/**
 * CeCILL Free Software License Agreement v2.0
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
 */
SpdxLicense.CECILL_2_0 = new SpdxLicense('CECILL-2.0');
/**
 * CeCILL Free Software License Agreement v2.1
 *
 * @osiApproved
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html
 */
SpdxLicense.CECILL_2_1 = new SpdxLicense('CECILL-2.1');
/**
 * CeCILL-B Free Software License Agreement
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 */
SpdxLicense.CECILL_B = new SpdxLicense('CECILL-B');
/**
 * CeCILL-C Free Software License Agreement
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html
 */
SpdxLicense.CECILL_C = new SpdxLicense('CECILL-C');
/**
 * CERN Open Hardware Licence v1.1
 *
 * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1
 */
SpdxLicense.CERN_OHL_1_1 = new SpdxLicense('CERN-OHL-1.1');
/**
 * CERN Open Hardware Licence v1.2
 *
 * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2
 */
SpdxLicense.CERN_OHL_1_2 = new SpdxLicense('CERN-OHL-1.2');
/**
 * CERN Open Hardware Licence Version 2 - Permissive
 *
 * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
 */
SpdxLicense.CERN_OHL_P_2_0 = new SpdxLicense('CERN-OHL-P-2.0');
/**
 * CERN Open Hardware Licence Version 2 - Strongly Reciprocal
 *
 * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
 */
SpdxLicense.CERN_OHL_S_2_0 = new SpdxLicense('CERN-OHL-S-2.0');
/**
 * CERN Open Hardware Licence Version 2 - Weakly Reciprocal
 *
 * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
 */
SpdxLicense.CERN_OHL_W_2_0 = new SpdxLicense('CERN-OHL-W-2.0');
/**
 * CNRI Jython License
 *
 * @see http://www.jython.org/license.html
 */
SpdxLicense.CNRI_JYTHON = new SpdxLicense('CNRI-Jython');
/**
 * CNRI Python License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/CNRI-Python
 */
SpdxLicense.CNRI_PYTHON = new SpdxLicense('CNRI-Python');
/**
 * CNRI Python Open Source GPL Compatible License Agreement
 *
 * @see http://www.python.org/download/releases/1.6.1/download_win/
 */
SpdxLicense.CNRI_PYTHON_GPL_COMPATIBLE = new SpdxLicense('CNRI-Python-GPL-Compatible');
/**
 * Common Public Attribution License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/CPAL-1.0
 */
SpdxLicense.CPAL_1_0 = new SpdxLicense('CPAL-1.0');
/**
 * Common Public License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/CPL-1.0
 */
SpdxLicense.CPL_1_0 = new SpdxLicense('CPL-1.0');
/**
 * Code Project Open License 1.02
 *
 * @see http://www.codeproject.com/info/cpol10.aspx
 */
SpdxLicense.CPOL_1_02 = new SpdxLicense('CPOL-1.02');
/**
 * CUA Office Public License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/CUA-OPL-1.0
 */
SpdxLicense.CUA_OPL_1_0 = new SpdxLicense('CUA-OPL-1.0');
/**
 * Caldera License
 *
 * @see http://www.lemis.com/grog/UNIX/ancient-source-all.pdf
 */
SpdxLicense.CALDERA = new SpdxLicense('Caldera');
/**
 * Clarified Artistic License
 *
 * @see http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/
 */
SpdxLicense.CL_ARTISTIC = new SpdxLicense('ClArtistic');
/**
 * Condor Public License v1.1
 *
 * @see http://research.cs.wisc.edu/condor/license.html#condor
 */
SpdxLicense.CONDOR_1_1 = new SpdxLicense('Condor-1.1');
/**
 * Crossword License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Crossword
 */
SpdxLicense.CROSSWORD = new SpdxLicense('Crossword');
/**
 * CrystalStacker License
 *
 * @see https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker
 */
SpdxLicense.CRYSTAL_STACKER = new SpdxLicense('CrystalStacker');
/**
 * Cube License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Cube
 */
SpdxLicense.CUBE = new SpdxLicense('Cube');
/**
 * Deutsche Freie Software Lizenz
 *
 * @see http://www.dipp.nrw.de/d-fsl/lizenzen/
 */
SpdxLicense.D_FSL_1_0 = new SpdxLicense('D-FSL-1.0');
/**
 * DOC License
 *
 * @see http://www.cs.wustl.edu/~schmidt/ACE-copying.html
 */
SpdxLicense.DOC = new SpdxLicense('DOC');
/**
 * DSDP License
 *
 * @see https://fedoraproject.org/wiki/Licensing/DSDP
 */
SpdxLicense.DSDP = new SpdxLicense('DSDP');
/**
 * Dotseqn License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Dotseqn
 */
SpdxLicense.DOTSEQN = new SpdxLicense('Dotseqn');
/**
 * Educational Community License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/ECL-1.0
 */
SpdxLicense.ECL_1_0 = new SpdxLicense('ECL-1.0');
/**
 * Educational Community License v2.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/ECL-2.0
 */
SpdxLicense.ECL_2_0 = new SpdxLicense('ECL-2.0');
/**
 * Eiffel Forum License v1.0
 *
 * @osiApproved
 *
 * @see http://www.eiffel-nice.org/license/forum.txt
 */
SpdxLicense.EFL_1_0 = new SpdxLicense('EFL-1.0');
/**
 * Eiffel Forum License v2.0
 *
 * @osiApproved
 *
 * @see http://www.eiffel-nice.org/license/eiffel-forum-license-2.html
 */
SpdxLicense.EFL_2_0 = new SpdxLicense('EFL-2.0');
/**
 * EPICS Open License
 *
 * @see https://epics.anl.gov/license/open.php
 */
SpdxLicense.EPICS = new SpdxLicense('EPICS');
/**
 * Eclipse Public License 1.0
 *
 * @osiApproved
 *
 * @see http://www.eclipse.org/legal/epl-v10.html
 */
SpdxLicense.EPL_1_0 = new SpdxLicense('EPL-1.0');
/**
 * Eclipse Public License 2.0
 *
 * @osiApproved
 *
 * @see https://www.eclipse.org/legal/epl-2.0
 */
SpdxLicense.EPL_2_0 = new SpdxLicense('EPL-2.0');
/**
 * EU DataGrid Software License
 *
 * @osiApproved
 *
 * @see http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
 */
SpdxLicense.EUDATAGRID = new SpdxLicense('EUDatagrid');
/**
 * European Union Public License 1.0
 *
 * @see http://ec.europa.eu/idabc/en/document/7330.html
 */
SpdxLicense.EUPL_1_0 = new SpdxLicense('EUPL-1.0');
/**
 * European Union Public License 1.1
 *
 * @osiApproved
 *
 * @see https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
 */
SpdxLicense.EUPL_1_1 = new SpdxLicense('EUPL-1.1');
/**
 * European Union Public License 1.2
 *
 * @osiApproved
 *
 * @see https://joinup.ec.europa.eu/page/eupl-text-11-12
 */
SpdxLicense.EUPL_1_2 = new SpdxLicense('EUPL-1.2');
/**
 * Entessa Public License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Entessa
 */
SpdxLicense.ENTESSA = new SpdxLicense('Entessa');
/**
 * Erlang Public License v1.1
 *
 * @see http://www.erlang.org/EPLICENSE
 */
SpdxLicense.ERLPL_1_1 = new SpdxLicense('ErlPL-1.1');
/**
 * Eurosym License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Eurosym
 */
SpdxLicense.EUROSYM = new SpdxLicense('Eurosym');
/**
 * FSF All Permissive License
 *
 * @see https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html
 */
SpdxLicense.FSFAP = new SpdxLicense('FSFAP');
/**
 * FSF Unlimited License
 *
 * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License
 */
SpdxLicense.FSFUL = new SpdxLicense('FSFUL');
/**
 * FSF Unlimited License (with License Retention)
 *
 * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant
 */
SpdxLicense.FSFULLR = new SpdxLicense('FSFULLR');
/**
 * Freetype Project License
 *
 * @see http://freetype.fis.uniroma2.it/FTL.TXT
 */
SpdxLicense.FTL = new SpdxLicense('FTL');
/**
 * Fair License
 *
 * @osiApproved
 *
 * @see http://fairlicense.org/
 */
SpdxLicense.FAIR = new SpdxLicense('Fair');
/**
 * Frameworx Open License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Frameworx-1.0
 */
SpdxLicense.FRAMEWORX_1_0 = new SpdxLicense('Frameworx-1.0');
/**
 * FreeImage Public License v1.0
 *
 * @see http://freeimage.sourceforge.net/freeimage-license.txt
 */
SpdxLicense.FREE_IMAGE = new SpdxLicense('FreeImage');
/**
 * GNU Free Documentation License v1.1
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1 = new SpdxLicense('GFDL-1.1');
/**
 * GNU Free Documentation License v1.1 only - invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.1-invariants-only');
/**
 * GNU Free Documentation License v1.1 or later - invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.1-invariants-or-later');
/**
 * GNU Free Documentation License v1.1 only - no invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1_NO_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.1-no-invariants-only');
/**
 * GNU Free Documentation License v1.1 or later - no invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1_NO_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.1-no-invariants-or-later');
/**
 * GNU Free Documentation License v1.1 only
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1_ONLY = new SpdxLicense('GFDL-1.1-only');
/**
 * GNU Free Documentation License v1.1 or later
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 */
SpdxLicense.GFDL_1_1_OR_LATER = new SpdxLicense('GFDL-1.1-or-later');
/**
 * GNU Free Documentation License v1.2
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2 = new SpdxLicense('GFDL-1.2');
/**
 * GNU Free Documentation License v1.2 only - invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.2-invariants-only');
/**
 * GNU Free Documentation License v1.2 or later - invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.2-invariants-or-later');
/**
 * GNU Free Documentation License v1.2 only - no invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2_NO_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.2-no-invariants-only');
/**
 * GNU Free Documentation License v1.2 or later - no invariants
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2_NO_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.2-no-invariants-or-later');
/**
 * GNU Free Documentation License v1.2 only
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2_ONLY = new SpdxLicense('GFDL-1.2-only');
/**
 * GNU Free Documentation License v1.2 or later
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 */
SpdxLicense.GFDL_1_2_OR_LATER = new SpdxLicense('GFDL-1.2-or-later');
/**
 * GNU Free Documentation License v1.3
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3 = new SpdxLicense('GFDL-1.3');
/**
 * GNU Free Documentation License v1.3 only - invariants
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.3-invariants-only');
/**
 * GNU Free Documentation License v1.3 or later - invariants
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.3-invariants-or-later');
/**
 * GNU Free Documentation License v1.3 only - no invariants
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3_NO_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.3-no-invariants-only');
/**
 * GNU Free Documentation License v1.3 or later - no invariants
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3_NO_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.3-no-invariants-or-later');
/**
 * GNU Free Documentation License v1.3 only
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3_ONLY = new SpdxLicense('GFDL-1.3-only');
/**
 * GNU Free Documentation License v1.3 or later
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 */
SpdxLicense.GFDL_1_3_OR_LATER = new SpdxLicense('GFDL-1.3-or-later');
/**
 * GL2PS License
 *
 * @see http://www.geuz.org/gl2ps/COPYING.GL2PS
 */
SpdxLicense.GL2_P_S = new SpdxLicense('GL2PS');
/**
 * Good Luck With That Public License
 *
 * @see https://github.com/me-shaon/GLWTPL/commit/da5f6bc734095efbacb442c0b31e33a65b9d6e85
 */
SpdxLicense.GLWTPL = new SpdxLicense('GLWTPL');
/**
 * GNU General Public License v1.0 only
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 */
SpdxLicense.GPL_1_0 = new SpdxLicense('GPL-1.0');
/**
 * GNU General Public License v1.0 or later
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 */
SpdxLicense.GPL_1_0_PLUS = new SpdxLicense('GPL-1.0+');
/**
 * GNU General Public License v1.0 only
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 */
SpdxLicense.GPL_1_0_ONLY = new SpdxLicense('GPL-1.0-only');
/**
 * GNU General Public License v1.0 or later
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 */
SpdxLicense.GPL_1_0_OR_LATER = new SpdxLicense('GPL-1.0-or-later');
/**
 * GNU General Public License v2.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 */
SpdxLicense.GPL_2_0 = new SpdxLicense('GPL-2.0');
/**
 * GNU General Public License v2.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 */
SpdxLicense.GPL_2_0_PLUS = new SpdxLicense('GPL-2.0+');
/**
 * GNU General Public License v2.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 */
SpdxLicense.GPL_2_0_ONLY = new SpdxLicense('GPL-2.0-only');
/**
 * GNU General Public License v2.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 */
SpdxLicense.GPL_2_0_OR_LATER = new SpdxLicense('GPL-2.0-or-later');
/**
 * GNU General Public License v2.0 w/GCC Runtime Library exception
 *
 * @see https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10
 */
SpdxLicense.GPL_2_0_WITH_GCC_EXCEPTION = new SpdxLicense('GPL-2.0-with-GCC-exception');
/**
 * GNU General Public License v2.0 w/Autoconf exception
 *
 * @see http://ac-archive.sourceforge.net/doc/copyright.html
 */
SpdxLicense.GPL_2_0_WITH_AUTOCONF_EXCEPTION = new SpdxLicense('GPL-2.0-with-autoconf-exception');
/**
 * GNU General Public License v2.0 w/Bison exception
 *
 * @see http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141
 */
SpdxLicense.GPL_2_0_WITH_BISON_EXCEPTION = new SpdxLicense('GPL-2.0-with-bison-exception');
/**
 * GNU General Public License v2.0 w/Classpath exception
 *
 * @see https://www.gnu.org/software/classpath/license.html
 */
SpdxLicense.GPL_2_0_WITH_CLASSPATH_EXCEPTION = new SpdxLicense('GPL-2.0-with-classpath-exception');
/**
 * GNU General Public License v2.0 w/Font exception
 *
 * @see https://www.gnu.org/licenses/gpl-faq.html#FontException
 */
SpdxLicense.GPL_2_0_WITH_FONT_EXCEPTION = new SpdxLicense('GPL-2.0-with-font-exception');
/**
 * GNU General Public License v3.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 */
SpdxLicense.GPL_3_0 = new SpdxLicense('GPL-3.0');
/**
 * GNU General Public License v3.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 */
SpdxLicense.GPL_3_0_PLUS = new SpdxLicense('GPL-3.0+');
/**
 * GNU General Public License v3.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 */
SpdxLicense.GPL_3_0_ONLY = new SpdxLicense('GPL-3.0-only');
/**
 * GNU General Public License v3.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 */
SpdxLicense.GPL_3_0_OR_LATER = new SpdxLicense('GPL-3.0-or-later');
/**
 * GNU General Public License v3.0 w/GCC Runtime Library exception
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/gcc-exception-3.1.html
 */
SpdxLicense.GPL_3_0_WITH_GCC_EXCEPTION = new SpdxLicense('GPL-3.0-with-GCC-exception');
/**
 * GNU General Public License v3.0 w/Autoconf exception
 *
 * @see https://www.gnu.org/licenses/autoconf-exception-3.0.html
 */
SpdxLicense.GPL_3_0_WITH_AUTOCONF_EXCEPTION = new SpdxLicense('GPL-3.0-with-autoconf-exception');
/**
 * Giftware License
 *
 * @see http://liballeg.org/license.html#allegro-4-the-giftware-license
 */
SpdxLicense.GIFTWARE = new SpdxLicense('Giftware');
/**
 * 3dfx Glide License
 *
 * @see http://www.users.on.net/~triforce/glidexp/COPYING.txt
 */
SpdxLicense.GLIDE = new SpdxLicense('Glide');
/**
 * Glulxe License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Glulxe
 */
SpdxLicense.GLULXE = new SpdxLicense('Glulxe');
/**
 * Historical Permission Notice and Disclaimer
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/HPND
 */
SpdxLicense.HPND = new SpdxLicense('HPND');
/**
 * Historical Permission Notice and Disclaimer - sell variant
 *
 * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19
 */
SpdxLicense.HPND_SELL_VARIANT = new SpdxLicense('HPND-sell-variant');
/**
 * HTML Tidy License
 *
 * @see https://github.com/htacg/tidy-html5/blob/next/README/LICENSE.md
 */
SpdxLicense.HTMLTIDY = new SpdxLicense('HTMLTIDY');
/**
 * Haskell Language Report License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License
 */
SpdxLicense.HASKELL_REPORT = new SpdxLicense('HaskellReport');
/**
 * Hippocratic License 2.1
 *
 * @see https://firstdonoharm.dev/version/2/1/license.html
 */
SpdxLicense.HIPPOCRATIC_2_1 = new SpdxLicense('Hippocratic-2.1');
/**
 * IBM PowerPC Initialization and Boot Software
 *
 * @see http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d
 */
SpdxLicense.IBM_PIBS = new SpdxLicense('IBM-pibs');
/**
 * ICU License
 *
 * @see http://source.icu-project.org/repos/icu/icu/trunk/license.html
 */
SpdxLicense.ICU = new SpdxLicense('ICU');
/**
 * Independent JPEG Group License
 *
 * @see http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2
 */
SpdxLicense.IJG = new SpdxLicense('IJG');
/**
 * IPA Font License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/IPA
 */
SpdxLicense.IPA = new SpdxLicense('IPA');
/**
 * IBM Public License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/IPL-1.0
 */
SpdxLicense.IPL_1_0 = new SpdxLicense('IPL-1.0');
/**
 * ISC License
 *
 * @osiApproved
 *
 * @see https://www.isc.org/downloads/software-support-policy/isc-license/
 */
SpdxLicense.ISC = new SpdxLicense('ISC');
/**
 * ImageMagick License
 *
 * @see http://www.imagemagick.org/script/license.php
 */
SpdxLicense.IMAGE_MAGICK = new SpdxLicense('ImageMagick');
/**
 * Imlib2 License
 *
 * @see http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING
 */
SpdxLicense.IMLIB2 = new SpdxLicense('Imlib2');
/**
 * Info-ZIP License
 *
 * @see http://www.info-zip.org/license.html
 */
SpdxLicense.INFO_ZIP = new SpdxLicense('Info-ZIP');
/**
 * Intel Open Source License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Intel
 */
SpdxLicense.INTEL = new SpdxLicense('Intel');
/**
 * Intel ACPI Software License Agreement
 *
 * @see https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement
 */
SpdxLicense.INTEL_ACPI = new SpdxLicense('Intel-ACPI');
/**
 * Interbase Public License v1.0
 *
 * @see https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html
 */
SpdxLicense.INTERBASE_1_0 = new SpdxLicense('Interbase-1.0');
/**
 * Japan Network Information Center License
 *
 * @see https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366
 */
SpdxLicense.JPNIC = new SpdxLicense('JPNIC');
/**
 * JSON License
 *
 * @see http://www.json.org/license.html
 */
SpdxLicense.JSON = new SpdxLicense('JSON');
/**
 * JasPer License
 *
 * @see http://www.ece.uvic.ca/~mdadams/jasper/LICENSE
 */
SpdxLicense.JASPER_2_0 = new SpdxLicense('JasPer-2.0');
/**
 * Licence Art Libre 1.2
 *
 * @see http://artlibre.org/licence/lal/licence-art-libre-12/
 */
SpdxLicense.LAL_1_2 = new SpdxLicense('LAL-1.2');
/**
 * Licence Art Libre 1.3
 *
 * @see https://artlibre.org/
 */
SpdxLicense.LAL_1_3 = new SpdxLicense('LAL-1.3');
/**
 * GNU Library General Public License v2 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 */
SpdxLicense.LGPL_2_0 = new SpdxLicense('LGPL-2.0');
/**
 * GNU Library General Public License v2 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 */
SpdxLicense.LGPL_2_0_PLUS = new SpdxLicense('LGPL-2.0+');
/**
 * GNU Library General Public License v2 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 */
SpdxLicense.LGPL_2_0_ONLY = new SpdxLicense('LGPL-2.0-only');
/**
 * GNU Library General Public License v2 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 */
SpdxLicense.LGPL_2_0_OR_LATER = new SpdxLicense('LGPL-2.0-or-later');
/**
 * GNU Lesser General Public License v2.1 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 */
SpdxLicense.LGPL_2_1 = new SpdxLicense('LGPL-2.1');
/**
 * GNU Library General Public License v2.1 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 */
SpdxLicense.LGPL_2_1_PLUS = new SpdxLicense('LGPL-2.1+');
/**
 * GNU Lesser General Public License v2.1 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 */
SpdxLicense.LGPL_2_1_ONLY = new SpdxLicense('LGPL-2.1-only');
/**
 * GNU Lesser General Public License v2.1 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 */
SpdxLicense.LGPL_2_1_OR_LATER = new SpdxLicense('LGPL-2.1-or-later');
/**
 * GNU Lesser General Public License v3.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 */
SpdxLicense.LGPL_3_0 = new SpdxLicense('LGPL-3.0');
/**
 * GNU Lesser General Public License v3.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 */
SpdxLicense.LGPL_3_0_PLUS = new SpdxLicense('LGPL-3.0+');
/**
 * GNU Lesser General Public License v3.0 only
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 */
SpdxLicense.LGPL_3_0_ONLY = new SpdxLicense('LGPL-3.0-only');
/**
 * GNU Lesser General Public License v3.0 or later
 *
 * @osiApproved
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 */
SpdxLicense.LGPL_3_0_OR_LATER = new SpdxLicense('LGPL-3.0-or-later');
/**
 * Lesser General Public License For Linguistic Resources
 *
 * @see http://www-igm.univ-mlv.fr/~unitex/lgpllr.html
 */
SpdxLicense.LGPLLR = new SpdxLicense('LGPLLR');
/**
 * Lucent Public License Version 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/LPL-1.0
 */
SpdxLicense.LPL_1_0 = new SpdxLicense('LPL-1.0');
/**
 * Lucent Public License v1.02
 *
 * @osiApproved
 *
 * @see http://plan9.bell-labs.com/plan9/license.html
 */
SpdxLicense.LPL_1_02 = new SpdxLicense('LPL-1.02');
/**
 * LaTeX Project Public License v1.0
 *
 * @see http://www.latex-project.org/lppl/lppl-1-0.txt
 */
SpdxLicense.LPPL_1_0 = new SpdxLicense('LPPL-1.0');
/**
 * LaTeX Project Public License v1.1
 *
 * @see http://www.latex-project.org/lppl/lppl-1-1.txt
 */
SpdxLicense.LPPL_1_1 = new SpdxLicense('LPPL-1.1');
/**
 * LaTeX Project Public License v1.2
 *
 * @see http://www.latex-project.org/lppl/lppl-1-2.txt
 */
SpdxLicense.LPPL_1_2 = new SpdxLicense('LPPL-1.2');
/**
 * LaTeX Project Public License v1.3a
 *
 * @see http://www.latex-project.org/lppl/lppl-1-3a.txt
 */
SpdxLicense.LPPL_1_3A = new SpdxLicense('LPPL-1.3a');
/**
 * LaTeX Project Public License v1.3c
 *
 * @osiApproved
 *
 * @see http://www.latex-project.org/lppl/lppl-1-3c.txt
 */
SpdxLicense.LPPL_1_3C = new SpdxLicense('LPPL-1.3c');
/**
 * Latex2e License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Latex2e
 */
SpdxLicense.LATEX2_E = new SpdxLicense('Latex2e');
/**
 * Leptonica License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Leptonica
 */
SpdxLicense.LEPTONICA = new SpdxLicense('Leptonica');
/**
 * Licence Libre du Québec – Permissive version 1.1
 *
 * @osiApproved
 *
 * @see https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/
 */
SpdxLicense.LILIQ_P_1_1 = new SpdxLicense('LiLiQ-P-1.1');
/**
 * Licence Libre du Québec – Réciprocité version 1.1
 *
 * @osiApproved
 *
 * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/
 */
SpdxLicense.LILIQ_R_1_1 = new SpdxLicense('LiLiQ-R-1.1');
/**
 * Licence Libre du Québec – Réciprocité forte version 1.1
 *
 * @osiApproved
 *
 * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/
 */
SpdxLicense.LILIQ_RPLUS_1_1 = new SpdxLicense('LiLiQ-Rplus-1.1');
/**
 * libpng License
 *
 * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
 */
SpdxLicense.LIBPNG = new SpdxLicense('Libpng');
/**
 * Linux Kernel Variant of OpenIB.org license
 *
 * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h
 */
SpdxLicense.LINUX_OPENIB = new SpdxLicense('Linux-OpenIB');
/**
 * MIT License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/MIT
 */
SpdxLicense.MIT = new SpdxLicense('MIT');
/**
 * MIT No Attribution
 *
 * @osiApproved
 *
 * @see https://github.com/aws/mit-0
 */
SpdxLicense.MIT_0 = new SpdxLicense('MIT-0');
/**
 * CMU License
 *
 * @see https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style
 */
SpdxLicense.MIT_CMU = new SpdxLicense('MIT-CMU');
/**
 * Enlightenment License (e16)
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising
 */
SpdxLicense.MIT_ADVERTISING = new SpdxLicense('MIT-advertising');
/**
 * enna License
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT#enna
 */
SpdxLicense.MIT_ENNA = new SpdxLicense('MIT-enna');
/**
 * feh License
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT#feh
 */
SpdxLicense.MIT_FEH = new SpdxLicense('MIT-feh');
/**
 * MIT Open Group variant
 *
 * @see https://gitlab.freedesktop.org/xorg/app/iceauth/-/blob/master/COPYING
 */
SpdxLicense.MIT_OPEN_GROUP = new SpdxLicense('MIT-open-group');
/**
 * MIT +no-false-attribs license
 *
 * @see https://fedoraproject.org/wiki/Licensing/MITNFA
 */
SpdxLicense.MITNFA = new SpdxLicense('MITNFA');
/**
 * Mozilla Public License 1.0
 *
 * @osiApproved
 *
 * @see http://www.mozilla.org/MPL/MPL-1.0.html
 */
SpdxLicense.MPL_1_0 = new SpdxLicense('MPL-1.0');
/**
 * Mozilla Public License 1.1
 *
 * @osiApproved
 *
 * @see http://www.mozilla.org/MPL/MPL-1.1.html
 */
SpdxLicense.MPL_1_1 = new SpdxLicense('MPL-1.1');
/**
 * Mozilla Public License 2.0
 *
 * @osiApproved
 *
 * @see http://www.mozilla.org/MPL/2.0/
 */
SpdxLicense.MPL_2_0 = new SpdxLicense('MPL-2.0');
/**
 * Mozilla Public License 2.0 (no copyleft exception)
 *
 * @osiApproved
 *
 * @see http://www.mozilla.org/MPL/2.0/
 */
SpdxLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION = new SpdxLicense('MPL-2.0-no-copyleft-exception');
/**
 * Microsoft Public License
 *
 * @osiApproved
 *
 * @see http://www.microsoft.com/opensource/licenses.mspx
 */
SpdxLicense.MS_PL = new SpdxLicense('MS-PL');
/**
 * Microsoft Reciprocal License
 *
 * @osiApproved
 *
 * @see http://www.microsoft.com/opensource/licenses.mspx
 */
SpdxLicense.MS_RL = new SpdxLicense('MS-RL');
/**
 * Matrix Template Library License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License
 */
SpdxLicense.MTLL = new SpdxLicense('MTLL');
/**
 * MakeIndex License
 *
 * @see https://fedoraproject.org/wiki/Licensing/MakeIndex
 */
SpdxLicense.MAKE_INDEX = new SpdxLicense('MakeIndex');
/**
 * The MirOS Licence
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/MirOS
 */
SpdxLicense.MIR_O_S = new SpdxLicense('MirOS');
/**
 * Motosoto License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Motosoto
 */
SpdxLicense.MOTOSOTO = new SpdxLicense('Motosoto');
/**
 * Mulan Permissive Software License, Version 1
 *
 * @see https://license.coscl.org.cn/MulanPSL/
 */
SpdxLicense.MULANPSL_1_0 = new SpdxLicense('MulanPSL-1.0');
/**
 * Mulan Permissive Software License, Version 2
 *
 * @osiApproved
 *
 * @see https://license.coscl.org.cn/MulanPSL2/
 */
SpdxLicense.MULANPSL_2_0 = new SpdxLicense('MulanPSL-2.0');
/**
 * Multics License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Multics
 */
SpdxLicense.MULTICS = new SpdxLicense('Multics');
/**
 * Mup License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Mup
 */
SpdxLicense.MUP = new SpdxLicense('Mup');
/**
 * NASA Open Source Agreement 1.3
 *
 * @osiApproved
 *
 * @see http://ti.arc.nasa.gov/opensource/nosa/
 */
SpdxLicense.NASA_1_3 = new SpdxLicense('NASA-1.3');
/**
 * Net Boolean Public License v1
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894
 */
SpdxLicense.NBPL_1_0 = new SpdxLicense('NBPL-1.0');
/**
 * Non-Commercial Government Licence
 *
 * @see https://github.com/spdx/license-list-XML/blob/master/src/Apache-2.0.xml
 */
SpdxLicense.NCGL_UK_2_0 = new SpdxLicense('NCGL-UK-2.0');
/**
 * University of Illinois/NCSA Open Source License
 *
 * @osiApproved
 *
 * @see http://otm.illinois.edu/uiuc_openSource
 */
SpdxLicense.NCSA = new SpdxLicense('NCSA');
/**
 * Nethack General Public License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/NGPL
 */
SpdxLicense.NGPL = new SpdxLicense('NGPL');
/**
 * NIST Public Domain Notice
 *
 * @see https://github.com/tcheneau/simpleRPL/blob/e645e69e38dd4e3ccfeceb2db8cba05b7c2e0cd3/LICENSE.txt
 */
SpdxLicense.NIST_PD = new SpdxLicense('NIST-PD');
/**
 * NIST Public Domain Notice with license fallback
 *
 * @see https://github.com/usnistgov/jsip/blob/59700e6926cbe96c5cdae897d9a7d2656b42abe3/LICENSE
 */
SpdxLicense.NIST_PD_FALLBACK = new SpdxLicense('NIST-PD-fallback');
/**
 * Norwegian Licence for Open Government Data
 *
 * @see http://data.norge.no/nlod/en/1.0
 */
SpdxLicense.NLOD_1_0 = new SpdxLicense('NLOD-1.0');
/**
 * No Limit Public License
 *
 * @see https://fedoraproject.org/wiki/Licensing/NLPL
 */
SpdxLicense.NLPL = new SpdxLicense('NLPL');
/**
 * Netizen Open Source License
 *
 * @see http://bits.netizen.com.au/licenses/NOSL/nosl.txt
 */
SpdxLicense.NOSL = new SpdxLicense('NOSL');
/**
 * Netscape Public License v1.0
 *
 * @see http://www.mozilla.org/MPL/NPL/1.0/
 */
SpdxLicense.NPL_1_0 = new SpdxLicense('NPL-1.0');
/**
 * Netscape Public License v1.1
 *
 * @see http://www.mozilla.org/MPL/NPL/1.1/
 */
SpdxLicense.NPL_1_1 = new SpdxLicense('NPL-1.1');
/**
 * Non-Profit Open Software License 3.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/NOSL3.0
 */
SpdxLicense.NPOSL_3_0 = new SpdxLicense('NPOSL-3.0');
/**
 * NRL License
 *
 * @see http://web.mit.edu/network/isakmp/nrllicense.html
 */
SpdxLicense.NRL = new SpdxLicense('NRL');
/**
 * NTP License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/NTP
 */
SpdxLicense.NTP = new SpdxLicense('NTP');
/**
 * NTP No Attribution
 *
 * @see https://github.com/tytso/e2fsprogs/blob/master/lib/et/et_name.c
 */
SpdxLicense.NTP_0 = new SpdxLicense('NTP-0');
/**
 * Naumen Public License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Naumen
 */
SpdxLicense.NAUMEN = new SpdxLicense('Naumen');
/**
 * Net-SNMP License
 *
 * @see http://net-snmp.sourceforge.net/about/license.html
 */
SpdxLicense.NET_SNMP = new SpdxLicense('Net-SNMP');
/**
 * NetCDF license
 *
 * @see http://www.unidata.ucar.edu/software/netcdf/copyright.html
 */
SpdxLicense.NET_CD_F = new SpdxLicense('NetCDF');
/**
 * Newsletr License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Newsletr
 */
SpdxLicense.NEWSLETR = new SpdxLicense('Newsletr');
/**
 * Nokia Open Source License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/nokia
 */
SpdxLicense.NOKIA = new SpdxLicense('Nokia');
/**
 * Noweb License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Noweb
 */
SpdxLicense.NOWEB = new SpdxLicense('Noweb');
/**
 * Nunit License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Nunit
 */
SpdxLicense.NUNIT = new SpdxLicense('Nunit');
/**
 * Open Use of Data Agreement v1.0
 *
 * @see https://github.com/microsoft/Open-Use-of-Data-Agreement/blob/v1.0/O-UDA-1.0.md
 */
SpdxLicense.O_UDA_1_0 = new SpdxLicense('O-UDA-1.0');
/**
 * Open CASCADE Technology Public License
 *
 * @see http://www.opencascade.com/content/occt-public-license
 */
SpdxLicense.OCCT_PL = new SpdxLicense('OCCT-PL');
/**
 * OCLC Research Public License 2.0
 *
 * @osiApproved
 *
 * @see http://www.oclc.org/research/activities/software/license/v2final.htm
 */
SpdxLicense.OCLC_2_0 = new SpdxLicense('OCLC-2.0');
/**
 * Open Data Commons Attribution License v1.0
 *
 * @see https://opendatacommons.org/licenses/by/1.0/
 */
SpdxLicense.ODC_BY_1_0 = new SpdxLicense('ODC-By-1.0');
/**
 * ODC Open Database License v1.0
 *
 * @see http://www.opendatacommons.org/licenses/odbl/1.0/
 */
SpdxLicense.ODBL_1_0 = new SpdxLicense('ODbL-1.0');
/**
 * SIL Open Font License 1.0
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
 */
SpdxLicense.OFL_1_0 = new SpdxLicense('OFL-1.0');
/**
 * SIL Open Font License 1.0 with Reserved Font Name
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
 */
SpdxLicense.OFL_1_0_RFN = new SpdxLicense('OFL-1.0-RFN');
/**
 * SIL Open Font License 1.0 with no Reserved Font Name
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
 */
SpdxLicense.OFL_1_0_NO_RFN = new SpdxLicense('OFL-1.0-no-RFN');
/**
 * SIL Open Font License 1.1
 *
 * @osiApproved
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
 */
SpdxLicense.OFL_1_1 = new SpdxLicense('OFL-1.1');
/**
 * SIL Open Font License 1.1 with Reserved Font Name
 *
 * @osiApproved
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
 */
SpdxLicense.OFL_1_1_RFN = new SpdxLicense('OFL-1.1-RFN');
/**
 * SIL Open Font License 1.1 with no Reserved Font Name
 *
 * @osiApproved
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
 */
SpdxLicense.OFL_1_1_NO_RFN = new SpdxLicense('OFL-1.1-no-RFN');
/**
 * OGC Software License, Version 1.0
 *
 * @see https://www.ogc.org/ogc/software/1.0
 */
SpdxLicense.OGC_1_0 = new SpdxLicense('OGC-1.0');
/**
 * Open Government Licence - Canada
 *
 * @see https://open.canada.ca/en/open-government-licence-canada
 */
SpdxLicense.OGL_CANADA_2_0 = new SpdxLicense('OGL-Canada-2.0');
/**
 * Open Government Licence v1.0
 *
 * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/
 */
SpdxLicense.OGL_UK_1_0 = new SpdxLicense('OGL-UK-1.0');
/**
 * Open Government Licence v2.0
 *
 * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/
 */
SpdxLicense.OGL_UK_2_0 = new SpdxLicense('OGL-UK-2.0');
/**
 * Open Government Licence v3.0
 *
 * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/
 */
SpdxLicense.OGL_UK_3_0 = new SpdxLicense('OGL-UK-3.0');
/**
 * Open Group Test Suite License
 *
 * @osiApproved
 *
 * @see http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt
 */
SpdxLicense.OGTSL = new SpdxLicense('OGTSL');
/**
 * Open LDAP Public License v1.1
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f
 */
SpdxLicense.OLDAP_1_1 = new SpdxLicense('OLDAP-1.1');
/**
 * Open LDAP Public License v1.2
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7
 */
SpdxLicense.OLDAP_1_2 = new SpdxLicense('OLDAP-1.2');
/**
 * Open LDAP Public License v1.3
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1
 */
SpdxLicense.OLDAP_1_3 = new SpdxLicense('OLDAP-1.3');
/**
 * Open LDAP Public License v1.4
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941
 */
SpdxLicense.OLDAP_1_4 = new SpdxLicense('OLDAP-1.4');
/**
 * Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea
 */
SpdxLicense.OLDAP_2_0 = new SpdxLicense('OLDAP-2.0');
/**
 * Open LDAP Public License v2.0.1
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e
 */
SpdxLicense.OLDAP_2_0_1 = new SpdxLicense('OLDAP-2.0.1');
/**
 * Open LDAP Public License v2.1
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715
 */
SpdxLicense.OLDAP_2_1 = new SpdxLicense('OLDAP-2.1');
/**
 * Open LDAP Public License v2.2
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3
 */
SpdxLicense.OLDAP_2_2 = new SpdxLicense('OLDAP-2.2');
/**
 * Open LDAP Public License v2.2.1
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e
 */
SpdxLicense.OLDAP_2_2_1 = new SpdxLicense('OLDAP-2.2.1');
/**
 * Open LDAP Public License 2.2.2
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188
 */
SpdxLicense.OLDAP_2_2_2 = new SpdxLicense('OLDAP-2.2.2');
/**
 * Open LDAP Public License v2.3
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3
 */
SpdxLicense.OLDAP_2_3 = new SpdxLicense('OLDAP-2.3');
/**
 * Open LDAP Public License v2.4
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386
 */
SpdxLicense.OLDAP_2_4 = new SpdxLicense('OLDAP-2.4');
/**
 * Open LDAP Public License v2.5
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf
 */
SpdxLicense.OLDAP_2_5 = new SpdxLicense('OLDAP-2.5');
/**
 * Open LDAP Public License v2.6
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205
 */
SpdxLicense.OLDAP_2_6 = new SpdxLicense('OLDAP-2.6');
/**
 * Open LDAP Public License v2.7
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2
 */
SpdxLicense.OLDAP_2_7 = new SpdxLicense('OLDAP-2.7');
/**
 * Open LDAP Public License v2.8
 *
 * @osiApproved
 *
 * @see http://www.openldap.org/software/release/license.html
 */
SpdxLicense.OLDAP_2_8 = new SpdxLicense('OLDAP-2.8');
/**
 * Open Market License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Open_Market_License
 */
SpdxLicense.OML = new SpdxLicense('OML');
/**
 * Open Public License v1.0
 *
 * @see http://old.koalateam.com/jackaroo/OPL_1_0.TXT
 */
SpdxLicense.OPL_1_0 = new SpdxLicense('OPL-1.0');
/**
 * OSET Public License version 2.1
 *
 * @osiApproved
 *
 * @see http://www.osetfoundation.org/public-license
 */
SpdxLicense.OSET_PL_2_1 = new SpdxLicense('OSET-PL-2.1');
/**
 * Open Software License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/OSL-1.0
 */
SpdxLicense.OSL_1_0 = new SpdxLicense('OSL-1.0');
/**
 * Open Software License 1.1
 *
 * @see https://fedoraproject.org/wiki/Licensing/OSL1.1
 */
SpdxLicense.OSL_1_1 = new SpdxLicense('OSL-1.1');
/**
 * Open Software License 2.0
 *
 * @osiApproved
 *
 * @see http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html
 */
SpdxLicense.OSL_2_0 = new SpdxLicense('OSL-2.0');
/**
 * Open Software License 2.1
 *
 * @osiApproved
 *
 * @see http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm
 */
SpdxLicense.OSL_2_1 = new SpdxLicense('OSL-2.1');
/**
 * Open Software License 3.0
 *
 * @osiApproved
 *
 * @see https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm
 */
SpdxLicense.OSL_3_0 = new SpdxLicense('OSL-3.0');
/**
 * OpenSSL License
 *
 * @see http://www.openssl.org/source/license.html
 */
SpdxLicense.OPEN_SS_L = new SpdxLicense('OpenSSL');
/**
 * ODC Public Domain Dedication & License 1.0
 *
 * @see http://opendatacommons.org/licenses/pddl/1.0/
 */
SpdxLicense.PDDL_1_0 = new SpdxLicense('PDDL-1.0');
/**
 * PHP License v3.0
 *
 * @osiApproved
 *
 * @see http://www.php.net/license/3_0.txt
 */
SpdxLicense.PHP_3_0 = new SpdxLicense('PHP-3.0');
/**
 * PHP License v3.01
 *
 * @osiApproved
 *
 * @see http://www.php.net/license/3_01.txt
 */
SpdxLicense.PHP_3_01 = new SpdxLicense('PHP-3.01');
/**
 * Python Software Foundation License 2.0
 *
 * @see https://opensource.org/licenses/Python-2.0
 */
SpdxLicense.PSF_2_0 = new SpdxLicense('PSF-2.0');
/**
 * The Parity Public License 6.0.0
 *
 * @see https://paritylicense.com/versions/6.0.0.html
 */
SpdxLicense.PARITY_6_0_0 = new SpdxLicense('Parity-6.0.0');
/**
 * The Parity Public License 7.0.0
 *
 * @see https://paritylicense.com/versions/7.0.0.html
 */
SpdxLicense.PARITY_7_0_0 = new SpdxLicense('Parity-7.0.0');
/**
 * Plexus Classworlds License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License
 */
SpdxLicense.PLEXUS = new SpdxLicense('Plexus');
/**
 * PolyForm Noncommercial License 1.0.0
 *
 * @see https://polyformproject.org/licenses/noncommercial/1.0.0
 */
SpdxLicense.POLYFORM_NONCOMMERCIAL_1_0_0 = new SpdxLicense('PolyForm-Noncommercial-1.0.0');
/**
 * PolyForm Small Business License 1.0.0
 *
 * @see https://polyformproject.org/licenses/small-business/1.0.0
 */
SpdxLicense.POLYFORM_SMALL_BUSINESS_1_0_0 = new SpdxLicense('PolyForm-Small-Business-1.0.0');
/**
 * PostgreSQL License
 *
 * @osiApproved
 *
 * @see http://www.postgresql.org/about/licence
 */
SpdxLicense.POSTGRE_SQ_L = new SpdxLicense('PostgreSQL');
/**
 * Python License 2.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Python-2.0
 */
SpdxLicense.PYTHON_2_0 = new SpdxLicense('Python-2.0');
/**
 * Q Public License 1.0
 *
 * @osiApproved
 *
 * @see http://doc.qt.nokia.com/3.3/license.html
 */
SpdxLicense.QPL_1_0 = new SpdxLicense('QPL-1.0');
/**
 * Qhull License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Qhull
 */
SpdxLicense.QHULL = new SpdxLicense('Qhull');
/**
 * Red Hat eCos Public License v1.1
 *
 * @see http://ecos.sourceware.org/old-license.html
 */
SpdxLicense.RHECOS_1_1 = new SpdxLicense('RHeCos-1.1');
/**
 * Reciprocal Public License 1.1
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/RPL-1.1
 */
SpdxLicense.RPL_1_1 = new SpdxLicense('RPL-1.1');
/**
 * Reciprocal Public License 1.5
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/RPL-1.5
 */
SpdxLicense.RPL_1_5 = new SpdxLicense('RPL-1.5');
/**
 * RealNetworks Public Source License v1.0
 *
 * @osiApproved
 *
 * @see https://helixcommunity.org/content/rpsl
 */
SpdxLicense.RPSL_1_0 = new SpdxLicense('RPSL-1.0');
/**
 * RSA Message-Digest License
 *
 * @see http://www.faqs.org/rfcs/rfc1321.html
 */
SpdxLicense.RSA_MD = new SpdxLicense('RSA-MD');
/**
 * Ricoh Source Code Public License
 *
 * @osiApproved
 *
 * @see http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml
 */
SpdxLicense.RSCPL = new SpdxLicense('RSCPL');
/**
 * Rdisc License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Rdisc_License
 */
SpdxLicense.RDISC = new SpdxLicense('Rdisc');
/**
 * Ruby License
 *
 * @see http://www.ruby-lang.org/en/LICENSE.txt
 */
SpdxLicense.RUBY = new SpdxLicense('Ruby');
/**
 * Sax Public Domain Notice
 *
 * @see http://www.saxproject.org/copying.html
 */
SpdxLicense.SAX_PD = new SpdxLicense('SAX-PD');
/**
 * SCEA Shared Source License
 *
 * @see http://research.scea.com/scea_shared_source_license.html
 */
SpdxLicense.SCEA = new SpdxLicense('SCEA');
/**
 * SGI Free Software License B v1.0
 *
 * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html
 */
SpdxLicense.SGI_B_1_0 = new SpdxLicense('SGI-B-1.0');
/**
 * SGI Free Software License B v1.1
 *
 * @see http://oss.sgi.com/projects/FreeB/
 */
SpdxLicense.SGI_B_1_1 = new SpdxLicense('SGI-B-1.1');
/**
 * SGI Free Software License B v2.0
 *
 * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf
 */
SpdxLicense.SGI_B_2_0 = new SpdxLicense('SGI-B-2.0');
/**
 * Solderpad Hardware License v0.5
 *
 * @see https://solderpad.org/licenses/SHL-0.5/
 */
SpdxLicense.SHL_0_5 = new SpdxLicense('SHL-0.5');
/**
 * Solderpad Hardware License, Version 0.51
 *
 * @see https://solderpad.org/licenses/SHL-0.51/
 */
SpdxLicense.SHL_0_51 = new SpdxLicense('SHL-0.51');
/**
 * Sun Industry Standards Source License v1.1
 *
 * @osiApproved
 *
 * @see http://www.openoffice.org/licenses/sissl_license.html
 */
SpdxLicense.SISSL = new SpdxLicense('SISSL');
/**
 * Sun Industry Standards Source License v1.2
 *
 * @see http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html
 */
SpdxLicense.SISSL_1_2 = new SpdxLicense('SISSL-1.2');
/**
 * Standard ML of New Jersey License
 *
 * @see https://www.smlnj.org/license.html
 */
SpdxLicense.SMLNJ = new SpdxLicense('SMLNJ');
/**
 * Secure Messaging Protocol Public License
 *
 * @see https://github.com/dcblake/SMP/blob/master/Documentation/License.txt
 */
SpdxLicense.SMPPL = new SpdxLicense('SMPPL');
/**
 * SNIA Public License 1.1
 *
 * @see https://fedoraproject.org/wiki/Licensing/SNIA_Public_License
 */
SpdxLicense.SNIA = new SpdxLicense('SNIA');
/**
 * Sun Public License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/SPL-1.0
 */
SpdxLicense.SPL_1_0 = new SpdxLicense('SPL-1.0');
/**
 * SSH OpenSSH license
 *
 * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/LICENCE#L10
 */
SpdxLicense.SSH_OPENSSH = new SpdxLicense('SSH-OpenSSH');
/**
 * SSH short notice
 *
 * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/pathnames.h
 */
SpdxLicense.SSH_SHORT = new SpdxLicense('SSH-short');
/**
 * Server Side Public License, v 1
 *
 * @see https://www.mongodb.com/licensing/server-side-public-license
 */
SpdxLicense.SSPL_1_0 = new SpdxLicense('SSPL-1.0');
/**
 * Scheme Widget Library (SWL) Software License Agreement
 *
 * @see https://fedoraproject.org/wiki/Licensing/SWL
 */
SpdxLicense.SWL = new SpdxLicense('SWL');
/**
 * Saxpath License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Saxpath_License
 */
SpdxLicense.SAXPATH = new SpdxLicense('Saxpath');
/**
 * Sendmail License
 *
 * @see http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf
 */
SpdxLicense.SENDMAIL = new SpdxLicense('Sendmail');
/**
 * Sendmail License 8.23
 *
 * @see https://www.proofpoint.com/sites/default/files/sendmail-license.pdf
 */
SpdxLicense.SENDMAIL_8_23 = new SpdxLicense('Sendmail-8.23');
/**
 * Simple Public License 2.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/SimPL-2.0
 */
SpdxLicense.SIMPL_2_0 = new SpdxLicense('SimPL-2.0');
/**
 * Sleepycat License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Sleepycat
 */
SpdxLicense.SLEEPYCAT = new SpdxLicense('Sleepycat');
/**
 * Spencer License 86
 *
 * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
 */
SpdxLicense.SPENCER_86 = new SpdxLicense('Spencer-86');
/**
 * Spencer License 94
 *
 * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
 */
SpdxLicense.SPENCER_94 = new SpdxLicense('Spencer-94');
/**
 * Spencer License 99
 *
 * @see http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c
 */
SpdxLicense.SPENCER_99 = new SpdxLicense('Spencer-99');
/**
 * Standard ML of New Jersey License
 *
 * @see http://www.smlnj.org//license.html
 */
SpdxLicense.STANDARDML_NJ = new SpdxLicense('StandardML-NJ');
/**
 * SugarCRM Public License v1.1.3
 *
 * @see http://www.sugarcrm.com/crm/SPL
 */
SpdxLicense.SUGARCRM_1_1_3 = new SpdxLicense('SugarCRM-1.1.3');
/**
 * TAPR Open Hardware License v1.0
 *
 * @see https://www.tapr.org/OHL
 */
SpdxLicense.TAPR_OHL_1_0 = new SpdxLicense('TAPR-OHL-1.0');
/**
 * TCL/TK License
 *
 * @see http://www.tcl.tk/software/tcltk/license.html
 */
SpdxLicense.TCL = new SpdxLicense('TCL');
/**
 * TCP Wrappers License
 *
 * @see http://rc.quest.com/topics/openssh/license.php#tcpwrappers
 */
SpdxLicense.TCP_WRAPPERS = new SpdxLicense('TCP-wrappers');
/**
 * TMate Open Source License
 *
 * @see http://svnkit.com/license.html
 */
SpdxLicense.TMATE = new SpdxLicense('TMate');
/**
 * TORQUE v2.5+ Software License v1.1
 *
 * @see https://fedoraproject.org/wiki/Licensing/TORQUEv1.1
 */
SpdxLicense.TORQUE_1_1 = new SpdxLicense('TORQUE-1.1');
/**
 * Trusster Open Source License
 *
 * @see https://fedoraproject.org/wiki/Licensing/TOSL
 */
SpdxLicense.TOSL = new SpdxLicense('TOSL');
/**
 * Technische Universitaet Berlin License 1.0
 *
 * @see https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT
 */
SpdxLicense.TU_BERLIN_1_0 = new SpdxLicense('TU-Berlin-1.0');
/**
 * Technische Universitaet Berlin License 2.0
 *
 * @see https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt
 */
SpdxLicense.TU_BERLIN_2_0 = new SpdxLicense('TU-Berlin-2.0');
/**
 * Upstream Compatibility License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/UCL-1.0
 */
SpdxLicense.UCL_1_0 = new SpdxLicense('UCL-1.0');
/**
 * Universal Permissive License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/UPL
 */
SpdxLicense.UPL_1_0 = new SpdxLicense('UPL-1.0');
/**
 * Unicode License Agreement - Data Files and Software (2015)
 *
 * @see https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html
 */
SpdxLicense.UNICODE_DFS_2015 = new SpdxLicense('Unicode-DFS-2015');
/**
 * Unicode License Agreement - Data Files and Software (2016)
 *
 * @osiApproved
 *
 * @see http://www.unicode.org/copyright.html
 */
SpdxLicense.UNICODE_DFS_2016 = new SpdxLicense('Unicode-DFS-2016');
/**
 * Unicode Terms of Use
 *
 * @see http://www.unicode.org/copyright.html
 */
SpdxLicense.UNICODE_TOU = new SpdxLicense('Unicode-TOU');
/**
 * The Unlicense
 *
 * @osiApproved
 *
 * @see https://unlicense.org/
 */
SpdxLicense.UNLICENSE = new SpdxLicense('Unlicense');
/**
 * VOSTROM Public License for Open Source
 *
 * @see https://fedoraproject.org/wiki/Licensing/VOSTROM
 */
SpdxLicense.VOSTROM = new SpdxLicense('VOSTROM');
/**
 * Vovida Software License v1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/VSL-1.0
 */
SpdxLicense.VSL_1_0 = new SpdxLicense('VSL-1.0');
/**
 * Vim License
 *
 * @see http://vimdoc.sourceforge.net/htmldoc/uganda.html
 */
SpdxLicense.VIM = new SpdxLicense('Vim');
/**
 * W3C Software Notice and License (2002-12-31)
 *
 * @osiApproved
 *
 * @see http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html
 */
SpdxLicense.W3_C = new SpdxLicense('W3C');
/**
 * W3C Software Notice and License (1998-07-20)
 *
 * @see http://www.w3.org/Consortium/Legal/copyright-software-19980720.html
 */
SpdxLicense.W3C_19980720 = new SpdxLicense('W3C-19980720');
/**
 * W3C Software Notice and Document License (2015-05-13)
 *
 * @see https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document
 */
SpdxLicense.W3C_20150513 = new SpdxLicense('W3C-20150513');
/**
 * Do What The F*ck You Want To Public License
 *
 * @see http://www.wtfpl.net/about/
 */
SpdxLicense.WTFPL = new SpdxLicense('WTFPL');
/**
 * Sybase Open Watcom Public License 1.0
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Watcom-1.0
 */
SpdxLicense.WATCOM_1_0 = new SpdxLicense('Watcom-1.0');
/**
 * Wsuipa License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Wsuipa
 */
SpdxLicense.WSUIPA = new SpdxLicense('Wsuipa');
/**
 * X11 License
 *
 * @see http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3
 */
SpdxLicense.X11 = new SpdxLicense('X11');
/**
 * XFree86 License 1.1
 *
 * @see http://www.xfree86.org/current/LICENSE4.html
 */
SpdxLicense.XFREE86_1_1 = new SpdxLicense('XFree86-1.1');
/**
 * XSkat License
 *
 * @see https://fedoraproject.org/wiki/Licensing/XSkat_License
 */
SpdxLicense.XSKAT = new SpdxLicense('XSkat');
/**
 * Xerox License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Xerox
 */
SpdxLicense.XEROX = new SpdxLicense('Xerox');
/**
 * X.Net License
 *
 * @osiApproved
 *
 * @see https://opensource.org/licenses/Xnet
 */
SpdxLicense.XNET = new SpdxLicense('Xnet');
/**
 * Yahoo! Public License v1.0
 *
 * @see http://www.zimbra.com/license/yahoo_public_license_1.0.html
 */
SpdxLicense.YPL_1_0 = new SpdxLicense('YPL-1.0');
/**
 * Yahoo! Public License v1.1
 *
 * @see http://www.zimbra.com/license/yahoo_public_license_1.1.html
 */
SpdxLicense.YPL_1_1 = new SpdxLicense('YPL-1.1');
/**
 * Zope Public License 1.1
 *
 * @see http://old.zope.org/Resources/License/ZPL-1.1
 */
SpdxLicense.ZPL_1_1 = new SpdxLicense('ZPL-1.1');
/**
 * Zope Public License 2.0
 *
 * @osiApproved
 *
 * @see http://old.zope.org/Resources/License/ZPL-2.0
 */
SpdxLicense.ZPL_2_0 = new SpdxLicense('ZPL-2.0');
/**
 * Zope Public License 2.1
 *
 * @see http://old.zope.org/Resources/ZPL/
 */
SpdxLicense.ZPL_2_1 = new SpdxLicense('ZPL-2.1');
/**
 * Zed License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Zed
 */
SpdxLicense.ZED = new SpdxLicense('Zed');
/**
 * Zend License v2.0
 *
 * @see https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt
 */
SpdxLicense.ZEND_2_0 = new SpdxLicense('Zend-2.0');
/**
 * Zimbra Public License v1.3
 *
 * @see http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html
 */
SpdxLicense.ZIMBRA_1_3 = new SpdxLicense('Zimbra-1.3');
/**
 * Zimbra Public License v1.4
 *
 * @see http://www.zimbra.com/legal/zimbra-public-license-1-4
 */
SpdxLicense.ZIMBRA_1_4 = new SpdxLicense('Zimbra-1.4');
/**
 * zlib License
 *
 * @osiApproved
 *
 * @see http://www.zlib.net/zlib_license.html
 */
SpdxLicense.ZLIB = new SpdxLicense('Zlib');
/**
 * SQLite Blessing
 *
 * @see https://www.sqlite.org/src/artifact/e33a4df7e32d742a?ln=4-9
 */
SpdxLicense.BLESSING = new SpdxLicense('blessing');
/**
 * bzip2 and libbzip2 License v1.0.5
 *
 * @see https://sourceware.org/bzip2/1.0.5/bzip2-manual-1.0.5.html
 */
SpdxLicense.BZIP2_1_0_5 = new SpdxLicense('bzip2-1.0.5');
/**
 * bzip2 and libbzip2 License v1.0.6
 *
 * @see https://sourceware.org/git/?p=bzip2.git;a=blob;f=LICENSE;hb=bzip2-1.0.6
 */
SpdxLicense.BZIP2_1_0_6 = new SpdxLicense('bzip2-1.0.6');
/**
 * copyleft-next 0.3.0
 *
 * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0
 */
SpdxLicense.COPYLEFT_NEXT_0_3_0 = new SpdxLicense('copyleft-next-0.3.0');
/**
 * copyleft-next 0.3.1
 *
 * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1
 */
SpdxLicense.COPYLEFT_NEXT_0_3_1 = new SpdxLicense('copyleft-next-0.3.1');
/**
 * curl License
 *
 * @see https://github.com/bagder/curl/blob/master/COPYING
 */
SpdxLicense.CURL = new SpdxLicense('curl');
/**
 * diffmark license
 *
 * @see https://fedoraproject.org/wiki/Licensing/diffmark
 */
SpdxLicense.DIFFMARK = new SpdxLicense('diffmark');
/**
 * dvipdfm License
 *
 * @see https://fedoraproject.org/wiki/Licensing/dvipdfm
 */
SpdxLicense.DVIPDFM = new SpdxLicense('dvipdfm');
/**
 * eCos license version 2.0
 *
 * @see https://www.gnu.org/licenses/ecos-license.html
 */
SpdxLicense.ECOS_2_0 = new SpdxLicense('eCos-2.0');
/**
 * eGenix.com Public License 1.1.0
 *
 * @see http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf
 */
SpdxLicense.E_GENIX = new SpdxLicense('eGenix');
/**
 * Etalab Open License 2.0
 *
 * @see https://github.com/DISIC/politique-de-contribution-open-source/blob/master/LICENSE.pdf
 */
SpdxLicense.ETALAB_2_0 = new SpdxLicense('etalab-2.0');
/**
 * gSOAP Public License v1.3b
 *
 * @see http://www.cs.fsu.edu/~engelen/license.html
 */
SpdxLicense.GSOAP_1_3B = new SpdxLicense('gSOAP-1.3b');
/**
 * gnuplot License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Gnuplot
 */
SpdxLicense.GNUPLOT = new SpdxLicense('gnuplot');
/**
 * iMatix Standard Function Library Agreement
 *
 * @see http://legacy.imatix.com/html/sfl/sfl4.htm#license
 */
SpdxLicense.I_MATIX = new SpdxLicense('iMatix');
/**
 * PNG Reference Library version 2
 *
 * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
 */
SpdxLicense.LIBPNG_2_0 = new SpdxLicense('libpng-2.0');
/**
 * libselinux public domain notice
 *
 * @see https://github.com/SELinuxProject/selinux/blob/master/libselinux/LICENSE
 */
SpdxLicense.LIBSELINUX_1_0 = new SpdxLicense('libselinux-1.0');
/**
 * libtiff License
 *
 * @see https://fedoraproject.org/wiki/Licensing/libtiff
 */
SpdxLicense.LIBTIFF = new SpdxLicense('libtiff');
/**
 * mpich2 License
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT
 */
SpdxLicense.MPICH2 = new SpdxLicense('mpich2');
/**
 * psfrag License
 *
 * @see https://fedoraproject.org/wiki/Licensing/psfrag
 */
SpdxLicense.PSFRAG = new SpdxLicense('psfrag');
/**
 * psutils License
 *
 * @see https://fedoraproject.org/wiki/Licensing/psutils
 */
SpdxLicense.PSUTILS = new SpdxLicense('psutils');
/**
 * wxWindows Library License
 *
 * @see https://opensource.org/licenses/WXwindows
 */
SpdxLicense.WX_WINDOWS = new SpdxLicense('wxWindows');
/**
 * xinetd License
 *
 * @see https://fedoraproject.org/wiki/Licensing/Xinetd_License
 */
SpdxLicense.XINETD = new SpdxLicense('xinetd');
/**
 * XPP License
 *
 * @see https://fedoraproject.org/wiki/Licensing/xpp
 */
SpdxLicense.XPP = new SpdxLicense('xpp');
/**
 * zlib/libpng License with Acknowledgement
 *
 * @see https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement
 */
SpdxLicense.ZLIB_ACKNOWLEDGEMENT = new SpdxLicense('zlib-acknowledgement');
/** Packages that have not been licensed */
SpdxLicense.UNLICENSED = new SpdxLicense('UNLICENSED');
//# sourceMappingURL=data:application/json;base64,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