---
pretty_name: Opus100
task_categories:
- sequence-modeling
multilinguality:
- translation
task_ids:
- language-modeling
languages:
  af-en:
  - af
  - en
  am-en:
  - am
  - en
  an-en:
  - an
  - en
  ar-en:
  - ar
  - en
  as-en:
  - as
  - en
  az-en:
  - az
  - en
  be-en:
  - be
  - en
  bg-en:
  - bg
  - en
  bn-en:
  - bn
  - en
  br-en:
  - br
  - en
  bs-en:
  - bs
  - en
  ca-en:
  - ca
  - en
  cs-en:
  - cs
  - en
  cy-en:
  - cy
  - en
  da-en:
  - da
  - en
  de-en:
  - de
  - en
  dz-en:
  - dz
  - en
  el-en:
  - el
  - en
  en-eo:
  - en
  - eo
  en-es:
  - en
  - es
  en-et:
  - en
  - et
  en-eu:
  - en
  - eu
  en-fa:
  - en
  - fa
  en-fi:
  - en
  - fi
  en-fr:
  - en
  - fr
  en-fy:
  - en
  - fy
  en-ga:
  - en
  - ga
  en-gd:
  - en
  - gd
  en-gl:
  - en
  - gl
  en-gu:
  - en
  - gu
  en-ha:
  - en
  - ha
  en-he:
  - en
  - he
  en-hi:
  - en
  - hi
  en-hr:
  - en
  - hr
  en-hu:
  - en
  - hu
  en-hy:
  - en
  - hy
  en-id:
  - en
  - id
  en-ig:
  - en
  - ig
  en-is:
  - en
  - is
  en-it:
  - en
  - it
  en-ja:
  - en
  - ja
  en-ka:
  - en
  - ka
  en-kk:
  - en
  - kk
  en-km:
  - en
  - km
  en-ko:
  - en
  - ko
  en-kn:
  - en
  - kn
  en-ku:
  - en
  - ku
  en-ky:
  - en
  - ky
  en-li:
  - en
  - li
  en-lt:
  - en
  - lt
  en-lv:
  - en
  - lv
  en-mg:
  - en
  - mg
  en-mk:
  - en
  - mk
  en-ml:
  - en
  - ml
  en-mn:
  - en
  - mn
  en-mr:
  - en
  - mr
  en-ms:
  - en
  - ms
  en-mt:
  - en
  - mt
  en-my:
  - en
  - my
  en-nb:
  - en
  - nb
  en-ne:
  - en
  - ne
  en-nl:
  - en
  - nl
  en-nn:
  - en
  - nn
  en-no:
  - en
  - 'no'
  en-oc:
  - en
  - oc
  en-or:
  - en
  - or
  en-pa:
  - en
  - pa
  en-pl:
  - en
  - pl
  en-ps:
  - en
  - ps
  en-pt:
  - en
  - pt
  en-ro:
  - en
  - ro
  en-ru:
  - en
  - ru
  en-rw:
  - en
  - rw
  en-se:
  - en
  - se
  en-sh:
  - en
  - sh
  en-si:
  - en
  - si
  en-sk:
  - en
  - sk
  en-sl:
  - en
  - sl
  en-sq:
  - en
  - sq
  en-sr:
  - en
  - sr
  en-sv:
  - en
  - sv
  en-ta:
  - en
  - ta
  en-te:
  - en
  - te
  en-tg:
  - en
  - tg
  en-th:
  - en
  - th
  en-tk:
  - en
  - tk
  en-tr:
  - en
  - tr
  en-tt:
  - en
  - tt
  en-ug:
  - en
  - ug
  en-uk:
  - en
  - uk
  en-ur:
  - en
  - ur
  en-uz:
  - en
  - uz
  en-vi:
  - en
  - vi
  en-wa:
  - en
  - wa
  en-xh:
  - en
  - xh
  en-yi:
  - en
  - yi
  en-yo:
  - en
  - yo
  en-zh:
  - en
  - zh
  en-zu:
  - en
  - zu
annotations_creators:
- no-annotation
source_datasets:
- extended
size_categories:
  af-en:
  - 100K<n<1M
  am-en:
  - 10K<n<100K
  an-en:
  - 1K<n<10K
  ar-de:
  - 1K<n<10K
  ar-en:
  - 1M<n<10M
  ar-fr:
  - 1K<n<10K
  ar-nl:
  - 1K<n<10K
  ar-ru:
  - 1K<n<10K
  ar-zh:
  - 1K<n<10K
  as-en:
  - 100K<n<1M
  az-en:
  - 100K<n<1M
  be-en:
  - 10K<n<100K
  bg-en:
  - 1M<n<10M
  bn-en:
  - 1M<n<10M
  br-en:
  - 100K<n<1M
  bs-en:
  - 1M<n<10M
  ca-en:
  - 1M<n<10M
  cs-en:
  - 1M<n<10M
  cy-en:
  - 100K<n<1M
  da-en:
  - 1M<n<10M
  de-en:
  - 1M<n<10M
  de-fr:
  - 1K<n<10K
  de-nl:
  - 1K<n<10K
  de-ru:
  - 1K<n<10K
  de-zh:
  - 1K<n<10K
  dz-en:
  - n<1K
  el-en:
  - 1M<n<10M
  en-eo:
  - 100K<n<1M
  en-es:
  - 1M<n<10M
  en-et:
  - 1M<n<10M
  en-eu:
  - 1M<n<10M
  en-fa:
  - 1M<n<10M
  en-fi:
  - 1M<n<10M
  en-fr:
  - 1M<n<10M
  en-fy:
  - 10K<n<100K
  en-ga:
  - 100K<n<1M
  en-gd:
  - 10K<n<100K
  en-gl:
  - 100K<n<1M
  en-gu:
  - 100K<n<1M
  en-ha:
  - 100K<n<1M
  en-he:
  - 1M<n<10M
  en-hi:
  - 100K<n<1M
  en-hr:
  - 1M<n<10M
  en-hu:
  - 1M<n<10M
  en-hy:
  - 1K<n<10K
  en-id:
  - 1M<n<10M
  en-ig:
  - 10K<n<100K
  en-is:
  - 1M<n<10M
  en-it:
  - 1M<n<10M
  en-ja:
  - 1M<n<10M
  en-ka:
  - 100K<n<1M
  en-kk:
  - 10K<n<100K
  en-km:
  - 100K<n<1M
  en-kn:
  - 10K<n<100K
  en-ko:
  - 1M<n<10M
  en-ku:
  - 100K<n<1M
  en-ky:
  - 10K<n<100K
  en-li:
  - 10K<n<100K
  en-lt:
  - 1M<n<10M
  en-lv:
  - 1M<n<10M
  en-mg:
  - 100K<n<1M
  en-mk:
  - 1M<n<10M
  en-ml:
  - 100K<n<1M
  en-mn:
  - 1K<n<10K
  en-mr:
  - 10K<n<100K
  en-ms:
  - 1M<n<10M
  en-mt:
  - 1M<n<10M
  en-my:
  - 10K<n<100K
  en-nb:
  - 100K<n<1M
  en-ne:
  - 100K<n<1M
  en-nl:
  - 1M<n<10M
  en-nn:
  - 100K<n<1M
  en-no:
  - 1M<n<10M
  en-oc:
  - 10K<n<100K
  en-or:
  - 10K<n<100K
  en-pa:
  - 100K<n<1M
  en-pl:
  - 1M<n<10M
  en-ps:
  - 10K<n<100K
  en-pt:
  - 1M<n<10M
  en-ro:
  - 1M<n<10M
  en-ru:
  - 1M<n<10M
  en-rw:
  - 100K<n<1M
  en-se:
  - 10K<n<100K
  en-sh:
  - 100K<n<1M
  en-si:
  - 100K<n<1M
  en-sk:
  - 1M<n<10M
  en-sl:
  - 1M<n<10M
  en-sq:
  - 1M<n<10M
  en-sr:
  - 1M<n<10M
  en-sv:
  - 1M<n<10M
  en-ta:
  - 100K<n<1M
  en-te:
  - 10K<n<100K
  en-tg:
  - 100K<n<1M
  en-th:
  - 1M<n<10M
  en-tk:
  - 10K<n<100K
  en-tr:
  - 1M<n<10M
  en-tt:
  - 100K<n<1M
  en-ug:
  - 10K<n<100K
  en-uk:
  - 1M<n<10M
  en-ur:
  - 100K<n<1M
  en-uz:
  - 100K<n<1M
  en-vi:
  - 1M<n<10M
  en-wa:
  - 100K<n<1M
  en-xh:
  - 100K<n<1M
  en-yi:
  - 10K<n<100K
  en-yo:
  - 10K<n<100K
  en-zh:
  - 1M<n<10M
  en-zu:
  - 10K<n<100K
  fr-nl:
  - 1K<n<10K
  fr-ru:
  - 1K<n<10K
  fr-zh:
  - 1K<n<10K
  nl-ru:
  - 1K<n<10K
  nl-zh:
  - 1K<n<10K
  ru-zh:
  - 1K<n<10K
licenses:
- unknown
paperswithcode_id: opus-100
---

# Dataset Card Creation Guide

## Table of Contents
- [Dataset Description](#dataset-description)
  - [Dataset Summary](#dataset-summary)
  - [Supported Tasks and Leaderboards](#supported-tasks-and-leaderboards)
  - [Languages](#languages)
- [Dataset Structure](#dataset-structure)
  - [Data Instances](#data-instances)
  - [Data Fields](#data-fields)
  - [Data Splits](#data-splits)
- [Dataset Creation](#dataset-creation)
  - [Curation Rationale](#curation-rationale)
  - [Source Data](#source-data)
  - [Annotations](#annotations)
  - [Personal and Sensitive Information](#personal-and-sensitive-information)
- [Considerations for Using the Data](#considerations-for-using-the-data)
  - [Social Impact of Dataset](#social-impact-of-dataset)
  - [Discussion of Biases](#discussion-of-biases)
  - [Other Known Limitations](#other-known-limitations)
- [Additional Information](#additional-information)
  - [Dataset Curators](#dataset-curators)
  - [Licensing Information](#licensing-information)
  - [Citation Information](#citation-information)
  - [Contributions](#contributions)

## Dataset Description

- **Homepage:** [Link](http://opus.nlpl.eu/opus-100.php) 
- **Repository:** [GitHub](https://github.com/EdinburghNLP/opus-100-corpus)
- **Paper:** [ARXIV](https://arxiv.org/abs/2004.11867)
- **Leaderboard:** 
- **Point of Contact:** 

### Dataset Summary

OPUS-100 is English-centric, meaning that all training pairs include English on either the source or target side. The corpus covers 100 languages (including English). Selected the languages based on the volume of parallel data available in OPUS.

### Supported Tasks and Leaderboards

[More Information Needed]

### Languages

OPUS-100 contains approximately 55M sentence pairs. Of the 99 language pairs, 44 have 1M sentence pairs of training data, 73 have at least 100k, and 95 have at least 10k.

## Dataset Structure

### Data Instances

[More Information Needed]

### Data Fields

- `src_tag`: `string` text in source language
- `tgt_tag`: `string` translation of source language in target language

### Data Splits

The dataset is split into training, development, and test portions. Data was prepared by randomly sampled up to 1M sentence pairs per language pair for training and up to 2000 each for development and test. To ensure that there was no overlap (at the monolingual sentence level) between the training and development/test data, they applied a filter during sampling to exclude sentences that had already been sampled. Note that this was done cross-lingually so that, for instance, an English sentence in the Portuguese-English portion of the training data could not occur in the Hindi-English test set.

## Dataset Creation

### Curation Rationale

[More Information Needed]

### Source Data

[More Information Needed]

#### Initial Data Collection and Normalization

[More Information Needed]

#### Who are the source language producers?

[More Information Needed]

### Annotations

#### Annotation process

[More Information Needed]

#### Who are the annotators?

[More Information Needed]

### Personal and Sensitive Information

[More Information Needed]

## Considerations for Using the Data

### Social Impact of Dataset

[More Information Needed]

### Discussion of Biases

[More Information Needed]

### Other Known Limitations

[More Information Needed]

## Additional Information

### Dataset Curators

[More Information Needed]

### Licensing Information

[More Information Needed]

### Citation Information

```
@misc{zhang2020improving,
      title={Improving Massively Multilingual Neural Machine Translation and Zero-Shot Translation}, 
      author={Biao Zhang and Philip Williams and Ivan Titov and Rico Sennrich},
      year={2020},
      eprint={2004.11867},
      archivePrefix={arXiv},
      primaryClass={cs.CL}
}
```

### Contributions

Thanks to [@vasudevgupta7](https://github.com/vasudevgupta7) for adding this dataset.
