---
annotations_creators:
- crowdsourced
language_creators:
- crowdsourced
languages:
- en
licenses:
- unknown
multilinguality:
- monolingual
size_categories:
- 10K<n<100K
source_datasets:
- original
task_categories:
- question-answering
task_ids:
- question-answering-other-multihop-tabular-text-qa
paperswithcode_id: hybridqa
pretty_name: HybridQA
---

# Dataset Card Creation Guide

## Table of Contents
- [Dataset Description](#dataset-description)
  - [Dataset Summary](#dataset-summary)
  - [Supported Tasks and Leaderboards](#supported-tasks-and-leaderboards)
  - [Languages](#languages)
- [Dataset Structure](#dataset-structure)
  - [Data Instances](#data-instances)
  - [Data Fields](#data-fields)
  - [Data Splits](#data-splits)
- [Dataset Creation](#dataset-creation)
  - [Curation Rationale](#curation-rationale)
  - [Source Data](#source-data)
  - [Annotations](#annotations)
  - [Personal and Sensitive Information](#personal-and-sensitive-information)
- [Considerations for Using the Data](#considerations-for-using-the-data)
  - [Social Impact of Dataset](#social-impact-of-dataset)
  - [Discussion of Biases](#discussion-of-biases)
  - [Other Known Limitations](#other-known-limitations)
- [Additional Information](#additional-information)
  - [Dataset Curators](#dataset-curators)
  - [Licensing Information](#licensing-information)
  - [Citation Information](#citation-information)
  - [Contributions](#contributions)

## Dataset Description

- **Homepage:** -
- **Repository:** [GitHub](https://github.com/wenhuchen/HybridQA)
- **Paper:** [HybridQA: A Dataset of Multi-Hop Question Answering over Tabular and Textual Data](https://arxiv.org/abs/1909.05358)
- **Leaderboard:** [HybridQA Competition](https://competitions.codalab.org/competitions/24420)
- **Point of Contact:** [Wenhu Chen](wenhuchen@cs.ucsb.edu)


### Dataset Summary

Existing question answering datasets focus on dealing with homogeneous information, based either only on text or
KB/Table information alone. However, as human knowledge is distributed over heterogeneous forms,
using homogeneous information alone might lead to severe coverage problems.
To fill in the gap, we present HybridQA, a new large-scale question-answering dataset that
requires reasoning on heterogeneous information. Each question is aligned with a Wikipedia table
and multiple free-form corpora linked with the entities in the table. The questions are designed
to aggregate both tabular information and text information, i.e.,
lack of either form would render the question unanswerable.

### Supported Tasks and Leaderboards

[More Information Needed]

### Languages

The dataset is in English language.

## Dataset Structure

### Data Instances

A typical example looks like this

```
{
    "question_id": "00009b9649d0dd0a",
    "question": "Who were the builders of the mosque in Herat with fire temples ?",
    "table_id": "List_of_mosques_in_Afghanistan_0",
    "answer_text": "Ghurids",
    "question_postag": "WP VBD DT NNS IN DT NN IN NNP IN NN NNS .",
    "table": {
        "url": "https://en.wikipedia.org/wiki/List_of_mosques_in_Afghanistan",
        "title": "List of mosques in Afghanistan",
        "header": [
            "Name",
            "Province",
            "City",
            "Year",
            "Remarks"
        ],
        "data": [
            {
                "value": "Kabul",
                "urls": [
                    {
                        "summary": "Kabul ( Persian : کابل , romanized : Kābol , Pashto : کابل , romanized : Kābəl ) is the capital and largest city of Afghanistan...",
                        "url": "/wiki/Kabul"
                    }
                ]
            }
        ]
    },
    "section_title": "",
    "section_text": "",
    "uid": "List_of_mosques_in_Afghanistan_0",
    "intro": "The following is an incomplete list of large mosques in Afghanistan:"
}
```

### Data Fields

[More Information Needed]

### Data Splits

The dataset is split into `train`, `dev` and `test` splits.

|                 | Tain   | Valid | Test  |
| --------------- | ------ | ----- | ----- |
| N. Instances    | 62682  | 3466  | 3463  |


## Dataset Creation

### Curation Rationale

[More Information Needed]

### Source Data

[More Information Needed]

#### Initial Data Collection and Normalization

[More Information Needed]

#### Who are the source language producers?

[More Information Needed]

### Annotations

[More Information Needed]

#### Annotation process

[More Information Needed]

#### Who are the annotators?

[More Information Needed]

### Personal and Sensitive Information

[More Information Needed]

## Considerations for Using the Data

### Social Impact of Dataset

[More Information Needed]

### Discussion of Biases

[More Information Needed]

### Other Known Limitations

[More Information Needed]

## Additional Information

### Dataset Curators

[More Information Needed]

### Licensing Information

[More Information Needed]

### Citation Information

[More Information Needed]
```
@article{chen2020hybridqa,
  title={HybridQA: A Dataset of Multi-Hop Question Answering over Tabular and Textual Data},
  author={Chen, Wenhu and Zha, Hanwen and Chen, Zhiyu and Xiong, Wenhan and Wang, Hong and Wang, William},
  journal={Findings of EMNLP 2020},
  year={2020}
}
```
### Contributions

Thanks to [@patil-suraj](https://github.com/patil-suraj) for adding this dataset.
