import numpy as np
import numba as nb
from numba import types
from numba.extending import overload, register_jitable
from numba.core.errors import TypingError


@register_jitable
def _np_all_flat(x):
    out = x.all()
    return out
    
@register_jitable
def _np_all_axis1(arr):
    out = np.logical_and(arr[:,0], arr[:,1])
    for idx,v in enumerate(arr[:,2:]):
        for v_2 in iter(v):
            out[idx] = np.logical_and(v_2, out[idx])
    return out

@register_jitable
def _np_all_axis0(arr):
    out = np.logical_and(arr[0], arr[1])
    for v in iter(arr[2:]):
        for idx, v_2 in enumerate(v):
            out[idx] = np.logical_and(v_2, out[idx])  
    return out

@overload(np.all)
def np_all(x, axis=None):

    # Generalization of Numba's overload for ndarray.all with axis arguments for 2D arrays. 
     

    if isinstance(axis, types.Optional):
        axis = axis.type
   
    if not isinstance(axis, (types.Integer, types.NoneType)):
        raise TypingError("'axis' must be 0, 1, or None")

    if not isinstance(x, types.Array):
        raise TypingError('Only accepts NumPy ndarray')
        
    if not (1 <= x.ndim <= 2):
        raise TypingError('Only supports 1D or 2D NumPy ndarrays')
        
    if isinstance(axis, types.NoneType):
        def _np_all_impl(x, axis=None):
            return _np_all_flat(x)
        return _np_all_impl

    elif x.ndim == 1:
        def _np_all_impl(x, axis=None):
            return _np_all_flat(x)
        return _np_all_impl
    
    elif x.ndim == 2:
        def _np_all_impl(x, axis=None): 
            if axis == 0:
                return _np_all_axis0(x)
            else:
                return _np_all_axis1(x)
        return _np_all_impl
    
    else:
        def _np_all_impl(x, axis=None):
            return _np_all_flat(x)
        return _np_all_impl

