"""
general.py: part of expfactory package

Copyright (c) 2017-2021, Vanessa Sochat
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

"""

from flask import flash, render_template, request, redirect, session

from expfactory.utils import get_post_fields

from expfactory.views.utils import perform_checks
from expfactory.server import app
from expfactory.forms import ParticipantForm
import os
import json


# Home portal to start experiments
def portal():

    form = ParticipantForm()

    if request.method == "POST":

        # Submit and valid
        if form.validate_on_submit():

            # User name is not required
            username = "You"
            if form.openid.data not in [None, ""]:
                username = form.openid.data

            subid = session.get("subid")
            if subid is None:
                subid = app.generate_subid()
                session["subid"] = subid
                app.logger.info("New session [subid] %s" % subid)

            app.randomize = form.randomize.data
            session["username"] = username
            session["experiments"] = form.exp_ids.data.split(",")  # list
            flash(
                'Participant ID: "%s" <br> Name %s <br> Randomize: "%s" <br> Experiments: %s'
                % (subid, username, app.randomize, str(form.exp_ids.data))
            )
            return redirect("/start")

        # Submit but not valid
        return render_template(
            "portal/index.html",
            experiments=app.lookup,
            base=app.base,
            randomize=app.randomize,
            form=form,
            toggleform=True,
        )

    # Not submit
    return render_template(
        "portal/index.html", experiments=app.lookup, base=app.base, form=form
    )
