/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class waterDewPointTemperatureFlash
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(waterDewPointTemperatureFlash.class);

    public waterDewPointTemperatureFlash() {
    }

    public waterDewPointTemperatureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        int iterations = 0;
        int maxNumberOfIterations = 10000;
        double funk = 0.0;
        double maxTemperature = 0.0;
        double minTemperature = 1000000.0;
        this.system.init(0);
        this.system.setNumberOfPhases(2);
        for (int k = 0; k < this.system.getPhases()[0].getNumberOfComponents(); ++k) {
            if (!this.system.getPhase(0).getComponent(k).getComponentName().equals("water") && !this.system.getPhase(0).getComponent(k).getComponentName().equals("MEG")) continue;
            this.system.setTemperature(this.system.getPhases()[0].getComponents()[k].getMeltingPointTemperature());
            for (int l = 0; l < this.system.getPhases()[0].getNumberOfComponents(); ++l) {
                this.system.getPhase(1).getComponent(l).setx(1.0E-30);
            }
            this.system.getPhase(1).getComponent(k).setx(1.0);
            this.system.init(1);
            iterations = 0;
            do {
                funk = 0.0;
                this.system.init(3);
                funk = this.system.getPhases()[0].getComponents()[k].getz();
                this.system.setTemperature(this.system.getTemperature() + 100.0 * (funk -= this.system.getPhases()[0].getBeta() * this.system.getPhases()[1].getComponents()[k].getFugacityCoefficient() / this.system.getPhases()[0].getComponents()[k].getFugacityCoefficient()));
            } while (Math.abs(funk) >= 1.0E-7 && ++iterations < maxNumberOfIterations);
            if (this.system.getTemperature() < minTemperature) {
                minTemperature = this.system.getTemperature();
            }
            if (!(this.system.getTemperature() > maxTemperature)) continue;
            maxTemperature = this.system.getTemperature();
        }
        this.system.setTemperature(maxTemperature);
    }

    @Override
    public void printToFile(String name) {
    }
}

