/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class freezingPointTemperatureFlashTR
extends constantDutyTemperatureFlash
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    public boolean noFreezeFlash = true;
    public int Niterations = 0;
    public String[] FCompNames = new String[10];
    public double[] FCompTemp = new double[10];
    public int compnr;
    public String name = "Frz";
    public boolean CCequation = true;
    static Logger logger = LogManager.getLogger(freezingPointTemperatureFlashTR.class);

    public freezingPointTemperatureFlashTR() {
    }

    public freezingPointTemperatureFlashTR(boolean Freeze) {
        this.noFreezeFlash = Freeze;
    }

    public freezingPointTemperatureFlashTR(SystemInterface system) {
        super(system);
    }

    public freezingPointTemperatureFlashTR(SystemInterface system, boolean Freeze) {
        super(system);
        this.noFreezeFlash = Freeze;
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iterations = 0;
        double deriv = 0.0;
        double funk = 0.0;
        double funkOld = 0.0;
        double maxTemperature = 0.0;
        double minTemperature = 1000000.0;
        double oldTemperature = 0.0;
        double newTemp = 0.0;
        double SolidFug = 0.0;
        double temp = 0.0;
        double pres = 0.0;
        double Pvapsolid = 0.0;
        double SolVapFugCoeff = 0.0;
        double dfugdt = 0.0;
        double solvol = 0.0;
        double soldens = 0.0;
        double trpTemp = 0.0;
        for (int k = 0; k < 1; ++k) {
            this.FCompNames[k] = this.system.getPhase(0).getComponent(k).getComponentName();
            if (this.system.getPhase(0).getComponent(k).getHsub() < 1000.0) {
                this.CCequation = false;
            }
            if (this.noFreezeFlash) {
                this.system.setTemperature(this.system.getPhases()[0].getComponents()[k].getTriplePointTemperature());
                logger.info("Starting at Triple point temperature " + this.system.getPhase(0).getComponent(k).getComponentName());
            } else {
                this.system.setTemperature(this.system.getTemperature());
                logger.info("starting at Temperature  " + this.system.getTemperature());
            }
            SystemSrkSchwartzentruberEos testSystem2 = new SystemSrkSchwartzentruberEos(this.system.getTemperature(), this.system.getPressure());
            ThermodynamicOperations testOps2 = new ThermodynamicOperations(testSystem2);
            testSystem2.addComponent(this.system.getPhase(0).getComponent(k).getComponentName(), 1.0);
            oldTemperature = 0.0;
            funkOld = 0.0;
            newTemp = 0.0;
            this.system.init(0);
            this.system.init(1);
            iterations = 0;
            trpTemp = this.system.getPhase(0).getComponent(k).getTriplePointTemperature();
            do {
                funk = 0.0;
                deriv = 0.0;
                ++iterations;
                newTemp = 0.0;
                temp = this.system.getTemperature();
                pres = this.system.getPressure();
                if (temp > trpTemp + 1.0) {
                    temp = trpTemp;
                }
                if (this.CCequation) {
                    Pvapsolid = this.system.getPhase(0).getComponent(k).getCCsolidVaporPressure(temp);
                    dfugdt = Math.log(this.system.getPhase(0).getComponent(k).getCCsolidVaporPressuredT(temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - Pvapsolid)) / pres);
                } else {
                    Pvapsolid = this.system.getPhase(0).getComponent(k).getSolidVaporPressure(temp);
                    dfugdt = Math.log(this.system.getPhase(0).getComponent(k).getSolidVaporPressuredT(temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - Pvapsolid)) / pres);
                }
                soldens = this.system.getPhase(0).getComponent(k).getPureComponentSolidDensity(temp) * 1000.0;
                logger.info("Solid density" + soldens);
                if (soldens > 2000.0) {
                    soldens = 1000.0;
                }
                solvol = 1.0 / soldens * this.system.getPhase(0).getComponent(k).getMolarMass();
                testSystem2.setTemperature(temp);
                testSystem2.setPressure(Pvapsolid);
                ops.TPflash();
                testOps2.TPflash();
                SolidFug = Pvapsolid / pres * Math.exp(solvol / (8.3144621 * temp) * (pres - Pvapsolid));
                SolVapFugCoeff = testSystem2.getPhase(0).getComponent(0).getFugacityCoefficient();
                funk = this.system.getPhases()[0].getComponents()[k].getz();
                for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
                    funk -= this.system.getPhases()[i].getBeta() * SolidFug * SolVapFugCoeff / this.system.getPhases()[i].getComponents()[k].getFugacityCoefficient();
                    deriv -= 0.01 * this.system.getPhases()[i].getBeta() * (SolidFug * SolVapFugCoeff * Math.exp(this.system.getPhases()[i].getComponents()[k].getdfugdt()) * -1.0 / Math.pow(this.system.getPhases()[i].getComponents()[k].getFugacityCoefficient(), 2.0) + Math.exp(dfugdt) / this.system.getPhases()[i].getComponents()[k].getFugacityCoefficient());
                }
                deriv = iterations >= 2 ? -(funk - funkOld) / (this.system.getTemperature() - oldTemperature) : -funk;
                oldTemperature = this.system.getTemperature();
                funkOld = funk;
                newTemp = oldTemperature < trpTemp + 1.0 ? this.system.getTemperature() + 0.5 * ((double)iterations / (10.0 + (double)iterations)) * funk / deriv : this.system.getTemperature() + 0.5 * ((double)iterations / (10.0 + (double)iterations)) * funk;
                logger.info("newTEmp  " + newTemp);
                if (newTemp > trpTemp + 5.0) {
                    this.system.setTemperature(this.system.getPhases()[0].getComponents()[k].getTriplePointTemperature() + 0.4);
                } else if (newTemp < 1.0) {
                    this.system.setTemperature(oldTemperature + 2.0);
                } else {
                    this.system.setTemperature(newTemp);
                }
                logger.info("funk " + funk);
                logger.info("temperature " + this.system.getTemperature());
            } while (Math.abs(funk) >= 0.001 && iterations < 100);
            this.FCompTemp[k] = this.system.getTemperature();
            logger.info("iterations " + iterations);
            this.Niterations = iterations;
            if (this.system.getTemperature() < minTemperature) {
                minTemperature = this.system.getTemperature();
            }
            if (!(this.system.getTemperature() > maxTemperature)) continue;
            maxTemperature = this.system.getTemperature();
        }
        this.system.setTemperature(maxTemperature);
    }

    @Override
    public void printToFile(String name) {
        for (int n = 0; n < this.system.getPhases()[0].getNumberOfComponents(); ++n) {
            name = (String)name + "_" + this.system.getPhase(0).getComponent(n).getComponentName();
        }
        String myFile = "/java/" + (String)name + ".frz";
        try (PrintWriter pr_writer = new PrintWriter(new FileWriter(myFile, true));){
            pr_writer.println("name,freezeT,freezeP,z,iterations");
            pr_writer.flush();
            for (int k = 0; k < this.system.getPhases()[0].getNumberOfComponents(); ++k) {
                pr_writer.println(this.FCompNames[k] + "," + Double.toString(this.FCompTemp[k]) + "," + this.system.getPressure() + "," + Double.toString(this.system.getPhases()[0].getComponents()[k].getz()) + "," + this.Niterations);
                pr_writer.flush();
            }
        }
        catch (SecurityException ex) {
            logger.info("writeFile: caught security exception");
        }
        catch (IOException ioe) {
            logger.info("writeFile: caught i/o exception");
        }
    }

    public int getNiterations() {
        return this.Niterations;
    }
}

