/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyFlashInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class constantDutyFlash
implements constantDutyFlashInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(constantDutyFlash.class);
    SystemInterface system;
    protected boolean superCritical = false;
    int i;
    int j = 0;
    int nummer = 0;
    int iterations = 0;
    int maxNumberOfIterations = 10000;
    double gibbsEnergy = 0.0;
    double gibbsEnergyOld = 0.0;
    double Kold;
    double deviation = 0.0;
    double g0 = 0.0;
    double g1 = 0.0;
    double[] lnOldOldK;
    double[] lnK;
    double[] lnOldK;
    double[] oldDeltalnK;
    double[] deltalnK;
    double[] tm = new double[]{1.0, 1.0};
    double beta = 1.0E-5;
    int lowestGibbsEnergyPhase = 0;

    public constantDutyFlash() {
    }

    public constantDutyFlash(SystemInterface system) {
        this.system = system;
        this.lnOldOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.oldDeltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.deltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
    }

    @Override
    public void setBeta(double beta) {
        this.beta = beta;
    }

    @Override
    public void run() {
        this.system.init(0);
        this.system.init(2);
        double deriv = 0.0;
        double funk = 0.0;
        double dkidt = 0.0;
        double dyidt = 0.0;
        double dxidt = 0.0;
        double Told = 0.0;
        do {
            int i;
            this.system.init(2);
            for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient());
                this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient());
            }
            this.system.calc_x_y();
            funk = 0.0;
            deriv = 0.0;
            for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                dkidt = (this.system.getPhases()[0].getComponents()[i].getdfugdt() - this.system.getPhases()[1].getComponents()[i].getdfugdt()) * this.system.getPhases()[0].getComponents()[i].getK();
                dxidt = -this.system.getPhases()[0].getComponents()[i].getx() * this.system.getPhases()[0].getComponents()[i].getx() * 1.0 / this.system.getPhases()[0].getComponents()[i].getz() * this.system.getBeta() * dkidt;
                dyidt = dkidt * this.system.getPhases()[0].getComponents()[i].getx() + this.system.getPhases()[0].getComponents()[i].getK() * dxidt;
                funk = funk + this.system.getPhases()[1].getComponents()[i].getx() - this.system.getPhases()[0].getComponents()[i].getx();
                deriv = deriv + dyidt - dxidt;
            }
            Told = this.system.getTemperature();
            this.system.setTemperature(Told - funk / deriv * 0.9);
            logger.info("Temp: " + this.system.getTemperature());
        } while (Math.abs((this.system.getTemperature() - Told) / this.system.getTemperature()) > 1.0E-7);
    }

    @Override
    public double[][] getPoints(int i) {
        return null;
    }

    @Override
    public double[] get(String name) {
        return null;
    }

    @Override
    public void displayResult() {
        this.system.display();
    }

    @Override
    public boolean isSuperCritical() {
        return this.superCritical;
    }

    public void setSuperCritical(boolean superCritical) {
        this.superCritical = superCritical;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    @Override
    public void addData(String name, double[][] data) {
    }
}

