/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateInhibitorwtFlash
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    double wtfrac = 0.5;
    String inhibitor = "MEG";
    static Logger logger = LogManager.getLogger(HydrateInhibitorwtFlash.class);

    public HydrateInhibitorwtFlash() {
    }

    public HydrateInhibitorwtFlash(SystemInterface system, String inhibitor, double wtfr) {
        super(system);
        this.wtfrac = wtfr;
        this.inhibitor = inhibitor;
    }

    public void stop() {
        this.system = null;
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iter = 0;
        double error = 1.0;
        double oldError = 1.0;
        double oldC = this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles();
        double derrordC = 1.0;
        do {
            ++iter;
            try {
                derrordC = (error - oldError) / (this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles() - oldC);
                oldError = error;
                oldC = this.system.getPhase(0).getComponent(this.inhibitor).getNumberOfmoles();
                if (iter < 4) {
                    this.system.addComponent(this.inhibitor, error * 0.01);
                } else {
                    double newC = -error / derrordC;
                    double correction = newC * 0.5;
                    this.system.addComponent(this.inhibitor, correction);
                }
                this.system.init(0);
                this.system.init(1);
                ops.TPflash();
                double wtp = 0.0;
                if (this.system.hasPhaseType("aqueous")) {
                    wtp = this.system.getPhase("aqueous").getComponent(this.inhibitor).getx() * this.system.getPhase("aqueous").getComponent(this.inhibitor).getMolarMass() / (this.system.getPhase("aqueous").getComponent(this.inhibitor).getx() * this.system.getPhase("aqueous").getComponent(this.inhibitor).getMolarMass() + this.system.getPhase("aqueous").getComponent("water").getx() * this.system.getPhase("aqueous").getComponent("water").getMolarMass());
                } else {
                    this.system.addComponent(this.inhibitor, this.system.getTotalNumberOfMoles());
                    ops.TPflash();
                    wtp = this.system.getPhase("aqueous").getComponent(this.inhibitor).getx() * this.system.getPhase("aqueous").getComponent(this.inhibitor).getMolarMass() / (this.system.getPhase("aqueous").getComponent(this.inhibitor).getx() * this.system.getPhase("aqueous").getComponent(this.inhibitor).getMolarMass() + this.system.getPhase("aqueous").getComponent("water").getx() * this.system.getPhase("aqueous").getComponent("water").getMolarMass());
                }
                error = -(wtp - this.wtfrac);
                logger.info("error " + error);
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
            }
        } while (Math.abs(error) > 1.0E-5 && iter < 100 || iter < 3);
    }

    @Override
    public void printToFile(String name) {
    }

    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(273.15, 100.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("nitrogen", 79.0);
        testSystem.addComponent("oxygen", 21.0);
        testSystem.addComponent("MEG", 1.0E-6);
        testSystem.addComponent("water", 0.001);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.init(0);
        testSystem.setMultiPhaseCheck(true);
        testSystem.setHydrateCheck(true);
        try {
            testOps.hydrateInhibitorConcentrationSet("MEG", 0.99);
            double cons = 100.0 * testSystem.getPhase(0).getComponent("MEG").getNumberOfmoles() * testSystem.getPhase(0).getComponent("MEG").getMolarMass() / (testSystem.getPhase(0).getComponent("MEG").getNumberOfmoles() * testSystem.getPhase(0).getComponent("MEG").getMolarMass() + testSystem.getPhase(0).getComponent("water").getNumberOfmoles() * testSystem.getPhase(0).getComponent("water").getMolarMass());
            logger.info("hydrate inhibitor concentration " + cons + " wt%");
        }
        catch (Exception ex) {
            ex.toString();
        }
        testSystem.display();
    }
}

