/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FreezeOut
extends constantDutyTemperatureFlash
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FreezeOut.class);
    public double[] FCompTemp = new double[10];
    public String[] FCompNames = new String[10];
    public boolean noFreezeFlash = true;

    public FreezeOut() {
    }

    public FreezeOut(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        SystemInterface testSystem = this.system;
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        int iterations = 0;
        double newTemp = 0.0;
        double OldTemp = 0.0;
        double T2low = 0.0;
        double T2high = 0.0;
        boolean Left = true;
        boolean half = false;
        double SolidFug = 0.0;
        double FluidFug = 0.0;
        double temp = 0.0;
        double pres = 0.0;
        double Pvapsolid = 0.0;
        double solvol = 0.0;
        double soldens = 0.0;
        double trpTemp = 0.0;
        boolean CCequation = true;
        boolean noFreezeliq = true;
        boolean SolidForms = true;
        double maximum = 0.0;
        for (int k = 0; k < testSystem.getPhase(0).getNumberOfComponents(); ++k) {
            double FugRatio;
            this.FCompNames[k] = testSystem.getPhase(0).getComponent(k).getComponentName();
            if (!testSystem.getPhase(0).getComponent(k).doSolidCheck()) continue;
            trpTemp = testSystem.getPhases()[0].getComponents()[k].getTriplePointTemperature();
            if (this.noFreezeFlash) {
                testSystem.setTemperature(trpTemp);
                logger.info("Starting at Triple point temperature " + this.system.getPhase(0).getComponent(k).getComponentName());
            } else {
                testSystem.setTemperature(this.FCompTemp[k]);
                logger.info("starting at Temperature  " + this.system.getTemperature());
            }
            SystemSrkSchwartzentruberEos testSystem2 = new SystemSrkSchwartzentruberEos(216.0, 1.0);
            ThermodynamicOperations testOps2 = new ThermodynamicOperations(testSystem2);
            testSystem2.addComponent(testSystem.getPhase(0).getComponent(k).getComponentName(), 1.0);
            testSystem2.setPhaseType(0, 1);
            noFreezeliq = true;
            SolidFug = 0.0;
            FluidFug = 0.0;
            SolidForms = true;
            temp = 0.0;
            Pvapsolid = 0.0;
            iterations = 0;
            half = false;
            T2high = trpTemp + 0.1;
            if (Math.abs(testSystem.getPhases()[0].getComponents()[k].getHsub()) < 1.0) {
                CCequation = false;
            }
            do {
                ++iterations;
                logger.info("-------------");
                temp = testSystem.getTemperature();
                logger.info("temperature " + temp);
                if (temp > trpTemp + 0.01) {
                    temp = trpTemp;
                }
                Pvapsolid = CCequation ? testSystem.getPhase(0).getComponent(k).getCCsolidVaporPressure(temp) : testSystem.getPhase(0).getComponent(k).getSolidVaporPressure(temp);
                soldens = testSystem.getPhase(0).getComponent(k).getPureComponentSolidDensity(temp) * 1000.0;
                if (soldens > 2000.0) {
                    soldens = 1000.0;
                }
                solvol = 1.0 / soldens * testSystem.getPhase(0).getComponent(k).getMolarMass();
                logger.info("solid density " + soldens);
                testSystem.setTemperature(temp);
                testSystem2.setTemperature(temp);
                testSystem2.setPressure(Pvapsolid);
                testOps.TPflash();
                testOps2.TPflash();
                logger.info("Partial pressure " + testSystem.getPhase(1).getComponent(k).getx() * testSystem.getPressure());
                SolidFug = Pvapsolid * testSystem2.getPhase(0).getComponent(0).getFugacityCoefficient() * Math.exp(solvol / (8.3144621 * temp) * (pres - Pvapsolid));
                FluidFug = testSystem.getPhase(0).getFugacity(k);
                FugRatio = SolidFug / FluidFug;
                OldTemp = testSystem.getTemperature();
                logger.info("Temperature " + OldTemp);
                logger.info("FugRatio solid/fluidphase " + FugRatio);
                if (1.0 < FugRatio) {
                    if (OldTemp < trpTemp / 3.0) {
                        SolidForms = false;
                    }
                    T2high = OldTemp;
                    newTemp = half ? 0.5 * (T2low + T2high) : (1.5 > FugRatio ? OldTemp - trpTemp * 0.1 : (1.5 < FugRatio ? OldTemp - trpTemp * 0.15 : OldTemp - trpTemp * 0.15));
                    Left = false;
                } else if (1.0 > FugRatio) {
                    if (Left && OldTemp - trpTemp > 0.0) {
                        noFreezeliq = false;
                    }
                    T2low = OldTemp;
                    Left = true;
                    half = true;
                    newTemp = 0.5 * (T2low + T2high);
                }
                testSystem.setTemperature(newTemp);
            } while (Math.abs(FugRatio - 1.0) >= 1.0E-5 && iterations < 100 && noFreezeliq && SolidForms);
            logger.info("noFreezeliq: " + noFreezeliq + " SolidForms: " + SolidForms);
            if (noFreezeliq && SolidForms) {
                testSystem.setTemperature(OldTemp);
                this.FCompTemp[k] = OldTemp;
            } else if (!noFreezeliq) {
                testSystem.setTemperature(OldTemp);
                this.FCompTemp[k] = OldTemp;
                logger.error("Freezing Temperature not found");
            } else {
                testSystem.setTemperature(1000.0);
                this.FCompTemp[k] = OldTemp;
            }
            logger.info("Iterations :" + iterations);
        }
        maximum = this.FCompTemp[0];
        for (int i = 1; i < this.FCompTemp.length; ++i) {
            if (!(this.FCompTemp[i] > maximum)) continue;
            maximum = this.FCompTemp[i];
        }
        testSystem.setTemperature(maximum);
    }

    @Override
    public void printToFile(String name) {
        for (int n = 0; n < this.system.getPhases()[0].getNumberOfComponents(); ++n) {
            name = (String)name + "_" + this.system.getPhase(0).getComponent(n).getComponentName();
        }
        String myFile = "/java/" + (String)name + ".frz";
        try (PrintWriter pr_writer = new PrintWriter(new FileWriter(myFile, true));){
            pr_writer.println("name,freezeT,freezeP,z,iterations");
            pr_writer.flush();
            for (int k = 0; k < this.system.getPhases()[0].getNumberOfComponents(); ++k) {
                pr_writer.println(this.FCompNames[k] + "," + Double.toString(this.FCompTemp[k]) + "," + this.system.getPressure() + "," + Double.toString(this.system.getPhases()[0].getComponents()[k].getz()));
                pr_writer.flush();
            }
        }
        catch (SecurityException ex) {
            logger.error("writeFile: caught security exception");
        }
        catch (IOException ioe) {
            logger.error("writeFile: caught i/o exception");
        }
    }
}

